/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.util;

import com.authlete.common.dto.TaggedValue;
import com.authlete.common.util.MapControl;
import com.authlete.common.util.Utils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MapUtils {
    public static void put(Map<String, Object> target, String key, boolean value, boolean falseIncluded) {
        if (value || falseIncluded) {
            target.put(key, value);
        }
    }

    public static void put(Map<String, Object> target, String key, int value, boolean zeroIncluded) {
        if (value != 0 || zeroIncluded) {
            target.put(key, value);
        }
    }

    public static void put(Map<String, Object> target, String key, long value, boolean zeroIncluded) {
        if (value != 0L || zeroIncluded) {
            target.put(key, value);
        }
    }

    public static void put(Map<String, Object> target, String key, Map<String, Object> value, boolean nullIncluded) {
        if (value != null) {
            target.put(key, value);
        } else if (nullIncluded) {
            target.put(key, null);
        }
    }

    public static <T> void put(Map<String, Object> target, String key, T value, boolean nullIncluded) {
        if (value != null) {
            target.put(key, value.toString());
        } else if (nullIncluded) {
            target.put(key, null);
        }
    }

    public static <T> void put(Map<String, Object> target, String key, T[] array, boolean nullIncluded) {
        List<String> list = MapUtils.asList(array);
        if (list != null || nullIncluded) {
            target.put(key, list);
        }
    }

    public static void put(Map<String, Object> target, String baseKey, TaggedValue[] array, boolean nullIncluded) {
        if (array == null) {
            return;
        }
        for (TaggedValue taggedValue : array) {
            MapUtils.putTaggedValue(target, baseKey, taggedValue, nullIncluded);
        }
    }

    private static void putTaggedValue(Map<String, Object> target, String baseKey, TaggedValue taggedValue, boolean nullIncluded) {
        if (taggedValue == null) {
            return;
        }
        String tag = taggedValue.getTag();
        if (tag == null || tag.isEmpty()) {
            return;
        }
        String value = taggedValue.getValue();
        if (value == null && !nullIncluded) {
            return;
        }
        target.put(String.format("%s#%s", baseKey, tag), value);
    }

    public static void putJsonObject(Map<String, Object> target, String key, String json, boolean nullIncluded) {
        Map value;
        Map map = value = json == null ? null : Utils.fromJson(json, Map.class);
        if (value != null || nullIncluded) {
            target.put(key, value);
        }
    }

    public static void putJsonArray(Map<String, Object> target, String key, String json, boolean nullIncluded) {
        List value;
        List list = value = json == null ? null : Utils.fromJson(json, List.class);
        if (value != null || nullIncluded) {
            target.put(key, value);
        }
    }

    private static <T> List<String> asList(T[] array) {
        if (array == null) {
            return null;
        }
        return Arrays.stream(array).map(element -> element.toString()).collect(Collectors.toList());
    }

    public static void put(Map<String, Object> target, Map<String, Object> map, MapControl control) {
        if (control == null) {
            control = new MapControl();
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            MapUtils.putEntry(target, entry, control);
        }
    }

    private static void putEntry(Map<String, Object> target, Map.Entry<String, Object> entry, MapControl control) {
        String key = entry.getKey();
        Object value = entry.getValue();
        if (value instanceof Boolean) {
            MapUtils.putEntryBoolean(target, key, (Boolean)value, control);
        } else if (value instanceof Integer) {
            MapUtils.putEntryInteger(target, key, (Integer)value, control);
        } else if (value instanceof Number) {
            MapUtils.putEntryNumber(target, key, (Number)value, control);
        } else {
            MapUtils.putEntryDefault(target, key, value, control);
        }
    }

    private static void putEntryBoolean(Map<String, Object> target, String key, Boolean value, MapControl control) {
        boolean value_ = value;
        if (value_ || control.isFalseIncluded()) {
            target.put(key, value_);
        }
    }

    private static void putEntryInteger(Map<String, Object> target, String key, Integer value, MapControl control) {
        int value_ = value;
        if (value_ != 0 || control.isZeroIncluded()) {
            target.put(key, value_);
        }
    }

    private static void putEntryNumber(Map<String, Object> target, String key, Number value, MapControl control) {
        long value_ = value.longValue();
        if (value_ != 0L || control.isZeroIncluded()) {
            target.put(key, value_);
        }
    }

    private static void putEntryDefault(Map<String, Object> target, String key, Object value, MapControl control) {
        if (value != null || control.isNullIncluded()) {
            target.put(key, value);
        }
    }
}

