/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class MutableJsonPointer {
    private final LinkedList<String> mReferenceTokens = new LinkedList();

    public MutableJsonPointer() {
        this((String)null);
    }

    public MutableJsonPointer(MutableJsonPointer pointer) {
        if (pointer != null) {
            this.mReferenceTokens.addAll(pointer.mReferenceTokens);
        }
    }

    public MutableJsonPointer(String pointer) {
        if (pointer == null) {
            return;
        }
        if (pointer.isEmpty()) {
            return;
        }
        if (!pointer.startsWith("/")) {
            throw new IllegalArgumentException("A pointer must start with '/' unless it is an empty string.");
        }
        Arrays.stream(pointer.split("/")).skip(1L).forEach(referenceToken -> this.mReferenceTokens.add((String)referenceToken));
    }

    public MutableJsonPointer append(String referenceToken, boolean doEscape) {
        if (doEscape) {
            referenceToken = MutableJsonPointer.escape(referenceToken);
        }
        this.mReferenceTokens.add(referenceToken);
        return this;
    }

    public MutableJsonPointer append(String referenceToken) {
        return this.append(referenceToken, true);
    }

    public MutableJsonPointer append(int arrayIndex) {
        if (arrayIndex < 0) {
            throw new IllegalArgumentException("The argument to append(int) must not be negative.");
        }
        return this.append(String.valueOf(arrayIndex), false);
    }

    public MutableJsonPointer remove() {
        this.mReferenceTokens.pollLast();
        return this;
    }

    public String toString() {
        if (this.mReferenceTokens.size() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        this.mReferenceTokens.stream().forEach(referenceToken -> builder.append("/").append((String)referenceToken));
        return builder.toString();
    }

    public List<String> getReferenceTokens() {
        return Collections.unmodifiableList(this.mReferenceTokens);
    }

    public static String escape(String input) {
        if (input == null) {
            return null;
        }
        return input.replaceAll("~", "~0").replaceAll("/", "~1");
    }

    public static String unescape(String input) {
        if (input == null) {
            return null;
        }
        return input.replaceAll("~1", "/").replaceAll("~0", "~");
    }
}

