/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.util;

import com.authlete.common.dto.Property;
import com.authlete.common.dto.Scope;
import com.authlete.common.types.Prompt;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;

public class Utils {
    private static final Gson GSON = Utils.gsonBuilder().create();
    private static final Gson PRETTY_GSON = Utils.gsonBuilder().setPrettyPrinting().create();

    private Utils() {
    }

    private static GsonBuilder gsonBuilder() {
        return new GsonBuilder().serializeNulls().setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE);
    }

    public static String join(String[] strings, String delimiter) {
        if (strings == null) {
            return null;
        }
        if (strings.length == 0) {
            return "";
        }
        boolean useDelimiter = delimiter != null && delimiter.length() != 0;
        StringBuilder sb = new StringBuilder();
        for (String string : strings) {
            sb.append(string);
            if (useDelimiter) {
                // empty if block
            }
            sb.append(delimiter);
        }
        if (useDelimiter && sb.length() != 0) {
            sb.setLength(sb.length() - delimiter.length());
        }
        return sb.toString();
    }

    public static String toJson(Object object) {
        return Utils.toJson(object, false);
    }

    public static String toJson(Object object, boolean pretty) {
        if (object == null) {
            return null;
        }
        if (pretty) {
            return PRETTY_GSON.toJson(object);
        }
        return GSON.toJson(object);
    }

    public static <T> T fromJson(String json, Class<T> klass) {
        return (T)GSON.fromJson(json, klass);
    }

    public static String stringifyProperties(Property[] properties) {
        if (properties == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Property property : properties) {
            if (property == null) continue;
            sb.append(property.getKey());
            sb.append("=");
            sb.append(property.getValue());
            sb.append(",");
        }
        if (0 < sb.length()) {
            sb.setLength(sb.length() - 1);
        }
        sb.insert(0, "[");
        sb.append("]");
        return sb.toString();
    }

    public static String stringifyPrompts(Prompt[] prompts) {
        if (prompts == null) {
            return null;
        }
        String[] array = new String[prompts.length];
        for (int i = 0; i < prompts.length; ++i) {
            array[i] = prompts[i] == null ? null : prompts[i].name().toLowerCase();
        }
        return Utils.join(array, " ");
    }

    public static String stringifyScopeNames(Scope[] scopes) {
        if (scopes == null) {
            return null;
        }
        String[] array = new String[scopes.length];
        for (int i = 0; i < scopes.length; ++i) {
            array[i] = scopes[i] == null ? null : scopes[i].getName();
        }
        return Utils.join(array, " ");
    }
}

