/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.common.web;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BearerToken {
    private static final Pattern CHALLENGE_PATTERN = Pattern.compile("^Bearer *([^ ]+) *$", 2);

    private BearerToken() {
    }

    public static String parse(String input) {
        if (input == null) {
            return null;
        }
        Matcher matcher = CHALLENGE_PATTERN.matcher(input);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return BearerToken.extractFromFormParameters(input);
    }

    private static String extractFromFormParameters(String input) {
        for (String parameter : input.split("&")) {
            String[] pair = parameter.split("=", 2);
            if (pair == null || pair.length != 2 || pair[1].length() == 0 || !pair[0].equals("access_token")) continue;
            try {
                return URLDecoder.decode(pair[1], "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        return null;
    }
}

