/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer;

import com.azure.ai.formrecognizer.Transforms;
import com.azure.ai.formrecognizer.implementation.models.Model;
import com.azure.ai.formrecognizer.implementation.models.ModelInfo;
import com.azure.ai.formrecognizer.implementation.models.ModelStatus;
import com.azure.ai.formrecognizer.models.CustomFormModel;
import com.azure.ai.formrecognizer.models.CustomFormModelField;
import com.azure.ai.formrecognizer.models.CustomFormModelInfo;
import com.azure.ai.formrecognizer.models.CustomFormModelStatus;
import com.azure.ai.formrecognizer.models.CustomFormSubModel;
import com.azure.ai.formrecognizer.models.ErrorInformation;
import com.azure.ai.formrecognizer.models.FormRecognizerError;
import com.azure.ai.formrecognizer.models.TrainingDocumentInfo;
import com.azure.ai.formrecognizer.models.TrainingStatus;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;

final class CustomModelTransforms {
    private static final ClientLogger LOGGER = new ClientLogger(CustomModelTransforms.class);

    private CustomModelTransforms() {
    }

    static CustomFormModel toCustomFormModel(Model modelResponse) {
        ModelInfo modelInfo = modelResponse.getModelInfo();
        if (modelInfo.getStatus() == ModelStatus.INVALID) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("Model Id %s returned with invalid status.", modelInfo.getModelId())));
        }
        List<TrainingDocumentInfo> trainingDocumentInfoList = null;
        List<FormRecognizerError> modelErrors = null;
        if (modelResponse.getTrainResult() != null) {
            trainingDocumentInfoList = modelResponse.getTrainResult().getTrainingDocuments().stream().map(trainingDocumentItem -> new TrainingDocumentInfo(trainingDocumentItem.getDocumentName(), TrainingStatus.fromString(trainingDocumentItem.getStatus().toString()), trainingDocumentItem.getPages(), CustomModelTransforms.transformTrainingErrors(trainingDocumentItem.getErrors()))).collect(Collectors.toList());
            modelErrors = CustomModelTransforms.transformTrainingErrors(modelResponse.getTrainResult().getErrors());
        }
        ArrayList<CustomFormSubModel> subModelList = new ArrayList<CustomFormSubModel>();
        String formType = "form-";
        if (modelResponse.getKeys() != null) {
            TreeMap fieldMap = new TreeMap();
            modelResponse.getKeys().getClusters().forEach((clusterKey, clusterFields) -> {
                Transforms.forEachWithIndex(clusterFields, (index, eachField) -> {
                    String fieldName = "field-" + index;
                    fieldMap.put(fieldName, new CustomFormModelField((String)eachField, fieldName, null));
                });
                subModelList.add(new CustomFormSubModel(null, fieldMap, formType + clusterKey));
            });
        } else if (modelResponse.getTrainResult() != null && modelResponse.getTrainResult().getFields() != null) {
            TreeMap<String, CustomFormModelField> fieldMap = new TreeMap<String, CustomFormModelField>();
            modelResponse.getTrainResult().getFields().forEach(formFieldsReport -> fieldMap.put(formFieldsReport.getFieldName(), new CustomFormModelField(null, formFieldsReport.getFieldName(), Float.valueOf(formFieldsReport.getAccuracy()))));
            subModelList.add(new CustomFormSubModel(modelResponse.getTrainResult().getAverageModelAccuracy(), fieldMap, formType + modelInfo.getModelId()));
        }
        return new CustomFormModel(modelInfo.getModelId().toString(), CustomFormModelStatus.fromString(modelInfo.getStatus().toString()), modelInfo.getCreatedDateTime(), modelInfo.getLastUpdatedDateTime(), (IterableStream<CustomFormSubModel>)new IterableStream(subModelList), modelErrors, trainingDocumentInfoList);
    }

    static List<CustomFormModelInfo> toCustomFormModelInfo(List<ModelInfo> modelInfoList) {
        return modelInfoList.stream().map(modelInfo -> new CustomFormModelInfo(modelInfo.getModelId().toString(), CustomFormModelStatus.fromString(modelInfo.getStatus().toString()), modelInfo.getCreatedDateTime(), modelInfo.getLastUpdatedDateTime())).collect(Collectors.toList());
    }

    private static List<FormRecognizerError> transformTrainingErrors(List<ErrorInformation> trainingErrorList) {
        if (CoreUtils.isNullOrEmpty(trainingErrorList)) {
            return Collections.emptyList();
        }
        return trainingErrorList.stream().map(errorInformation -> new FormRecognizerError(errorInformation.getCode(), errorInformation.getMessage())).collect(Collectors.toList());
    }
}

