/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer;

import com.azure.ai.formrecognizer.FormRecognizerClientBuilder;
import com.azure.ai.formrecognizer.FormRecognizerServiceVersion;
import com.azure.ai.formrecognizer.FormTrainingAsyncClient;
import com.azure.ai.formrecognizer.Transforms;
import com.azure.ai.formrecognizer.implementation.FormRecognizerClientImpl;
import com.azure.ai.formrecognizer.implementation.Utility;
import com.azure.ai.formrecognizer.implementation.models.AnalyzeLayoutAsyncHeaders;
import com.azure.ai.formrecognizer.implementation.models.AnalyzeOperationResult;
import com.azure.ai.formrecognizer.implementation.models.AnalyzeReceiptAsyncHeaders;
import com.azure.ai.formrecognizer.implementation.models.AnalyzeWithCustomModelHeaders;
import com.azure.ai.formrecognizer.implementation.models.ContentType;
import com.azure.ai.formrecognizer.implementation.models.OperationStatus;
import com.azure.ai.formrecognizer.implementation.models.SourcePath;
import com.azure.ai.formrecognizer.models.ErrorInformation;
import com.azure.ai.formrecognizer.models.ErrorResponseException;
import com.azure.ai.formrecognizer.models.FormContentType;
import com.azure.ai.formrecognizer.models.FormPage;
import com.azure.ai.formrecognizer.models.OperationResult;
import com.azure.ai.formrecognizer.models.RecognizedForm;
import com.azure.ai.formrecognizer.models.RecognizedReceipt;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class FormRecognizerAsyncClient {
    private final ClientLogger logger = new ClientLogger(FormRecognizerAsyncClient.class);
    private final FormRecognizerClientImpl service;
    private final FormRecognizerServiceVersion serviceVersion;

    FormRecognizerAsyncClient(FormRecognizerClientImpl service, FormRecognizerServiceVersion serviceVersion) {
        this.service = service;
        this.serviceVersion = serviceVersion;
    }

    public FormTrainingAsyncClient getFormTrainingAsyncClient() {
        return new FormTrainingAsyncClient(this.service, this.serviceVersion);
    }

    public FormRecognizerServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public PollerFlux<OperationResult, IterableStream<RecognizedForm>> beginRecognizeCustomFormsFromUrl(String fileSourceUrl, String modelId) {
        return this.beginRecognizeCustomFormsFromUrl(fileSourceUrl, modelId, false, null);
    }

    public PollerFlux<OperationResult, IterableStream<RecognizedForm>> beginRecognizeCustomFormsFromUrl(String fileSourceUrl, String modelId, boolean includeTextDetails, Duration pollInterval) {
        Duration interval = pollInterval != null ? pollInterval : FormRecognizerClientBuilder.DEFAULT_DURATION;
        return new PollerFlux(interval, this.analyzeFormActivationOperation(fileSourceUrl, modelId, includeTextDetails), this.createAnalyzeFormPollOperation(modelId), (activationResponse, context) -> Mono.error((Throwable)new RuntimeException("Cancellation is not supported")), this.fetchAnalyzeFormResultOperation(modelId, includeTextDetails));
    }

    public PollerFlux<OperationResult, IterableStream<RecognizedForm>> beginRecognizeCustomForms(Flux<ByteBuffer> data, String modelId, long length, FormContentType formContentType) {
        return this.beginRecognizeCustomForms(data, modelId, length, formContentType, false, null);
    }

    public PollerFlux<OperationResult, IterableStream<RecognizedForm>> beginRecognizeCustomForms(Flux<ByteBuffer> data, String modelId, long length, FormContentType formContentType, boolean includeTextDetails, Duration pollInterval) {
        Duration interval = pollInterval != null ? pollInterval : FormRecognizerClientBuilder.DEFAULT_DURATION;
        return new PollerFlux(interval, this.analyzeFormStreamActivationOperation(data, modelId, length, formContentType, includeTextDetails), this.createAnalyzeFormPollOperation(modelId), (activationResponse, context) -> Mono.error((Throwable)new RuntimeException("Cancellation is not supported")), this.fetchAnalyzeFormResultOperation(modelId, includeTextDetails));
    }

    public PollerFlux<OperationResult, IterableStream<FormPage>> beginRecognizeContentFromUrl(String fileSourceUrl) {
        return this.beginRecognizeContentFromUrl(fileSourceUrl, null);
    }

    public PollerFlux<OperationResult, IterableStream<FormPage>> beginRecognizeContentFromUrl(String sourceUrl, Duration pollInterval) {
        Duration interval = pollInterval != null ? pollInterval : FormRecognizerClientBuilder.DEFAULT_DURATION;
        return new PollerFlux(interval, this.contentAnalyzeActivationOperation(sourceUrl), this.extractContentPollOperation(), (activationResponse, context) -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new RuntimeException("Cancellation is not supported")), this.fetchExtractContentResult());
    }

    public PollerFlux<OperationResult, IterableStream<FormPage>> beginRecognizeContent(Flux<ByteBuffer> data, long length, FormContentType formContentType) {
        return this.beginRecognizeContent(data, length, formContentType, null);
    }

    public PollerFlux<OperationResult, IterableStream<FormPage>> beginRecognizeContent(Flux<ByteBuffer> data, long length, FormContentType formContentType, Duration pollInterval) {
        return new PollerFlux(pollInterval != null ? pollInterval : FormRecognizerClientBuilder.DEFAULT_DURATION, this.contentStreamActivationOperation(data, length, formContentType), this.extractContentPollOperation(), (activationResponse, context) -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new RuntimeException("Cancellation is not supported")), this.fetchExtractContentResult());
    }

    public PollerFlux<OperationResult, IterableStream<RecognizedReceipt>> beginRecognizeReceiptsFromUrl(String sourceUrl) {
        return this.beginRecognizeReceiptsFromUrl(sourceUrl, false, null);
    }

    public PollerFlux<OperationResult, IterableStream<RecognizedReceipt>> beginRecognizeReceiptsFromUrl(String sourceUrl, boolean includeTextDetails, Duration pollInterval) {
        Duration interval = pollInterval != null ? pollInterval : FormRecognizerClientBuilder.DEFAULT_DURATION;
        return new PollerFlux(interval, this.receiptAnalyzeActivationOperation(sourceUrl, includeTextDetails), this.extractReceiptPollOperation(), (activationResponse, context) -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new RuntimeException("Cancellation is not supported")), this.fetchExtractReceiptResult(includeTextDetails));
    }

    public PollerFlux<OperationResult, IterableStream<RecognizedReceipt>> beginRecognizeReceipts(Flux<ByteBuffer> data, long length, FormContentType formContentType) {
        return this.beginRecognizeReceipts(data, length, formContentType, false, null);
    }

    public PollerFlux<OperationResult, IterableStream<RecognizedReceipt>> beginRecognizeReceipts(Flux<ByteBuffer> data, long length, FormContentType formContentType, boolean includeTextDetails, Duration pollInterval) {
        return new PollerFlux(pollInterval != null ? pollInterval : FormRecognizerClientBuilder.DEFAULT_DURATION, this.receiptStreamActivationOperation(data, length, formContentType, includeTextDetails), this.extractReceiptPollOperation(), (activationResponse, context) -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new RuntimeException("Cancellation is not supported")), this.fetchExtractReceiptResult(includeTextDetails));
    }

    private Function<PollingContext<OperationResult>, Mono<OperationResult>> receiptAnalyzeActivationOperation(String sourceUrl, boolean includeTextDetails) {
        return pollingContext -> {
            try {
                Objects.requireNonNull(sourceUrl, "'sourceUrl' is required and cannot be null.");
                return this.service.analyzeReceiptAsyncWithResponseAsync(includeTextDetails, new SourcePath().setSource(sourceUrl)).map(response -> new OperationResult(Utility.parseModelId(((AnalyzeReceiptAsyncHeaders)response.getDeserializedHeaders()).getOperationLocation())));
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<OperationResult>, Mono<OperationResult>> receiptStreamActivationOperation(Flux<ByteBuffer> data, long length, FormContentType formContentType, boolean includeTextDetails) {
        return pollingContext -> {
            try {
                Objects.requireNonNull(data, "'data' is required and cannot be null.");
                if (formContentType != null) {
                    return this.service.analyzeReceiptAsyncWithResponseAsync(ContentType.fromString(formContentType.toString()), data, length, includeTextDetails).map(response -> new OperationResult(Utility.parseModelId(((AnalyzeReceiptAsyncHeaders)response.getDeserializedHeaders()).getOperationLocation())));
                }
                return Utility.detectContentType(data).flatMap(contentType -> this.service.analyzeReceiptAsyncWithResponseAsync((ContentType)((Object)((Object)contentType)), data, length, includeTextDetails).map(response -> new OperationResult(Utility.parseModelId(((AnalyzeReceiptAsyncHeaders)response.getDeserializedHeaders()).getOperationLocation()))));
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<OperationResult>, Mono<PollResponse<OperationResult>>> extractReceiptPollOperation() {
        return pollingContext -> {
            try {
                PollResponse operationResultPollResponse = pollingContext.getLatestResponse();
                UUID resultUid = UUID.fromString(((OperationResult)operationResultPollResponse.getValue()).getResultId());
                return this.service.getAnalyzeReceiptResultWithResponseAsync(resultUid).flatMap(modelSimpleResponse -> FormRecognizerAsyncClient.processAnalyzeModelResponse((SimpleResponse<AnalyzeOperationResult>)modelSimpleResponse, (PollResponse<OperationResult>)operationResultPollResponse));
            }
            catch (HttpResponseException e) {
                this.logger.logExceptionAsError((RuntimeException)((Object)e));
                return Mono.just((Object)new PollResponse(LongRunningOperationStatus.FAILED, null));
            }
        };
    }

    private Function<PollingContext<OperationResult>, Mono<IterableStream<RecognizedReceipt>>> fetchExtractReceiptResult(boolean includeTextDetails) {
        return pollingContext -> {
            try {
                UUID resultUid = UUID.fromString(((OperationResult)pollingContext.getLatestResponse().getValue()).getResultId());
                return this.service.getAnalyzeReceiptResultWithResponseAsync(resultUid).map(modelSimpleResponse -> {
                    this.throwIfAnalyzeStatusInvalid((SimpleResponse<AnalyzeOperationResult>)modelSimpleResponse);
                    return Transforms.toReceipt(((AnalyzeOperationResult)modelSimpleResponse.getValue()).getAnalyzeResult(), includeTextDetails);
                });
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<OperationResult>, Mono<OperationResult>> contentAnalyzeActivationOperation(String sourceUrl) {
        return pollingContext -> {
            try {
                Objects.requireNonNull(sourceUrl, "'sourceUrl' is required and cannot be null.");
                return this.service.analyzeLayoutAsyncWithResponseAsync(new SourcePath().setSource(sourceUrl)).map(response -> new OperationResult(Utility.parseModelId(((AnalyzeLayoutAsyncHeaders)response.getDeserializedHeaders()).getOperationLocation())));
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<OperationResult>, Mono<OperationResult>> contentStreamActivationOperation(Flux<ByteBuffer> data, long length, FormContentType formContentType) {
        return pollingContext -> {
            try {
                Objects.requireNonNull(data, "'data' is required and cannot be null.");
                if (formContentType != null) {
                    return this.service.analyzeLayoutAsyncWithResponseAsync(ContentType.fromString(formContentType.toString()), data, length).map(response -> new OperationResult(Utility.parseModelId(((AnalyzeLayoutAsyncHeaders)response.getDeserializedHeaders()).getOperationLocation())));
                }
                return Utility.detectContentType(data).flatMap(contentType -> this.service.analyzeLayoutAsyncWithResponseAsync((ContentType)((Object)((Object)contentType)), data, length).map(response -> new OperationResult(Utility.parseModelId(((AnalyzeLayoutAsyncHeaders)response.getDeserializedHeaders()).getOperationLocation()))));
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<OperationResult>, Mono<PollResponse<OperationResult>>> extractContentPollOperation() {
        return pollingContext -> {
            try {
                PollResponse operationResultPollResponse = pollingContext.getLatestResponse();
                UUID resultUid = UUID.fromString(((OperationResult)operationResultPollResponse.getValue()).getResultId());
                return this.service.getAnalyzeLayoutResultWithResponseAsync(resultUid).flatMap(modelSimpleResponse -> FormRecognizerAsyncClient.processAnalyzeModelResponse((SimpleResponse<AnalyzeOperationResult>)modelSimpleResponse, (PollResponse<OperationResult>)operationResultPollResponse));
            }
            catch (HttpResponseException e) {
                this.logger.logExceptionAsError((RuntimeException)((Object)e));
                return Mono.just((Object)new PollResponse(LongRunningOperationStatus.FAILED, null));
            }
        };
    }

    private Function<PollingContext<OperationResult>, Mono<IterableStream<FormPage>>> fetchExtractContentResult() {
        return pollingContext -> {
            try {
                UUID resultUid = UUID.fromString(((OperationResult)pollingContext.getLatestResponse().getValue()).getResultId());
                return this.service.getAnalyzeLayoutResultWithResponseAsync(resultUid).map(modelSimpleResponse -> {
                    this.throwIfAnalyzeStatusInvalid((SimpleResponse<AnalyzeOperationResult>)modelSimpleResponse);
                    return new IterableStream(Transforms.toRecognizedLayout(((AnalyzeOperationResult)modelSimpleResponse.getValue()).getAnalyzeResult(), true));
                });
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<OperationResult>, Mono<IterableStream<RecognizedForm>>> fetchAnalyzeFormResultOperation(String modelId, boolean includeTextDetails) {
        return pollingContext -> {
            try {
                Objects.requireNonNull(modelId, "'modelId' is required and cannot be null.");
                UUID resultUid = UUID.fromString(((OperationResult)pollingContext.getLatestResponse().getValue()).getResultId());
                UUID modelUid = UUID.fromString(modelId);
                return this.service.getAnalyzeFormResultWithResponseAsync(modelUid, resultUid).map(modelSimpleResponse -> {
                    this.throwIfAnalyzeStatusInvalid((SimpleResponse<AnalyzeOperationResult>)modelSimpleResponse);
                    return new IterableStream(Transforms.toRecognizedForm(((AnalyzeOperationResult)modelSimpleResponse.getValue()).getAnalyzeResult(), includeTextDetails));
                });
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private void throwIfAnalyzeStatusInvalid(SimpleResponse<AnalyzeOperationResult> modelSimpleResponse) {
        List<ErrorInformation> errorInformationList;
        if (((AnalyzeOperationResult)modelSimpleResponse.getValue()).getStatus().equals((Object)OperationStatus.FAILED) && !CoreUtils.isNullOrEmpty(errorInformationList = ((AnalyzeOperationResult)modelSimpleResponse.getValue()).getAnalyzeResult().getErrors())) {
            throw this.logger.logExceptionAsError((RuntimeException)((Object)new ErrorResponseException(errorInformationList.get(0).getMessage(), null)));
        }
    }

    private Function<PollingContext<OperationResult>, Mono<PollResponse<OperationResult>>> createAnalyzeFormPollOperation(String modelId) {
        return pollingContext -> {
            try {
                PollResponse operationResultPollResponse = pollingContext.getLatestResponse();
                Objects.requireNonNull(modelId, "'modelId' is required and cannot be null.");
                UUID resultUid = UUID.fromString(((OperationResult)operationResultPollResponse.getValue()).getResultId());
                UUID modelUid = UUID.fromString(modelId);
                return this.service.getAnalyzeFormResultWithResponseAsync(modelUid, resultUid).flatMap(modelSimpleResponse -> FormRecognizerAsyncClient.processAnalyzeModelResponse((SimpleResponse<AnalyzeOperationResult>)modelSimpleResponse, (PollResponse<OperationResult>)operationResultPollResponse));
            }
            catch (HttpResponseException e) {
                this.logger.logExceptionAsError((RuntimeException)((Object)e));
                return Mono.just((Object)new PollResponse(LongRunningOperationStatus.FAILED, null));
            }
        };
    }

    private Function<PollingContext<OperationResult>, Mono<OperationResult>> analyzeFormActivationOperation(String fileSourceUrl, String modelId, boolean includeTextDetails) {
        return pollingContext -> {
            try {
                Objects.requireNonNull(fileSourceUrl, "'fileSourceUrl' is required and cannot be null.");
                Objects.requireNonNull(modelId, "'modelId' is required and cannot be null.");
                return this.service.analyzeWithCustomModelWithResponseAsync(UUID.fromString(modelId), includeTextDetails, new SourcePath().setSource(fileSourceUrl)).map(response -> new OperationResult(Utility.parseModelId(((AnalyzeWithCustomModelHeaders)response.getDeserializedHeaders()).getOperationLocation())));
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<OperationResult>, Mono<OperationResult>> analyzeFormStreamActivationOperation(Flux<ByteBuffer> data, String modelId, long length, FormContentType formContentType, boolean includeTextDetails) {
        return pollingContext -> {
            try {
                Objects.requireNonNull(data, "'data' is required and cannot be null.");
                Objects.requireNonNull(modelId, "'modelId' is required and cannot be null.");
                if (formContentType != null) {
                    return this.service.analyzeWithCustomModelWithResponseAsync(UUID.fromString(modelId), ContentType.fromString(formContentType.toString()), data, length, includeTextDetails).map(response -> new OperationResult(Utility.parseModelId(((AnalyzeWithCustomModelHeaders)response.getDeserializedHeaders()).getOperationLocation())));
                }
                return Utility.detectContentType(data).flatMap(contentType -> this.service.analyzeWithCustomModelWithResponseAsync(UUID.fromString(modelId), (ContentType)((Object)((Object)contentType)), data, length, includeTextDetails).map(response -> new OperationResult(Utility.parseModelId(((AnalyzeWithCustomModelHeaders)response.getDeserializedHeaders()).getOperationLocation()))));
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private static Mono<PollResponse<OperationResult>> processAnalyzeModelResponse(SimpleResponse<AnalyzeOperationResult> analyzeOperationResultSimpleResponse, PollResponse<OperationResult> operationResultPollResponse) {
        LongRunningOperationStatus status;
        switch (((AnalyzeOperationResult)analyzeOperationResultSimpleResponse.getValue()).getStatus()) {
            case NOT_STARTED: 
            case RUNNING: {
                status = LongRunningOperationStatus.IN_PROGRESS;
                break;
            }
            case SUCCEEDED: {
                status = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                break;
            }
            case FAILED: {
                status = LongRunningOperationStatus.FAILED;
                break;
            }
            default: {
                status = LongRunningOperationStatus.fromString((String)((AnalyzeOperationResult)analyzeOperationResultSimpleResponse.getValue()).getStatus().toString(), (boolean)true);
            }
        }
        return Mono.just((Object)new PollResponse(status, (Object)((OperationResult)operationResultPollResponse.getValue())));
    }
}

