/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer;

import com.azure.ai.formrecognizer.FormRecognizerAsyncClient;
import com.azure.ai.formrecognizer.FormTrainingClient;
import com.azure.ai.formrecognizer.implementation.Utility;
import com.azure.ai.formrecognizer.models.FormContentType;
import com.azure.ai.formrecognizer.models.FormPage;
import com.azure.ai.formrecognizer.models.OperationResult;
import com.azure.ai.formrecognizer.models.RecognizedForm;
import com.azure.ai.formrecognizer.models.RecognizedReceipt;
import com.azure.core.util.IterableStream;
import com.azure.core.util.polling.SyncPoller;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.time.Duration;
import reactor.core.publisher.Flux;

public final class FormRecognizerClient {
    private final FormRecognizerAsyncClient client;

    FormRecognizerClient(FormRecognizerAsyncClient client) {
        this.client = client;
    }

    public FormTrainingClient getFormTrainingClient() {
        return new FormTrainingClient(this.client.getFormTrainingAsyncClient());
    }

    public SyncPoller<OperationResult, IterableStream<RecognizedForm>> beginRecognizeCustomFormsFromUrl(String fileSourceUrl, String modelId) {
        return this.beginRecognizeCustomFormsFromUrl(fileSourceUrl, modelId, false, null);
    }

    public SyncPoller<OperationResult, IterableStream<RecognizedForm>> beginRecognizeCustomFormsFromUrl(String fileSourceUrl, String modelId, boolean includeTextDetails, Duration pollInterval) {
        return this.client.beginRecognizeCustomFormsFromUrl(fileSourceUrl, modelId, includeTextDetails, pollInterval).getSyncPoller();
    }

    public SyncPoller<OperationResult, IterableStream<RecognizedForm>> beginRecognizeCustomForms(InputStream data, String modelId, long length, FormContentType formContentType) {
        return this.beginRecognizeCustomForms(data, modelId, length, formContentType, false, null);
    }

    public SyncPoller<OperationResult, IterableStream<RecognizedForm>> beginRecognizeCustomForms(InputStream data, String modelId, long length, FormContentType formContentType, boolean includeTextDetails, Duration pollInterval) {
        Flux<ByteBuffer> buffer = Utility.toFluxByteBuffer(data);
        return this.client.beginRecognizeCustomForms(buffer, modelId, length, formContentType, includeTextDetails, pollInterval).getSyncPoller();
    }

    public SyncPoller<OperationResult, IterableStream<FormPage>> beginRecognizeContentFromUrl(String fileSourceUrl) {
        return this.beginRecognizeContentFromUrl(fileSourceUrl, null);
    }

    public SyncPoller<OperationResult, IterableStream<FormPage>> beginRecognizeContentFromUrl(String sourceUrl, Duration pollInterval) {
        return this.client.beginRecognizeContentFromUrl(sourceUrl, pollInterval).getSyncPoller();
    }

    public SyncPoller<OperationResult, IterableStream<FormPage>> beginRecognizeContent(InputStream data, long length, FormContentType formContentType) {
        return this.beginRecognizeContent(data, length, formContentType, null);
    }

    public SyncPoller<OperationResult, IterableStream<FormPage>> beginRecognizeContent(InputStream data, long length, FormContentType formContentType, Duration pollInterval) {
        Flux<ByteBuffer> buffer = Utility.toFluxByteBuffer(data);
        return this.client.beginRecognizeContent(buffer, length, formContentType, pollInterval).getSyncPoller();
    }

    public SyncPoller<OperationResult, IterableStream<RecognizedReceipt>> beginRecognizeReceiptsFromUrl(String sourceUrl) {
        return this.beginRecognizeReceiptsFromUrl(sourceUrl, false, null);
    }

    public SyncPoller<OperationResult, IterableStream<RecognizedReceipt>> beginRecognizeReceiptsFromUrl(String sourceUrl, boolean includeTextDetails, Duration pollInterval) {
        return this.client.beginRecognizeReceiptsFromUrl(sourceUrl, includeTextDetails, pollInterval).getSyncPoller();
    }

    public SyncPoller<OperationResult, IterableStream<RecognizedReceipt>> beginRecognizeReceipts(InputStream data, long length, FormContentType formContentType) {
        return this.beginRecognizeReceipts(data, length, formContentType, false, null);
    }

    public SyncPoller<OperationResult, IterableStream<RecognizedReceipt>> beginRecognizeReceipts(InputStream data, long length, FormContentType formContentType, boolean includeTextDetails, Duration pollInterval) {
        Flux<ByteBuffer> buffer = Utility.toFluxByteBuffer(data);
        return this.client.beginRecognizeReceipts(buffer, length, formContentType, includeTextDetails, pollInterval).getSyncPoller();
    }
}

