/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer;

import com.azure.ai.formrecognizer.FormRecognizerAsyncClient;
import com.azure.ai.formrecognizer.FormRecognizerClient;
import com.azure.ai.formrecognizer.FormRecognizerServiceVersion;
import com.azure.ai.formrecognizer.implementation.FormRecognizerClientImpl;
import com.azure.ai.formrecognizer.implementation.FormRecognizerClientImplBuilder;
import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.AzureKeyCredentialPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={FormRecognizerAsyncClient.class, FormRecognizerClient.class})
public final class FormRecognizerClientBuilder {
    private static final String ECHO_REQUEST_ID_HEADER = "x-ms-return-client-request-id";
    private static final String CONTENT_TYPE_HEADER_VALUE = "application/json";
    private static final String ACCEPT_HEADER = "Accept";
    private static final String FORM_RECOGNIZER_PROPERTIES = "azure-ai-formrecognizer.properties";
    private static final String NAME = "name";
    private static final String VERSION = "version";
    private static final RetryPolicy DEFAULT_RETRY_POLICY = new RetryPolicy("retry-after-ms", ChronoUnit.MILLIS);
    private final ClientLogger logger = new ClientLogger(FormRecognizerClientBuilder.class);
    private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
    private final HttpHeaders headers;
    private final String clientName;
    private final String clientVersion;
    private String endpoint;
    private AzureKeyCredential credential;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions = new HttpLogOptions();
    private HttpPipeline httpPipeline;
    private Configuration configuration;
    private RetryPolicy retryPolicy;
    private FormRecognizerServiceVersion version;
    static final String OCP_APIM_SUBSCRIPTION_KEY = "Ocp-Apim-Subscription-Key";
    static final Duration DEFAULT_DURATION = Duration.ofSeconds(5L);

    public FormRecognizerClientBuilder() {
        Map properties = CoreUtils.getProperties((String)FORM_RECOGNIZER_PROPERTIES);
        this.clientName = properties.getOrDefault(NAME, "UnknownName");
        this.clientVersion = properties.getOrDefault(VERSION, "UnknownVersion");
        this.headers = new HttpHeaders().put(ECHO_REQUEST_ID_HEADER, "true").put(ACCEPT_HEADER, CONTENT_TYPE_HEADER_VALUE);
    }

    public FormRecognizerClient buildClient() {
        return new FormRecognizerClient(this.buildAsyncClient());
    }

    public FormRecognizerAsyncClient buildAsyncClient() {
        Objects.requireNonNull(this.endpoint, "'Endpoint' is required and can not be null.");
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration().clone() : this.configuration;
        FormRecognizerServiceVersion serviceVersion = this.version != null ? this.version : FormRecognizerServiceVersion.getLatest();
        HttpPipeline pipeline = this.httpPipeline;
        if (pipeline == null) {
            pipeline = this.getDefaultHttpPipeline(buildConfiguration);
        }
        FormRecognizerClientImpl formRecognizerAPI = new FormRecognizerClientImplBuilder().endpoint(this.endpoint).pipeline(pipeline).build();
        return new FormRecognizerAsyncClient(formRecognizerAPI, serviceVersion);
    }

    private HttpPipeline getDefaultHttpPipeline(Configuration buildConfiguration) {
        ArrayList<Object> policies = new ArrayList<Object>();
        policies.add(new UserAgentPolicy(this.httpLogOptions.getApplicationId(), this.clientName, this.clientVersion, buildConfiguration));
        policies.add(new RequestIdPolicy());
        policies.add(new AddHeadersPolicy(this.headers));
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(this.retryPolicy == null ? DEFAULT_RETRY_POLICY : this.retryPolicy);
        policies.add(new AddDatePolicy());
        if (this.credential == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing credential information while building a client."));
        }
        policies.add(new AzureKeyCredentialPolicy(OCP_APIM_SUBSCRIPTION_KEY, this.credential));
        policies.addAll(this.policies);
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(this.httpLogOptions));
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).build();
    }

    public FormRecognizerClientBuilder endpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "'endpoint' cannot be null.");
        try {
            new URL(endpoint);
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("'endpoint' must be a valid URL.", ex));
        }
        this.endpoint = endpoint.endsWith("/") ? endpoint.substring(0, endpoint.length() - 1) : endpoint;
        return this;
    }

    public FormRecognizerClientBuilder apiKey(AzureKeyCredential apiKeyCredential) {
        this.credential = Objects.requireNonNull(apiKeyCredential, "'apiKeyCredential' cannot be null.");
        return this;
    }

    public FormRecognizerClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = logOptions;
        return this;
    }

    public FormRecognizerClientBuilder addPolicy(HttpPipelinePolicy policy) {
        this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
        return this;
    }

    public FormRecognizerClientBuilder httpClient(HttpClient client) {
        if (this.httpClient != null && client == null) {
            this.logger.info("HttpClient is being set to 'null' when it was previously configured.");
        }
        this.httpClient = client;
        return this;
    }

    public FormRecognizerClientBuilder pipeline(HttpPipeline httpPipeline) {
        if (this.httpPipeline != null && httpPipeline == null) {
            this.logger.info("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.httpPipeline = httpPipeline;
        return this;
    }

    public FormRecognizerClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public FormRecognizerClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public FormRecognizerClientBuilder serviceVersion(FormRecognizerServiceVersion version) {
        this.version = version;
        return this;
    }
}

