/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer;

import com.azure.ai.formrecognizer.CustomModelTransforms;
import com.azure.ai.formrecognizer.FormRecognizerClientBuilder;
import com.azure.ai.formrecognizer.FormRecognizerServiceVersion;
import com.azure.ai.formrecognizer.implementation.FormRecognizerClientImpl;
import com.azure.ai.formrecognizer.implementation.Utility;
import com.azure.ai.formrecognizer.implementation.models.Model;
import com.azure.ai.formrecognizer.implementation.models.Models;
import com.azure.ai.formrecognizer.implementation.models.TrainCustomModelAsyncHeaders;
import com.azure.ai.formrecognizer.implementation.models.TrainRequest;
import com.azure.ai.formrecognizer.implementation.models.TrainSourceFilter;
import com.azure.ai.formrecognizer.models.AccountProperties;
import com.azure.ai.formrecognizer.models.CustomFormModel;
import com.azure.ai.formrecognizer.models.CustomFormModelInfo;
import com.azure.ai.formrecognizer.models.OperationResult;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import java.time.Duration;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public class FormTrainingAsyncClient {
    private final ClientLogger logger = new ClientLogger(FormTrainingAsyncClient.class);
    private final FormRecognizerClientImpl service;
    private final FormRecognizerServiceVersion serviceVersion;

    FormTrainingAsyncClient(FormRecognizerClientImpl service, FormRecognizerServiceVersion serviceVersion) {
        this.service = service;
        this.serviceVersion = serviceVersion;
    }

    public FormRecognizerServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public PollerFlux<OperationResult, CustomFormModel> beginTraining(String fileSourceUrl, boolean useLabelFile) {
        return this.beginTraining(fileSourceUrl, useLabelFile, false, null, null);
    }

    public PollerFlux<OperationResult, CustomFormModel> beginTraining(String fileSourceUrl, boolean useLabelFile, boolean includeSubFolders, String filePrefix, Duration pollInterval) {
        Duration interval = pollInterval != null ? pollInterval : FormRecognizerClientBuilder.DEFAULT_DURATION;
        return new PollerFlux(interval, this.getTrainingActivationOperation(fileSourceUrl, includeSubFolders, filePrefix, useLabelFile), this.createTrainingPollOperation(), (activationResponse, context) -> Mono.error((Throwable)new RuntimeException("Cancellation is not supported")), this.fetchTrainingModelResultOperation());
    }

    public Mono<CustomFormModel> getCustomModel(String modelId) {
        return this.getCustomModelWithResponse(modelId).flatMap(FluxUtil::toMono);
    }

    public Mono<Response<CustomFormModel>> getCustomModelWithResponse(String modelId) {
        try {
            return FluxUtil.withContext(context -> this.getCustomModelWithResponse(modelId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<CustomFormModel>> getCustomModelWithResponse(String modelId, Context context) {
        Objects.requireNonNull(modelId, "'modelId' cannot be null");
        return this.service.getCustomModelWithResponseAsync(UUID.fromString(modelId), context, true).map(response -> new SimpleResponse((Response)response, (Object)CustomModelTransforms.toCustomFormModel((Model)response.getValue())));
    }

    public Mono<AccountProperties> getAccountProperties() {
        return this.getAccountPropertiesWithResponse().flatMap(FluxUtil::toMono);
    }

    public Mono<Response<AccountProperties>> getAccountPropertiesWithResponse() {
        try {
            return FluxUtil.withContext(context -> this.getAccountPropertiesWithResponse((Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<AccountProperties>> getAccountPropertiesWithResponse(Context context) {
        return this.service.getCustomModelsWithResponseAsync(context).map(response -> new SimpleResponse((Response)response, (Object)new AccountProperties(((Models)response.getValue()).getSummary().getCount(), ((Models)response.getValue()).getSummary().getLimit())));
    }

    public Mono<Void> deleteModel(String modelId) {
        return this.deleteModelWithResponse(modelId).flatMap(FluxUtil::toMono);
    }

    public Mono<Response<Void>> deleteModelWithResponse(String modelId) {
        try {
            return FluxUtil.withContext(context -> this.deleteModelWithResponse(modelId, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteModelWithResponse(String modelId, Context context) {
        Objects.requireNonNull(modelId, "'modelId' cannot be null");
        return this.service.deleteCustomModelWithResponseAsync(UUID.fromString(modelId), context).map(response -> new SimpleResponse(response, null));
    }

    public PagedFlux<CustomFormModelInfo> getModelInfos() {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.listFirstPageModelInfo((Context)context)), continuationToken -> FluxUtil.withContext(context -> this.listNextPageModelInfo((String)continuationToken, (Context)context)));
        }
        catch (RuntimeException ex) {
            return new PagedFlux(() -> FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex));
        }
    }

    PagedFlux<CustomFormModelInfo> getModelInfos(Context context) {
        return new PagedFlux(() -> this.listFirstPageModelInfo(context), continuationToken -> this.listNextPageModelInfo((String)continuationToken, context));
    }

    private Mono<PagedResponse<CustomFormModelInfo>> listFirstPageModelInfo(Context context) {
        return this.service.listCustomModelsSinglePageAsync(context).doOnRequest(ignoredValue -> this.logger.info("Listing information for all models")).doOnSuccess(response -> this.logger.info("Listed all models")).doOnError(error -> this.logger.warning("Failed to list all models information", new Object[]{error})).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), CustomModelTransforms.toCustomFormModelInfo(res.getValue()), (String)res.getContinuationToken(), null));
    }

    private Mono<PagedResponse<CustomFormModelInfo>> listNextPageModelInfo(String nextPageLink, Context context) {
        if (CoreUtils.isNullOrEmpty((CharSequence)nextPageLink)) {
            return Mono.empty();
        }
        return this.service.listCustomModelsNextSinglePageAsync(nextPageLink, context).doOnSubscribe(ignoredValue -> this.logger.info("Retrieving the next listing page - Page {}", new Object[]{nextPageLink})).doOnSuccess(response -> this.logger.info("Retrieved the next listing page - Page {}", new Object[]{nextPageLink})).doOnError(error -> this.logger.warning("Failed to retrieve the next listing page - Page {}", new Object[]{nextPageLink, error})).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), CustomModelTransforms.toCustomFormModelInfo(res.getValue()), (String)res.getContinuationToken(), null));
    }

    private Function<PollingContext<OperationResult>, Mono<CustomFormModel>> fetchTrainingModelResultOperation() {
        return pollingContext -> {
            try {
                UUID modelUid = UUID.fromString(((OperationResult)pollingContext.getLatestResponse().getValue()).getResultId());
                return this.service.getCustomModelWithResponseAsync(modelUid, true).map(modelSimpleResponse -> CustomModelTransforms.toCustomFormModel((Model)modelSimpleResponse.getValue()));
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<OperationResult>, Mono<PollResponse<OperationResult>>> createTrainingPollOperation() {
        return pollingContext -> {
            try {
                PollResponse operationResultPollResponse = pollingContext.getLatestResponse();
                UUID modelUid = UUID.fromString(((OperationResult)operationResultPollResponse.getValue()).getResultId());
                return this.service.getCustomModelWithResponseAsync(modelUid, true).flatMap(modelSimpleResponse -> FormTrainingAsyncClient.processTrainingModelResponse((SimpleResponse<Model>)modelSimpleResponse, (PollResponse<OperationResult>)operationResultPollResponse));
            }
            catch (HttpResponseException e) {
                this.logger.logExceptionAsError((RuntimeException)((Object)e));
                return Mono.just((Object)new PollResponse(LongRunningOperationStatus.FAILED, null));
            }
        };
    }

    private Function<PollingContext<OperationResult>, Mono<OperationResult>> getTrainingActivationOperation(String fileSourceUrl, boolean includeSubFolders, String filePrefix, boolean useLabelFile) {
        return pollingContext -> {
            try {
                Objects.requireNonNull(fileSourceUrl, "'fileSourceUrl' cannot be null.");
                TrainSourceFilter trainSourceFilter = new TrainSourceFilter().setIncludeSubFolders(includeSubFolders).setPrefix(filePrefix);
                TrainRequest serviceTrainRequest = new TrainRequest().setSource(fileSourceUrl).setSourceFilter(trainSourceFilter).setUseLabelFile(useLabelFile);
                return this.service.trainCustomModelAsyncWithResponseAsync(serviceTrainRequest).map(response -> new OperationResult(Utility.parseModelId(((TrainCustomModelAsyncHeaders)response.getDeserializedHeaders()).getLocation())));
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
            }
        };
    }

    private static Mono<PollResponse<OperationResult>> processTrainingModelResponse(SimpleResponse<Model> trainingModel, PollResponse<OperationResult> trainingModelOperationResponse) {
        LongRunningOperationStatus status;
        switch (((Model)trainingModel.getValue()).getModelInfo().getStatus()) {
            case CREATING: {
                status = LongRunningOperationStatus.IN_PROGRESS;
                break;
            }
            case READY: {
                status = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                break;
            }
            case INVALID: {
                status = LongRunningOperationStatus.FAILED;
                break;
            }
            default: {
                status = LongRunningOperationStatus.fromString((String)((Model)trainingModel.getValue()).getModelInfo().getStatus().toString(), (boolean)true);
            }
        }
        return Mono.just((Object)new PollResponse(status, (Object)((OperationResult)trainingModelOperationResponse.getValue())));
    }
}

