/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer;

import com.azure.ai.formrecognizer.FormRecognizerServiceVersion;
import com.azure.ai.formrecognizer.FormTrainingAsyncClient;
import com.azure.ai.formrecognizer.models.AccountProperties;
import com.azure.ai.formrecognizer.models.CustomFormModel;
import com.azure.ai.formrecognizer.models.CustomFormModelInfo;
import com.azure.ai.formrecognizer.models.OperationResult;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.polling.SyncPoller;
import java.time.Duration;

public class FormTrainingClient {
    private final FormTrainingAsyncClient client;

    FormTrainingClient(FormTrainingAsyncClient formTrainingAsyncClient) {
        this.client = formTrainingAsyncClient;
    }

    public FormRecognizerServiceVersion getServiceVersion() {
        return this.client.getServiceVersion();
    }

    public SyncPoller<OperationResult, CustomFormModel> beginTraining(String fileSourceUrl, boolean useLabelFile) {
        return this.beginTraining(fileSourceUrl, useLabelFile, false, null, null);
    }

    public SyncPoller<OperationResult, CustomFormModel> beginTraining(String fileSourceUrl, boolean useLabelFile, boolean includeSubFolders, String filePrefix, Duration pollInterval) {
        return this.client.beginTraining(fileSourceUrl, useLabelFile, includeSubFolders, filePrefix, pollInterval).getSyncPoller();
    }

    public CustomFormModel getCustomModel(String modelId) {
        return (CustomFormModel)this.getCustomModelWithResponse(modelId, Context.NONE).getValue();
    }

    public Response<CustomFormModel> getCustomModelWithResponse(String modelId, Context context) {
        return (Response)this.client.getCustomModelWithResponse(modelId, context).block();
    }

    public AccountProperties getAccountProperties() {
        return (AccountProperties)this.getAccountPropertiesWithResponse(Context.NONE).getValue();
    }

    public Response<AccountProperties> getAccountPropertiesWithResponse(Context context) {
        return (Response)this.client.getAccountPropertiesWithResponse(context).block();
    }

    public void deleteModel(String modelId) {
        this.deleteModelWithResponse(modelId, Context.NONE);
    }

    public Response<Void> deleteModelWithResponse(String modelId, Context context) {
        return (Response)this.client.deleteModelWithResponse(modelId, context).block();
    }

    public PagedIterable<CustomFormModelInfo> getModelInfos() {
        return new PagedIterable(this.client.getModelInfos(Context.NONE));
    }

    public PagedIterable<CustomFormModelInfo> getModelInfos(Context context) {
        return new PagedIterable(this.client.getModelInfos(context));
    }
}

