/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer;

import com.azure.ai.formrecognizer.models.FormField;
import com.azure.ai.formrecognizer.models.ReceiptItemType;
import com.azure.ai.formrecognizer.models.RecognizedReceipt;
import com.azure.ai.formrecognizer.models.USReceipt;
import com.azure.ai.formrecognizer.models.USReceiptItem;
import com.azure.ai.formrecognizer.models.USReceiptType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class ReceiptExtensions {
    private ReceiptExtensions() {
    }

    public static USReceipt asUSReceipt(RecognizedReceipt receipt) {
        USReceiptType receiptType = null;
        FormField<?> merchantName = null;
        FormField<?> merchantAddress = null;
        FormField<?> merchantPhoneNumber = null;
        FormField<?> subtotal = null;
        FormField<?> tax = null;
        FormField<?> tip = null;
        FormField<?> total = null;
        FormField<?> transactionDate = null;
        FormField<?> transactionTime = null;
        List<USReceiptItem> receiptItems = null;
        for (Map.Entry<String, FormField<?>> entry : receipt.getRecognizedForm().getFields().entrySet()) {
            String key = entry.getKey();
            FormField<?> fieldValue = entry.getValue();
            switch (key) {
                case "ReceiptType": {
                    receiptType = new USReceiptType(key, fieldValue.getConfidence());
                    break;
                }
                case "MerchantName": {
                    merchantName = fieldValue;
                    break;
                }
                case "MerchantAddress": {
                    merchantAddress = fieldValue;
                    break;
                }
                case "MerchantPhoneNumber": {
                    merchantPhoneNumber = fieldValue;
                    break;
                }
                case "Subtotal": {
                    subtotal = fieldValue;
                    break;
                }
                case "Tax": {
                    tax = fieldValue;
                    break;
                }
                case "Tip": {
                    tip = fieldValue;
                    break;
                }
                case "Total": {
                    total = fieldValue;
                    break;
                }
                case "TransactionDate": {
                    transactionDate = fieldValue;
                    break;
                }
                case "TransactionTime": {
                    transactionTime = fieldValue;
                    break;
                }
                case "Items": {
                    receiptItems = ReceiptExtensions.toReceiptItems(fieldValue);
                    break;
                }
            }
        }
        return new USReceipt(receipt.getReceiptLocale(), receipt.getRecognizedForm(), receiptItems, receiptType, merchantName, merchantAddress, merchantPhoneNumber, subtotal, tax, tip, total, transactionDate, transactionTime);
    }

    private static List<USReceiptItem> toReceiptItems(FormField<?> fieldValueItems) {
        List fieldValueArray = (List)fieldValueItems.getFieldValue();
        ArrayList<USReceiptItem> receiptItemList = new ArrayList<USReceiptItem>();
        for (FormField eachFieldValue : fieldValueArray) {
            Map objectValue = (Map)eachFieldValue.getFieldValue();
            FormField name = null;
            FormField quantity = null;
            FormField price = null;
            FormField totalPrice = null;
            for (Map.Entry entry : objectValue.entrySet()) {
                String key = (String)entry.getKey();
                if (ReceiptItemType.QUANTITY.toString().equals(key)) {
                    quantity = (FormField)entry.getValue();
                    continue;
                }
                if (ReceiptItemType.NAME.toString().equals(key)) {
                    name = (FormField)entry.getValue();
                    continue;
                }
                if (ReceiptItemType.PRICE.toString().equals(key)) {
                    price = (FormField)entry.getValue();
                    continue;
                }
                if (!ReceiptItemType.TOTAL_PRICE.toString().equals(key)) continue;
                totalPrice = (FormField)entry.getValue();
            }
            receiptItemList.add(new USReceiptItem(name, quantity, price, totalPrice));
        }
        return receiptItemList;
    }
}

