/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer;

import com.azure.ai.formrecognizer.implementation.models.AnalyzeResult;
import com.azure.ai.formrecognizer.implementation.models.DocumentResult;
import com.azure.ai.formrecognizer.implementation.models.FieldValue;
import com.azure.ai.formrecognizer.implementation.models.KeyValuePair;
import com.azure.ai.formrecognizer.implementation.models.PageResult;
import com.azure.ai.formrecognizer.implementation.models.ReadResult;
import com.azure.ai.formrecognizer.implementation.models.TextLine;
import com.azure.ai.formrecognizer.implementation.models.TextWord;
import com.azure.ai.formrecognizer.models.BoundingBox;
import com.azure.ai.formrecognizer.models.DimensionUnit;
import com.azure.ai.formrecognizer.models.FieldText;
import com.azure.ai.formrecognizer.models.FormContent;
import com.azure.ai.formrecognizer.models.FormField;
import com.azure.ai.formrecognizer.models.FormLine;
import com.azure.ai.formrecognizer.models.FormPage;
import com.azure.ai.formrecognizer.models.FormTable;
import com.azure.ai.formrecognizer.models.FormTableCell;
import com.azure.ai.formrecognizer.models.FormWord;
import com.azure.ai.formrecognizer.models.PageRange;
import com.azure.ai.formrecognizer.models.Point;
import com.azure.ai.formrecognizer.models.RecognizedForm;
import com.azure.ai.formrecognizer.models.RecognizedReceipt;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

final class Transforms {
    private static final ClientLogger LOGGER = new ClientLogger(Transforms.class);
    private static final Pattern NON_DIGIT_PATTERN = Pattern.compile("[^0-9]+");
    private static final float DEFAULT_CONFIDENCE_VALUE = 1.0f;

    private Transforms() {
    }

    static List<RecognizedForm> toRecognizedForm(AnalyzeResult analyzeResult, boolean includeTextDetails) {
        ArrayList<RecognizedForm> extractedFormList;
        block4: {
            List<FormPage> formPages;
            List<PageResult> pageResults;
            List<ReadResult> readResults;
            block3: {
                readResults = analyzeResult.getReadResults();
                List<DocumentResult> documentResults = analyzeResult.getDocumentResults();
                pageResults = analyzeResult.getPageResults();
                extractedFormList = null;
                formPages = Transforms.toRecognizedLayout(analyzeResult, includeTextDetails);
                if (CoreUtils.isNullOrEmpty(documentResults)) break block3;
                extractedFormList = new ArrayList<RecognizedForm>();
                for (DocumentResult documentResultItem : documentResults) {
                    List<Integer> documentPageRange = documentResultItem.getPageRange();
                    PageRange pageRange = documentPageRange.size() == 2 ? new PageRange(documentPageRange.get(0), documentPageRange.get(1)) : new PageRange(1, 1);
                    Map<String, FormField<?>> extractedFieldMap = Transforms.getUnlabeledFieldMap(documentResultItem, readResults, includeTextDetails);
                    extractedFormList.add(new RecognizedForm(extractedFieldMap, documentResultItem.getDocType(), pageRange, (IterableStream<FormPage>)new IterableStream(formPages.subList(pageRange.getStartPageNumber() - 1, pageRange.getEndPageNumber()))));
                }
                break block4;
            }
            if (CoreUtils.isNullOrEmpty(pageResults)) break block4;
            extractedFormList = new ArrayList();
            for (PageResult pageResultItem : pageResults) {
                StringBuffer formType = new StringBuffer("form-");
                int pageNumber = pageResultItem.getPage();
                Integer clusterId = pageResultItem.getClusterId();
                if (clusterId != null) {
                    formType.append(clusterId);
                }
                Map<String, FormField<?>> extractedFieldMap = Transforms.getLabeledFieldMap(includeTextDetails, readResults, pageResultItem, pageNumber);
                extractedFormList.add(new RecognizedForm(extractedFieldMap, formType.toString(), new PageRange(pageNumber, pageNumber), (IterableStream<FormPage>)new IterableStream(Collections.singletonList(formPages.get(pageNumber - 1)))));
            }
        }
        return extractedFormList;
    }

    static IterableStream<RecognizedReceipt> toReceipt(AnalyzeResult analyzeResult, boolean includeTextDetails) {
        return new IterableStream((Iterable)Transforms.toRecognizedForm(analyzeResult, includeTextDetails).stream().map(recognizedForm -> new RecognizedReceipt("en-US", (RecognizedForm)recognizedForm)).collect(Collectors.toList()));
    }

    static List<FormPage> toRecognizedLayout(AnalyzeResult analyzeResult, boolean includeTextDetails) {
        List<ReadResult> readResults = analyzeResult.getReadResults();
        List<PageResult> pageResults = analyzeResult.getPageResults();
        ArrayList<FormPage> formPages = new ArrayList<FormPage>();
        boolean pageResultsIsNullOrEmpty = CoreUtils.isNullOrEmpty(pageResults);
        Transforms.forEachWithIndex(readResults, (index, readResultItem) -> {
            List<FormTable> perPageTableList = new ArrayList<FormTable>();
            if (!pageResultsIsNullOrEmpty) {
                PageResult pageResultItem = (PageResult)pageResults.get((int)index);
                perPageTableList = Transforms.getPageTables(pageResultItem, readResults, pageResultItem.getPage());
            }
            List<FormLine> perPageFormLineList = new ArrayList<FormLine>();
            if (includeTextDetails && !CoreUtils.isNullOrEmpty(readResultItem.getLines())) {
                perPageFormLineList = Transforms.getReadResultFormLines(readResultItem);
            }
            formPages.add(Transforms.getFormPage(readResultItem, perPageTableList, perPageFormLineList));
        });
        return formPages;
    }

    static <T> void forEachWithIndex(Iterable<T> iterable, BiConsumer<Integer, T> biConsumer) {
        int[] index = new int[]{0};
        iterable.forEach(element -> {
            int n = index[0];
            index[0] = n + 1;
            biConsumer.accept(n, element);
        });
    }

    static List<FormTable> getPageTables(PageResult pageResultItem, List<ReadResult> readResults, Integer pageNumber) {
        return pageResultItem.getTables().stream().map(dataTable -> new FormTable(dataTable.getRows(), dataTable.getColumns(), (IterableStream<FormTableCell>)new IterableStream((Iterable)dataTable.getCells().stream().map(dataTableCell -> new FormTableCell(dataTableCell.getRowIndex(), dataTableCell.getColumnIndex(), dataTableCell.getRowSpan(), dataTableCell.getColumnSpan(), dataTableCell.getText(), Transforms.toBoundingBox(dataTableCell.getBoundingBox()), dataTableCell.getConfidence(), dataTableCell.isHeader() == null ? false : dataTableCell.isHeader(), dataTableCell.isFooter() == null ? false : dataTableCell.isFooter(), pageNumber, Transforms.setReferenceElements(dataTableCell.getElements(), readResults, pageNumber))).collect(Collectors.toList())))).collect(Collectors.toList());
    }

    static List<FormLine> getReadResultFormLines(ReadResult readResultItem) {
        return readResultItem.getLines().stream().map(textLine -> new FormLine(textLine.getText(), Transforms.toBoundingBox(textLine.getBoundingBox()), (Integer)readResultItem.getPage(), Transforms.toWords(textLine.getWords(), readResultItem.getPage()))).collect(Collectors.toList());
    }

    private static Map<String, FormField<?>> getUnlabeledFieldMap(DocumentResult documentResultItem, List<ReadResult> readResults, boolean includeTextDetails) {
        TreeMap extractedFieldMap = new TreeMap();
        documentResultItem.getFields().forEach((key, fieldValue) -> {
            FieldText labelText = new FieldText((String)key, null, fieldValue.getPage(), null);
            Integer pageNumber = fieldValue.getPage();
            IterableStream<FormContent> formContentList = null;
            if (includeTextDetails) {
                formContentList = Transforms.setReferenceElements(fieldValue.getElements(), readResults, pageNumber);
            }
            FieldText valueText = new FieldText(fieldValue.getText(), Transforms.toBoundingBox(fieldValue.getBoundingBox()), pageNumber, formContentList);
            extractedFieldMap.put((String)key, Transforms.setFormField(labelText, key, fieldValue, valueText, pageNumber, readResults));
        });
        return extractedFieldMap;
    }

    private static FormField<?> setFormField(FieldText labelText, String key, FieldValue fieldValue, FieldText valueText, Integer pageNumber, List<ReadResult> readResults) {
        FormField<Object> value;
        switch (fieldValue.getType()) {
            case PHONE_NUMBER: {
                value = new FormField<String>(Transforms.setDefaultConfidenceValue(fieldValue.getConfidence()), labelText, key, fieldValue.getValuePhoneNumber(), valueText, pageNumber);
                break;
            }
            case STRING: {
                value = new FormField<String>(Transforms.setDefaultConfidenceValue(fieldValue.getConfidence()), labelText, key, fieldValue.getValueString(), valueText, pageNumber);
                break;
            }
            case TIME: {
                value = new FormField<String>(Transforms.setDefaultConfidenceValue(fieldValue.getConfidence()), labelText, key, fieldValue.getValueTime(), valueText, pageNumber);
                break;
            }
            case DATE: {
                value = new FormField<LocalDate>(Transforms.setDefaultConfidenceValue(fieldValue.getConfidence()), labelText, key, fieldValue.getValueDate(), valueText, pageNumber);
                break;
            }
            case INTEGER: {
                value = new FormField<Integer>(Transforms.setDefaultConfidenceValue(fieldValue.getConfidence()), labelText, key, fieldValue.getValueInteger(), valueText, pageNumber);
                break;
            }
            case NUMBER: {
                value = new FormField<Float>(Transforms.setDefaultConfidenceValue(fieldValue.getConfidence()), labelText, key, fieldValue.getValueNumber(), valueText, pageNumber);
                break;
            }
            case ARRAY: {
                value = new FormField(Transforms.setDefaultConfidenceValue(fieldValue.getConfidence()), null, key, Transforms.toFormFieldArray(fieldValue.getValueArray(), readResults), null, pageNumber);
                break;
            }
            case OBJECT: {
                value = new FormField(Transforms.setDefaultConfidenceValue(fieldValue.getConfidence()), labelText, key, Transforms.toFormFieldObject(fieldValue.getValueObject(), pageNumber, readResults), valueText, pageNumber);
                break;
            }
            default: {
                throw LOGGER.logExceptionAsError(new RuntimeException("FieldValue Type not supported"));
            }
        }
        return value;
    }

    private static float setDefaultConfidenceValue(Float confidence) {
        return confidence == null ? 1.0f : confidence.floatValue();
    }

    private static Map<String, FormField<?>> toFormFieldObject(Map<String, FieldValue> valueObject, Integer pageNumber, List<ReadResult> readResults) {
        TreeMap fieldValueObjectMap = new TreeMap();
        valueObject.forEach((key, fieldValue) -> fieldValueObjectMap.put((String)key, Transforms.setFormField(null, key, fieldValue, new FieldText(fieldValue.getText(), Transforms.toBoundingBox(fieldValue.getBoundingBox()), fieldValue.getPage(), Transforms.setReferenceElements(fieldValue.getElements(), readResults, pageNumber)), fieldValue.getPage(), readResults)));
        return fieldValueObjectMap;
    }

    private static List<FormField<?>> toFormFieldArray(List<FieldValue> valueArray, List<ReadResult> readResults) {
        return valueArray.stream().map(fieldValue -> Transforms.setFormField(null, null, fieldValue, null, fieldValue.getPage(), readResults)).collect(Collectors.toList());
    }

    private static FormPage getFormPage(ReadResult readResultItem, List<FormTable> perPageTableList, List<FormLine> perPageLineList) {
        return new FormPage(readResultItem.getHeight(), readResultItem.getAngle(), DimensionUnit.fromString(readResultItem.getUnit().toString()), readResultItem.getWidth(), (IterableStream<FormLine>)new IterableStream(perPageLineList), (IterableStream<FormTable>)new IterableStream(perPageTableList));
    }

    private static Map<String, FormField<?>> getLabeledFieldMap(boolean includeTextDetails, List<ReadResult> readResults, PageResult pageResultItem, Integer pageNumber) {
        TreeMap formFieldMap = new TreeMap();
        List<KeyValuePair> keyValuePairs = pageResultItem.getKeyValuePairs();
        Transforms.forEachWithIndex(keyValuePairs, (index, keyValuePair) -> {
            IterableStream<FormContent> formKeyContentList = null;
            IterableStream<FormContent> formValueContentList = null;
            if (includeTextDetails) {
                formKeyContentList = Transforms.setReferenceElements(keyValuePair.getKey().getElements(), readResults, pageNumber);
                formValueContentList = Transforms.setReferenceElements(keyValuePair.getValue().getElements(), readResults, pageNumber);
            }
            FieldText labelFieldText = new FieldText(keyValuePair.getKey().getText(), Transforms.toBoundingBox(keyValuePair.getKey().getBoundingBox()), pageNumber, formKeyContentList);
            FieldText valueText = new FieldText(keyValuePair.getValue().getText(), Transforms.toBoundingBox(keyValuePair.getValue().getBoundingBox()), pageNumber, formValueContentList);
            String fieldName = "field-" + index;
            FormField<String> formField = new FormField<String>(Transforms.setDefaultConfidenceValue(Float.valueOf(keyValuePair.getConfidence())), labelFieldText, fieldName, keyValuePair.getValue().getText(), valueText, pageNumber);
            formFieldMap.put(fieldName, formField);
        });
        return formFieldMap;
    }

    private static IterableStream<FormContent> setReferenceElements(List<String> elements, List<ReadResult> readResults, Integer pageNumber) {
        if (CoreUtils.isNullOrEmpty(elements)) {
            return IterableStream.of(null);
        }
        ArrayList formContentList = new ArrayList();
        elements.forEach(elementString -> {
            String[] indices = NON_DIGIT_PATTERN.matcher((CharSequence)elementString).replaceAll(" ").trim().split(" ");
            if (indices.length < 2) {
                throw LOGGER.logExceptionAsError(new RuntimeException("Cannot find corresponding reference elements for the field value."));
            }
            int readResultIndex = Integer.parseInt(indices[0]);
            int lineIndex = Integer.parseInt(indices[1]);
            if (indices.length == 3) {
                int wordIndex = Integer.parseInt(indices[2]);
                TextWord textWord = ((ReadResult)readResults.get(readResultIndex)).getLines().get(lineIndex).getWords().get(wordIndex);
                FormWord wordElement = new FormWord(textWord.getText(), Transforms.toBoundingBox(textWord.getBoundingBox()), pageNumber, Transforms.setDefaultConfidenceValue(textWord.getConfidence()));
                formContentList.add(wordElement);
            } else {
                TextLine textLine = ((ReadResult)readResults.get(readResultIndex)).getLines().get(lineIndex);
                FormLine lineElement = new FormLine(textLine.getText(), Transforms.toBoundingBox(textLine.getBoundingBox()), pageNumber, Transforms.toWords(textLine.getWords(), pageNumber));
                formContentList.add(lineElement);
            }
        });
        return new IterableStream(formContentList);
    }

    private static IterableStream<FormWord> toWords(List<TextWord> words, Integer pageNumber) {
        return new IterableStream((Iterable)words.stream().map(textWord -> new FormWord(textWord.getText(), Transforms.toBoundingBox(textWord.getBoundingBox()), pageNumber, Transforms.setDefaultConfidenceValue(textWord.getConfidence()))).collect(Collectors.toList()));
    }

    private static BoundingBox toBoundingBox(List<Float> serviceBoundingBox) {
        if (CoreUtils.isNullOrEmpty(serviceBoundingBox) || serviceBoundingBox.size() % 2 != 0) {
            return null;
        }
        ArrayList<Point> pointList = new ArrayList<Point>();
        for (int i = 0; i < serviceBoundingBox.size(); ++i) {
            pointList.add(new Point(serviceBoundingBox.get(++i), serviceBoundingBox.get(i)));
        }
        return new BoundingBox(pointList);
    }
}

