/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.implementation;

import com.azure.ai.formrecognizer.implementation.models.AnalyzeLayoutAsyncResponse;
import com.azure.ai.formrecognizer.implementation.models.AnalyzeOperationResult;
import com.azure.ai.formrecognizer.implementation.models.AnalyzeReceiptAsyncResponse;
import com.azure.ai.formrecognizer.implementation.models.AnalyzeWithCustomModelResponse;
import com.azure.ai.formrecognizer.implementation.models.ContentType;
import com.azure.ai.formrecognizer.implementation.models.Model;
import com.azure.ai.formrecognizer.implementation.models.ModelInfo;
import com.azure.ai.formrecognizer.implementation.models.Models;
import com.azure.ai.formrecognizer.implementation.models.SourcePath;
import com.azure.ai.formrecognizer.implementation.models.TrainCustomModelAsyncResponse;
import com.azure.ai.formrecognizer.implementation.models.TrainRequest;
import com.azure.ai.formrecognizer.models.ErrorResponseException;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import java.nio.ByteBuffer;
import java.util.UUID;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class FormRecognizerClientImpl {
    private final FormRecognizerClientService service;
    private String endpoint;
    private final HttpPipeline httpPipeline;

    public String getEndpoint() {
        return this.endpoint;
    }

    public FormRecognizerClientImpl setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public FormRecognizerClientImpl() {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build());
    }

    public FormRecognizerClientImpl(HttpPipeline httpPipeline) {
        this.httpPipeline = httpPipeline;
        this.service = (FormRecognizerClientService)RestProxy.create(FormRecognizerClientService.class, (HttpPipeline)this.httpPipeline);
    }

    public Mono<TrainCustomModelAsyncResponse> trainCustomModelAsyncWithResponseAsync(TrainRequest trainRequest) {
        return FluxUtil.withContext(context -> this.service.trainCustomModelAsync(this.getEndpoint(), trainRequest, (Context)context));
    }

    public Mono<TrainCustomModelAsyncResponse> trainCustomModelAsyncWithResponseAsync(TrainRequest trainRequest, Context context) {
        return this.service.trainCustomModelAsync(this.getEndpoint(), trainRequest, context);
    }

    public Mono<SimpleResponse<Model>> getCustomModelWithResponseAsync(UUID modelId, Boolean includeKeys) {
        return FluxUtil.withContext(context -> this.service.getCustomModel(this.getEndpoint(), modelId, includeKeys, (Context)context));
    }

    public Mono<SimpleResponse<Model>> getCustomModelWithResponseAsync(UUID modelId, Context context, Boolean includeKeys) {
        return this.service.getCustomModel(this.getEndpoint(), modelId, includeKeys, context);
    }

    public Mono<Response<Void>> deleteCustomModelWithResponseAsync(UUID modelId) {
        return FluxUtil.withContext(context -> this.service.deleteCustomModel(this.getEndpoint(), modelId, (Context)context));
    }

    public Mono<Response<Void>> deleteCustomModelWithResponseAsync(UUID modelId, Context context) {
        return this.service.deleteCustomModel(this.getEndpoint(), modelId, context);
    }

    public Mono<AnalyzeWithCustomModelResponse> analyzeWithCustomModelWithResponseAsync(UUID modelId, ContentType contentType, Flux<ByteBuffer> fileStream, long contentLength, Boolean includeTextDetails) {
        return FluxUtil.withContext(context -> this.service.analyzeWithCustomModel(this.getEndpoint(), modelId, includeTextDetails, contentType, fileStream, contentLength, (Context)context));
    }

    public Mono<AnalyzeWithCustomModelResponse> analyzeWithCustomModelWithResponseAsync(UUID modelId, ContentType contentType, Flux<ByteBuffer> fileStream, long contentLength, Context context, Boolean includeTextDetails) {
        return this.service.analyzeWithCustomModel(this.getEndpoint(), modelId, includeTextDetails, contentType, fileStream, contentLength, context);
    }

    public Mono<AnalyzeWithCustomModelResponse> analyzeWithCustomModelWithResponseAsync(UUID modelId, Boolean includeTextDetails, SourcePath fileStream) {
        return FluxUtil.withContext(context -> this.service.analyzeWithCustomModel(this.getEndpoint(), modelId, includeTextDetails, fileStream, (Context)context));
    }

    public Mono<AnalyzeWithCustomModelResponse> analyzeWithCustomModelWithResponseAsync(UUID modelId, Context context, Boolean includeTextDetails, SourcePath fileStream) {
        return this.service.analyzeWithCustomModel(this.getEndpoint(), modelId, includeTextDetails, fileStream, context);
    }

    public Mono<SimpleResponse<AnalyzeOperationResult>> getAnalyzeFormResultWithResponseAsync(UUID modelId, UUID resultId) {
        return FluxUtil.withContext(context -> this.service.getAnalyzeFormResult(this.getEndpoint(), modelId, resultId, (Context)context));
    }

    public Mono<SimpleResponse<AnalyzeOperationResult>> getAnalyzeFormResultWithResponseAsync(UUID modelId, UUID resultId, Context context) {
        return this.service.getAnalyzeFormResult(this.getEndpoint(), modelId, resultId, context);
    }

    public Mono<AnalyzeReceiptAsyncResponse> analyzeReceiptAsyncWithResponseAsync(ContentType contentType, Flux<ByteBuffer> fileStream, long contentLength, Boolean includeTextDetails) {
        return FluxUtil.withContext(context -> this.service.analyzeReceiptAsync(this.getEndpoint(), includeTextDetails, contentType, fileStream, contentLength, (Context)context));
    }

    public Mono<AnalyzeReceiptAsyncResponse> analyzeReceiptAsyncWithResponseAsync(ContentType contentType, Flux<ByteBuffer> fileStream, long contentLength, Context context, Boolean includeTextDetails) {
        return this.service.analyzeReceiptAsync(this.getEndpoint(), includeTextDetails, contentType, fileStream, contentLength, context);
    }

    public Mono<AnalyzeReceiptAsyncResponse> analyzeReceiptAsyncWithResponseAsync(Boolean includeTextDetails, SourcePath fileStream) {
        return FluxUtil.withContext(context -> this.service.analyzeReceiptAsync(this.getEndpoint(), includeTextDetails, fileStream, (Context)context));
    }

    public Mono<AnalyzeReceiptAsyncResponse> analyzeReceiptAsyncWithResponseAsync(Context context, Boolean includeTextDetails, SourcePath fileStream) {
        return this.service.analyzeReceiptAsync(this.getEndpoint(), includeTextDetails, fileStream, context);
    }

    public Mono<SimpleResponse<AnalyzeOperationResult>> getAnalyzeReceiptResultWithResponseAsync(UUID resultId) {
        return FluxUtil.withContext(context -> this.service.getAnalyzeReceiptResult(this.getEndpoint(), resultId, (Context)context));
    }

    public Mono<SimpleResponse<AnalyzeOperationResult>> getAnalyzeReceiptResultWithResponseAsync(UUID resultId, Context context) {
        return this.service.getAnalyzeReceiptResult(this.getEndpoint(), resultId, context);
    }

    public Mono<AnalyzeLayoutAsyncResponse> analyzeLayoutAsyncWithResponseAsync(ContentType contentType, Flux<ByteBuffer> fileStream, long contentLength) {
        return FluxUtil.withContext(context -> this.service.analyzeLayoutAsync(this.getEndpoint(), contentType, fileStream, contentLength, (Context)context));
    }

    public Mono<AnalyzeLayoutAsyncResponse> analyzeLayoutAsyncWithResponseAsync(ContentType contentType, Flux<ByteBuffer> fileStream, long contentLength, Context context) {
        return this.service.analyzeLayoutAsync(this.getEndpoint(), contentType, fileStream, contentLength, context);
    }

    public Mono<AnalyzeLayoutAsyncResponse> analyzeLayoutAsyncWithResponseAsync(SourcePath fileStream) {
        return FluxUtil.withContext(context -> this.service.analyzeLayoutAsync(this.getEndpoint(), fileStream, (Context)context));
    }

    public Mono<AnalyzeLayoutAsyncResponse> analyzeLayoutAsyncWithResponseAsync(Context context, SourcePath fileStream) {
        return this.service.analyzeLayoutAsync(this.getEndpoint(), fileStream, context);
    }

    public Mono<SimpleResponse<AnalyzeOperationResult>> getAnalyzeLayoutResultWithResponseAsync(UUID resultId) {
        return FluxUtil.withContext(context -> this.service.getAnalyzeLayoutResult(this.getEndpoint(), resultId, (Context)context));
    }

    public Mono<SimpleResponse<AnalyzeOperationResult>> getAnalyzeLayoutResultWithResponseAsync(UUID resultId, Context context) {
        return this.service.getAnalyzeLayoutResult(this.getEndpoint(), resultId, context);
    }

    public Mono<PagedResponse<ModelInfo>> listCustomModelsSinglePageAsync() {
        String op = "full";
        return FluxUtil.withContext(context -> this.service.listCustomModels(this.getEndpoint(), "full", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((Models)res.getValue()).getModelList(), ((Models)res.getValue()).getNextLink(), null));
    }

    public Mono<PagedResponse<ModelInfo>> listCustomModelsSinglePageAsync(Context context) {
        String op = "full";
        return this.service.listCustomModels(this.getEndpoint(), "full", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((Models)res.getValue()).getModelList(), ((Models)res.getValue()).getNextLink(), null));
    }

    public Mono<SimpleResponse<Models>> getCustomModelsWithResponseAsync() {
        String op = "summary";
        return FluxUtil.withContext(context -> this.service.getCustomModels(this.getEndpoint(), "summary", (Context)context));
    }

    public Mono<SimpleResponse<Models>> getCustomModelsWithResponseAsync(Context context) {
        String op = "summary";
        return this.service.getCustomModels(this.getEndpoint(), "summary", context);
    }

    public Mono<PagedResponse<ModelInfo>> listCustomModelsNextSinglePageAsync(String nextLink) {
        return FluxUtil.withContext(context -> this.service.listCustomModelsNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((Models)res.getValue()).getModelList(), ((Models)res.getValue()).getNextLink(), null));
    }

    public Mono<PagedResponse<ModelInfo>> listCustomModelsNextSinglePageAsync(String nextLink, Context context) {
        return this.service.listCustomModelsNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((Models)res.getValue()).getModelList(), ((Models)res.getValue()).getNextLink(), null));
    }

    @Host(value="{endpoint}/formrecognizer/v2.0-preview")
    @ServiceInterface(name="FormRecognizerClient")
    private static interface FormRecognizerClientService {
        @Post(value="/custom/models")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<TrainCustomModelAsyncResponse> trainCustomModelAsync(@HostParam(value="endpoint") String var1, @BodyParam(value="application/json") TrainRequest var2, Context var3);

        @Get(value="/custom/models/{modelId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<SimpleResponse<Model>> getCustomModel(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") UUID var2, @QueryParam(value="includeKeys") Boolean var3, Context var4);

        @Delete(value="/custom/models/{modelId}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<Response<Void>> deleteCustomModel(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") UUID var2, Context var3);

        @Post(value="/custom/models/{modelId}/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<AnalyzeWithCustomModelResponse> analyzeWithCustomModel(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") UUID var2, @QueryParam(value="includeTextDetails") Boolean var3, @BodyParam(value="application/json") SourcePath var4, Context var5);

        @Post(value="/custom/models/{modelId}/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<AnalyzeWithCustomModelResponse> analyzeWithCustomModel(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") UUID var2, @QueryParam(value="includeTextDetails") Boolean var3, @HeaderParam(value="Content-Type") ContentType var4, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var5, @HeaderParam(value="Content-Length") long var6, Context var8);

        @Get(value="/custom/models/{modelId}/analyzeResults/{resultId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<SimpleResponse<AnalyzeOperationResult>> getAnalyzeFormResult(@HostParam(value="endpoint") String var1, @PathParam(value="modelId") UUID var2, @PathParam(value="resultId") UUID var3, Context var4);

        @Post(value="/prebuilt/receipt/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<AnalyzeReceiptAsyncResponse> analyzeReceiptAsync(@HostParam(value="endpoint") String var1, @QueryParam(value="includeTextDetails") Boolean var2, @HeaderParam(value="Content-Type") ContentType var3, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var4, @HeaderParam(value="Content-Length") long var5, Context var7);

        @Post(value="/prebuilt/receipt/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<AnalyzeReceiptAsyncResponse> analyzeReceiptAsync(@HostParam(value="endpoint") String var1, @QueryParam(value="includeTextDetails") Boolean var2, @BodyParam(value="application/json") SourcePath var3, Context var4);

        @Get(value="/prebuilt/receipt/analyzeResults/{resultId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<SimpleResponse<AnalyzeOperationResult>> getAnalyzeReceiptResult(@HostParam(value="endpoint") String var1, @PathParam(value="resultId") UUID var2, Context var3);

        @Post(value="/layout/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<AnalyzeLayoutAsyncResponse> analyzeLayoutAsync(@HostParam(value="endpoint") String var1, @HeaderParam(value="Content-Type") ContentType var2, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var3, @HeaderParam(value="Content-Length") long var4, Context var6);

        @Post(value="/layout/analyze")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<AnalyzeLayoutAsyncResponse> analyzeLayoutAsync(@HostParam(value="endpoint") String var1, @BodyParam(value="application/json") SourcePath var2, Context var3);

        @Get(value="/layout/analyzeResults/{resultId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<SimpleResponse<AnalyzeOperationResult>> getAnalyzeLayoutResult(@HostParam(value="endpoint") String var1, @PathParam(value="resultId") UUID var2, Context var3);

        @Get(value="/custom/models")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<SimpleResponse<Models>> listCustomModels(@HostParam(value="endpoint") String var1, @QueryParam(value="op") String var2, Context var3);

        @Get(value="/custom/models")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<SimpleResponse<Models>> getCustomModels(@HostParam(value="endpoint") String var1, @QueryParam(value="op") String var2, Context var3);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorResponseException.class)
        public Mono<SimpleResponse<Models>> listCustomModelsNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

