/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.implementation;

import com.azure.ai.formrecognizer.implementation.FormRecognizerClientImpl;
import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;

@ServiceClientBuilder(serviceClients={FormRecognizerClientImpl.class})
public final class FormRecognizerClientImplBuilder {
    private String endpoint;
    private HttpPipeline pipeline;

    public FormRecognizerClientImplBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public FormRecognizerClientImplBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public FormRecognizerClientImpl build() {
        if (this.pipeline == null) {
            this.pipeline = new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build();
        }
        FormRecognizerClientImpl client = new FormRecognizerClientImpl(this.pipeline);
        client.setEndpoint(this.endpoint);
        return client;
    }
}

