/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.formrecognizer.implementation;

import com.azure.ai.formrecognizer.implementation.models.ContentType;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class Utility {
    private static final ClientLogger LOGGER = new ClientLogger(Utility.class);
    private static final int BYTE_BUFFER_CHUNK_SIZE = 4096;

    private Utility() {
    }

    public static Mono<ContentType> detectContentType(Flux<ByteBuffer> buffer) {
        byte[] header = new byte[4];
        int[] written = new int[]{0};
        ContentType[] contentType = new ContentType[]{ContentType.fromString("none")};
        return buffer.map(chunk -> {
            int len = chunk.remaining();
            for (int i = 0; i < len; ++i) {
                header[written[0]] = chunk.get(i);
                written[0] = written[0] + 1;
                if (written[0] != 4) continue;
                if (Utility.isJpeg(header)) {
                    contentType[0] = ContentType.IMAGE_JPEG;
                } else if (Utility.isPdf(header)) {
                    contentType[0] = ContentType.APPLICATION_PDF;
                } else if (Utility.isPng(header)) {
                    contentType[0] = ContentType.IMAGE_PNG;
                } else if (Utility.isTiff(header)) {
                    contentType[0] = ContentType.IMAGE_TIFF;
                }
                return false;
            }
            return true;
        }).takeWhile(doContinue -> doContinue).then(Mono.defer(() -> {
            if (contentType[0] != null) {
                return Mono.just((Object)((Object)contentType[0]));
            }
            return Mono.error((Throwable)new RuntimeException("Content type could not be detected. Should use other overload API that takes content type."));
        }));
    }

    private static boolean isJpeg(byte[] header) {
        return header[0] == -1 && header[1] == -40;
    }

    private static boolean isPdf(byte[] header) {
        return header[0] == 37 && header[1] == 80 && header[2] == 68 && header[3] == 70;
    }

    private static boolean isPng(byte[] header) {
        return header[0] == -119 && header[1] == 80 && header[2] == 78 && header[3] == 71;
    }

    private static boolean isTiff(byte[] header) {
        return header[0] == 73 && header[1] == 73 && header[2] == 42 && header[3] == 0 || header[0] == 77 && header[1] == 77 && header[2] == 0 && header[3] == 42;
    }

    public static Flux<ByteBuffer> toFluxByteBuffer(InputStream inputStream) {
        Pair pair = new Pair();
        return Flux.just((Object)true).repeat().map(ignore -> {
            byte[] buffer = new byte[4096];
            try {
                int numBytes = inputStream.read(buffer);
                if (numBytes > 0) {
                    return pair.buffer(ByteBuffer.wrap(buffer, 0, numBytes)).readBytes(numBytes);
                }
                return pair.buffer(null).readBytes(numBytes);
            }
            catch (IOException ioe) {
                throw LOGGER.logExceptionAsError(new RuntimeException(ioe));
            }
        }).takeUntil(p -> p.readBytes() == -1).filter(p -> p.readBytes() > 0).map(Pair::buffer).cache();
    }

    public static String parseModelId(String operationLocation) {
        int lastIndex;
        if (!CoreUtils.isNullOrEmpty((CharSequence)operationLocation) && (lastIndex = operationLocation.lastIndexOf(47)) != -1) {
            return operationLocation.substring(lastIndex + 1);
        }
        throw LOGGER.logExceptionAsError(new RuntimeException("Failed to parse operation header for result Id from: " + operationLocation));
    }

    private static class Pair {
        private ByteBuffer byteBuffer;
        private int readBytes;

        private Pair() {
        }

        ByteBuffer buffer() {
            return this.byteBuffer;
        }

        int readBytes() {
            return this.readBytes;
        }

        Pair buffer(ByteBuffer byteBuffer) {
            this.byteBuffer = byteBuffer;
            return this;
        }

        Pair readBytes(int cnt) {
            this.readBytes = cnt;
            return this;
        }
    }
}

