// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.administration.models;

import com.azure.ai.metricsadvisor.implementation.models.ValueType;
import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;

import java.util.Collection;

/**
 * The measure type that detector should use for measuring data-points when detecting anomalies
 * using {@link MetricBoundaryCondition}.
 */
public final class BoundaryMeasureType extends ExpandableStringEnum<BoundaryMeasureType> {
    /**
     * Static value Value indicating that detector should use raw value of data points.
     */
    public static final BoundaryMeasureType VALUE = fromString(ValueType.VALUE.toString());
    /**
     * Static value Value indicating that detector should use mean value of data points over a period.
     */
    public static final BoundaryMeasureType MEAN = fromString(ValueType.MEAN.toString());

    /**
     * Creates or finds a BoundaryMeasureType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding BoundaryMeasureType.
     */
    @JsonCreator
    public static BoundaryMeasureType fromString(String name) {
        return fromString(name, BoundaryMeasureType.class);
    }

    /** @return known BoundaryMeasureType values. */
    public static Collection<BoundaryMeasureType> values() {
        return values(BoundaryMeasureType.class);
    }
}
