// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.administration.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** The DataFeedIngestionStatus model. */
@Immutable
public final class DataFeedIngestionStatus {
    /*
     * data slice timestamp.
     */
    @JsonProperty(value = "timestamp", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime timestamp;

    /*
     * latest ingestion task status for this data slice.
     */
    @JsonProperty(value = "status", access = JsonProperty.Access.WRITE_ONLY)
    private IngestionStatusType status;

    /*
     * the trimmed message of last ingestion job.
     */
    @JsonProperty(value = "message", access = JsonProperty.Access.WRITE_ONLY)
    private String message;

    /**
     * Get the timestamp property: data slice timestamp.
     *
     * @return the timestamp value.
     */
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    /**
     * Get the status property: latest ingestion task status for this data slice.
     *
     * @return the status value.
     */
    public IngestionStatusType getStatus() {
        return this.status;
    }

    /**
     * Get the message property: the trimmed message of last ingestion job.
     *
     * @return the message value.
     */
    public String getMessage() {
        return this.message;
    }
}
