// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.implementation;

import com.azure.ai.metricsadvisor.implementation.models.AlertResultList;
import com.azure.ai.metricsadvisor.implementation.models.AlertingResultQuery;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyAlertingConfiguration;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyAlertingConfigurationList;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyAlertingConfigurationPatch;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyDetectionConfiguration;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyDetectionConfigurationList;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyDetectionConfigurationPatch;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyDimensionList;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyDimensionQuery;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyResult;
import com.azure.ai.metricsadvisor.implementation.models.AnomalyResultList;
import com.azure.ai.metricsadvisor.implementation.models.CreateAnomalyAlertingConfigurationResponse;
import com.azure.ai.metricsadvisor.implementation.models.CreateAnomalyDetectionConfigurationResponse;
import com.azure.ai.metricsadvisor.implementation.models.CreateCredentialResponse;
import com.azure.ai.metricsadvisor.implementation.models.CreateDataFeedResponse;
import com.azure.ai.metricsadvisor.implementation.models.CreateHookResponse;
import com.azure.ai.metricsadvisor.implementation.models.CreateMetricFeedbackResponse;
import com.azure.ai.metricsadvisor.implementation.models.DataFeedDetail;
import com.azure.ai.metricsadvisor.implementation.models.DataFeedDetailPatch;
import com.azure.ai.metricsadvisor.implementation.models.DataFeedList;
import com.azure.ai.metricsadvisor.implementation.models.DataSourceCredential;
import com.azure.ai.metricsadvisor.implementation.models.DataSourceCredentialList;
import com.azure.ai.metricsadvisor.implementation.models.DataSourceCredentialPatch;
import com.azure.ai.metricsadvisor.implementation.models.DataSourceType;
import com.azure.ai.metricsadvisor.implementation.models.DetectionAnomalyResultQuery;
import com.azure.ai.metricsadvisor.implementation.models.DetectionIncidentResultQuery;
import com.azure.ai.metricsadvisor.implementation.models.DetectionSeriesQuery;
import com.azure.ai.metricsadvisor.implementation.models.EnrichmentStatusList;
import com.azure.ai.metricsadvisor.implementation.models.EnrichmentStatusQueryOption;
import com.azure.ai.metricsadvisor.implementation.models.EntityStatus;
import com.azure.ai.metricsadvisor.implementation.models.Granularity;
import com.azure.ai.metricsadvisor.implementation.models.HookInfo;
import com.azure.ai.metricsadvisor.implementation.models.HookInfoPatch;
import com.azure.ai.metricsadvisor.implementation.models.HookList;
import com.azure.ai.metricsadvisor.implementation.models.IncidentResult;
import com.azure.ai.metricsadvisor.implementation.models.IncidentResultList;
import com.azure.ai.metricsadvisor.implementation.models.IngestionProgressResetOptions;
import com.azure.ai.metricsadvisor.implementation.models.IngestionStatusList;
import com.azure.ai.metricsadvisor.implementation.models.IngestionStatusQueryOptions;
import com.azure.ai.metricsadvisor.implementation.models.MetricDataList;
import com.azure.ai.metricsadvisor.implementation.models.MetricDataQueryOptions;
import com.azure.ai.metricsadvisor.implementation.models.MetricDimensionList;
import com.azure.ai.metricsadvisor.implementation.models.MetricDimensionQueryOptions;
import com.azure.ai.metricsadvisor.implementation.models.MetricFeedback;
import com.azure.ai.metricsadvisor.implementation.models.MetricFeedbackFilter;
import com.azure.ai.metricsadvisor.implementation.models.MetricFeedbackList;
import com.azure.ai.metricsadvisor.implementation.models.MetricSeriesItem;
import com.azure.ai.metricsadvisor.implementation.models.MetricSeriesList;
import com.azure.ai.metricsadvisor.implementation.models.MetricSeriesQueryOptions;
import com.azure.ai.metricsadvisor.implementation.models.RootCauseList;
import com.azure.ai.metricsadvisor.implementation.models.SeriesResultList;
import com.azure.ai.metricsadvisor.implementation.models.UsageStats;
import com.azure.ai.metricsadvisor.models.AnomalyAlert;
import com.azure.ai.metricsadvisor.administration.models.DataFeedIngestionProgress;
import com.azure.ai.metricsadvisor.administration.models.DataFeedIngestionStatus;
import com.azure.ai.metricsadvisor.models.EnrichmentStatus;
import com.azure.ai.metricsadvisor.models.MetricsAdvisorResponseException;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import java.util.UUID;
import reactor.core.publisher.Mono;

/** Initializes a new instance of the AzureCognitiveServiceMetricsAdvisorRestAPIOpenAPIV2 type. */
public final class AzureCognitiveServiceMetricsAdvisorRestAPIOpenAPIV2Impl {
    /** The proxy service used to perform REST calls. */
    private final AzureCognitiveServiceMetricsAdvisorRestAPIOpenAPIV2Service service;

    /**
     * Supported Cognitive Services endpoints (protocol and hostname, for example:
     * https://&lt;resource-name&gt;.cognitiveservices.azure.com).
     */
    private final String endpoint;

    /**
     * Gets Supported Cognitive Services endpoints (protocol and hostname, for example:
     * https://&lt;resource-name&gt;.cognitiveservices.azure.com).
     *
     * @return the endpoint value.
     */
    public String getEndpoint() {
        return this.endpoint;
    }

    /** The HTTP pipeline to send requests through. */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     *
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /** The serializer to serialize an object into a string. */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     *
     * @return the serializerAdapter value.
     */
    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /**
     * Initializes an instance of AzureCognitiveServiceMetricsAdvisorRestAPIOpenAPIV2 client.
     *
     * @param endpoint Supported Cognitive Services endpoints (protocol and hostname, for example:
     *     https://&lt;resource-name&gt;.cognitiveservices.azure.com).
     */
    AzureCognitiveServiceMetricsAdvisorRestAPIOpenAPIV2Impl(String endpoint) {
        this(
                new HttpPipelineBuilder()
                        .policies(new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy())
                        .build(),
                JacksonAdapter.createDefaultSerializerAdapter(),
                endpoint);
    }

    /**
     * Initializes an instance of AzureCognitiveServiceMetricsAdvisorRestAPIOpenAPIV2 client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param endpoint Supported Cognitive Services endpoints (protocol and hostname, for example:
     *     https://&lt;resource-name&gt;.cognitiveservices.azure.com).
     */
    AzureCognitiveServiceMetricsAdvisorRestAPIOpenAPIV2Impl(HttpPipeline httpPipeline, String endpoint) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint);
    }

    /**
     * Initializes an instance of AzureCognitiveServiceMetricsAdvisorRestAPIOpenAPIV2 client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param serializerAdapter The serializer to serialize an object into a string.
     * @param endpoint Supported Cognitive Services endpoints (protocol and hostname, for example:
     *     https://&lt;resource-name&gt;.cognitiveservices.azure.com).
     */
    AzureCognitiveServiceMetricsAdvisorRestAPIOpenAPIV2Impl(
            HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.service =
                RestProxy.create(
                        AzureCognitiveServiceMetricsAdvisorRestAPIOpenAPIV2Service.class,
                        this.httpPipeline,
                        this.getSerializerAdapter());
    }

    /**
     * The interface defining all the services for AzureCognitiveServiceMetricsAdvisorRestAPIOpenAPIV2 to be used by the
     * proxy service to perform REST calls.
     */
    @Host("{endpoint}/metricsadvisor/v1.0")
    @ServiceInterface(name = "AzureCognitiveServic")
    public interface AzureCognitiveServiceMetricsAdvisorRestAPIOpenAPIV2Service {
        @Get("/stats/latest")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<UsageStats>> getActiveSeriesCount(
                @HostParam("endpoint") String endpoint, @HeaderParam("Accept") String accept, Context context);

        @Get("/alert/anomaly/configurations/{configurationId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<AnomalyAlertingConfiguration>> getAnomalyAlertingConfiguration(
                @HostParam("endpoint") String endpoint,
                @PathParam("configurationId") UUID configurationId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Patch("/alert/anomaly/configurations/{configurationId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<AnomalyAlertingConfiguration>> updateAnomalyAlertingConfiguration(
                @HostParam("endpoint") String endpoint,
                @PathParam("configurationId") UUID configurationId,
                @BodyParam("application/merge-patch+json") AnomalyAlertingConfigurationPatch body,
                @HeaderParam("Accept") String accept,
                Context context);

        @Delete("/alert/anomaly/configurations/{configurationId}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<Void>> deleteAnomalyAlertingConfiguration(
                @HostParam("endpoint") String endpoint,
                @PathParam("configurationId") UUID configurationId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/alert/anomaly/configurations")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<CreateAnomalyAlertingConfigurationResponse> createAnomalyAlertingConfiguration(
                @HostParam("endpoint") String endpoint,
                @BodyParam("application/json") AnomalyAlertingConfiguration body,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/alert/anomaly/configurations/{configurationId}/alerts/query")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<AlertResultList>> getAlertsByAnomalyAlertingConfiguration(
                @HostParam("endpoint") String endpoint,
                @PathParam("configurationId") UUID configurationId,
                @QueryParam("$skip") Integer skip,
                @QueryParam("$maxpagesize") Integer maxpagesize,
                @BodyParam("application/json") AlertingResultQuery body,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/alert/anomaly/configurations/{configurationId}/alerts/{alertId}/anomalies")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<AnomalyResultList>> getAnomaliesFromAlertByAnomalyAlertingConfiguration(
                @HostParam("endpoint") String endpoint,
                @PathParam("configurationId") UUID configurationId,
                @PathParam("alertId") String alertId,
                @QueryParam("$skip") Integer skip,
                @QueryParam("$maxpagesize") Integer maxpagesize,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/alert/anomaly/configurations/{configurationId}/alerts/{alertId}/incidents")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<IncidentResultList>> getIncidentsFromAlertByAnomalyAlertingConfiguration(
                @HostParam("endpoint") String endpoint,
                @PathParam("configurationId") UUID configurationId,
                @PathParam("alertId") String alertId,
                @QueryParam("$skip") Integer skip,
                @QueryParam("$maxpagesize") Integer maxpagesize,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/enrichment/anomalyDetection/configurations/{configurationId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<AnomalyDetectionConfiguration>> getAnomalyDetectionConfiguration(
                @HostParam("endpoint") String endpoint,
                @PathParam("configurationId") UUID configurationId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Patch("/enrichment/anomalyDetection/configurations/{configurationId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<AnomalyDetectionConfiguration>> updateAnomalyDetectionConfiguration(
                @HostParam("endpoint") String endpoint,
                @PathParam("configurationId") UUID configurationId,
                @BodyParam("application/merge-patch+json") AnomalyDetectionConfigurationPatch body,
                @HeaderParam("Accept") String accept,
                Context context);

        @Delete("/enrichment/anomalyDetection/configurations/{configurationId}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<Void>> deleteAnomalyDetectionConfiguration(
                @HostParam("endpoint") String endpoint,
                @PathParam("configurationId") UUID configurationId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/enrichment/anomalyDetection/configurations")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<CreateAnomalyDetectionConfigurationResponse> createAnomalyDetectionConfiguration(
                @HostParam("endpoint") String endpoint,
                @BodyParam("application/json") AnomalyDetectionConfiguration body,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/enrichment/anomalyDetection/configurations/{configurationId}/alert/anomaly/configurations")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<AnomalyAlertingConfigurationList>>
                getAnomalyAlertingConfigurationsByAnomalyDetectionConfiguration(
                        @HostParam("endpoint") String endpoint,
                        @PathParam("configurationId") UUID configurationId,
                        @QueryParam("$skip") Integer skip,
                        @QueryParam("$maxpagesize") Integer maxpagesize,
                        @HeaderParam("Accept") String accept,
                        Context context);

        @Post("/enrichment/anomalyDetection/configurations/{configurationId}/series/query")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<SeriesResultList>> getSeriesByAnomalyDetectionConfiguration(
                @HostParam("endpoint") String endpoint,
                @PathParam("configurationId") UUID configurationId,
                @BodyParam("application/json") DetectionSeriesQuery body,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/enrichment/anomalyDetection/configurations/{configurationId}/anomalies/query")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<AnomalyResultList>> getAnomaliesByAnomalyDetectionConfiguration(
                @HostParam("endpoint") String endpoint,
                @PathParam("configurationId") UUID configurationId,
                @QueryParam("$skip") Integer skip,
                @QueryParam("$maxpagesize") Integer maxpagesize,
                @BodyParam("application/json") DetectionAnomalyResultQuery body,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/enrichment/anomalyDetection/configurations/{configurationId}/anomalies/dimension/query")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<AnomalyDimensionList>> getDimensionOfAnomaliesByAnomalyDetectionConfiguration(
                @HostParam("endpoint") String endpoint,
                @PathParam("configurationId") UUID configurationId,
                @QueryParam("$skip") Integer skip,
                @QueryParam("$maxpagesize") Integer maxpagesize,
                @BodyParam("application/json") AnomalyDimensionQuery body,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/enrichment/anomalyDetection/configurations/{configurationId}/incidents/query")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<IncidentResultList>> getIncidentsByAnomalyDetectionConfiguration(
                @HostParam("endpoint") String endpoint,
                @PathParam("configurationId") UUID configurationId,
                @QueryParam("$maxpagesize") Integer maxpagesize,
                @BodyParam("application/json") DetectionIncidentResultQuery body,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/enrichment/anomalyDetection/configurations/{configurationId}/incidents/query")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<IncidentResultList>> getIncidentsByAnomalyDetectionConfigurationNextPages(
                @HostParam("endpoint") String endpoint,
                @PathParam("configurationId") UUID configurationId,
                @QueryParam("$maxpagesize") Integer maxpagesize,
                @QueryParam("$token") String token,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/enrichment/anomalyDetection/configurations/{configurationId}/incidents/{incidentId}/rootCause")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<RootCauseList>> getRootCauseOfIncidentByAnomalyDetectionConfiguration(
                @HostParam("endpoint") String endpoint,
                @PathParam("configurationId") UUID configurationId,
                @PathParam("incidentId") String incidentId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/credentials")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<CreateCredentialResponse> createCredential(
                @HostParam("endpoint") String endpoint,
                @BodyParam("application/json") DataSourceCredential body,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/credentials")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<DataSourceCredentialList>> listCredentials(
                @HostParam("endpoint") String endpoint,
                @QueryParam("$skip") Integer skip,
                @QueryParam("$maxpagesize") Integer maxpagesize,
                @HeaderParam("Accept") String accept,
                Context context);

        @Patch("/credentials/{credentialId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<DataSourceCredential>> updateCredential(
                @HostParam("endpoint") String endpoint,
                @PathParam("credentialId") UUID credentialId,
                @BodyParam("application/merge-patch+json") DataSourceCredentialPatch body,
                @HeaderParam("Accept") String accept,
                Context context);

        @Delete("/credentials/{credentialId}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<Void>> deleteCredential(
                @HostParam("endpoint") String endpoint,
                @PathParam("credentialId") UUID credentialId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/credentials/{credentialId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<DataSourceCredential>> getCredential(
                @HostParam("endpoint") String endpoint,
                @PathParam("credentialId") UUID credentialId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/dataFeeds")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<DataFeedList>> listDataFeeds(
                @HostParam("endpoint") String endpoint,
                @QueryParam("dataFeedName") String dataFeedName,
                @QueryParam("dataSourceType") DataSourceType dataSourceType,
                @QueryParam("granularityName") Granularity granularityName,
                @QueryParam("status") EntityStatus status,
                @QueryParam("creator") String creator,
                @QueryParam("$skip") Integer skip,
                @QueryParam("$maxpagesize") Integer maxpagesize,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/dataFeeds")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<CreateDataFeedResponse> createDataFeed(
                @HostParam("endpoint") String endpoint,
                @BodyParam("application/json") DataFeedDetail body,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/dataFeeds/{dataFeedId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<DataFeedDetail>> getDataFeedById(
                @HostParam("endpoint") String endpoint,
                @PathParam("dataFeedId") UUID dataFeedId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Patch("/dataFeeds/{dataFeedId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<DataFeedDetail>> updateDataFeed(
                @HostParam("endpoint") String endpoint,
                @PathParam("dataFeedId") UUID dataFeedId,
                @BodyParam("application/merge-patch+json") DataFeedDetailPatch body,
                @HeaderParam("Accept") String accept,
                Context context);

        @Delete("/dataFeeds/{dataFeedId}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<Void>> deleteDataFeed(
                @HostParam("endpoint") String endpoint,
                @PathParam("dataFeedId") UUID dataFeedId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/feedback/metric/{feedbackId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<MetricFeedback>> getMetricFeedback(
                @HostParam("endpoint") String endpoint,
                @PathParam("feedbackId") UUID feedbackId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/feedback/metric/query")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<MetricFeedbackList>> listMetricFeedbacks(
                @HostParam("endpoint") String endpoint,
                @QueryParam("$skip") Integer skip,
                @QueryParam("$maxpagesize") Integer maxpagesize,
                @BodyParam("application/json") MetricFeedbackFilter body,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/feedback/metric")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<CreateMetricFeedbackResponse> createMetricFeedback(
                @HostParam("endpoint") String endpoint,
                @BodyParam("application/json") MetricFeedback body,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/hooks")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<HookList>> listHooks(
                @HostParam("endpoint") String endpoint,
                @QueryParam("hookName") String hookName,
                @QueryParam("$skip") Integer skip,
                @QueryParam("$maxpagesize") Integer maxpagesize,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/hooks")
        @ExpectedResponses({201})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<CreateHookResponse> createHook(
                @HostParam("endpoint") String endpoint,
                @BodyParam("application/json") HookInfo body,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/hooks/{hookId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<HookInfo>> getHook(
                @HostParam("endpoint") String endpoint,
                @PathParam("hookId") UUID hookId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Patch("/hooks/{hookId}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<HookInfo>> updateHook(
                @HostParam("endpoint") String endpoint,
                @PathParam("hookId") UUID hookId,
                @BodyParam("application/merge-patch+json") HookInfoPatch body,
                @HeaderParam("Accept") String accept,
                Context context);

        @Delete("/hooks/{hookId}")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<Void>> deleteHook(
                @HostParam("endpoint") String endpoint,
                @PathParam("hookId") UUID hookId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/dataFeeds/{dataFeedId}/ingestionStatus/query")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<IngestionStatusList>> getDataFeedIngestionStatus(
                @HostParam("endpoint") String endpoint,
                @PathParam("dataFeedId") UUID dataFeedId,
                @QueryParam("$skip") Integer skip,
                @QueryParam("$maxpagesize") Integer maxpagesize,
                @BodyParam("application/json") IngestionStatusQueryOptions body,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/dataFeeds/{dataFeedId}/ingestionProgress/reset")
        @ExpectedResponses({204})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<Void>> resetDataFeedIngestionStatus(
                @HostParam("endpoint") String endpoint,
                @PathParam("dataFeedId") UUID dataFeedId,
                @BodyParam("application/json") IngestionProgressResetOptions body,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/dataFeeds/{dataFeedId}/ingestionProgress")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<DataFeedIngestionProgress>> getIngestionProgress(
                @HostParam("endpoint") String endpoint,
                @PathParam("dataFeedId") UUID dataFeedId,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/metrics/{metricId}/data/query")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<MetricDataList>> getMetricData(
                @HostParam("endpoint") String endpoint,
                @PathParam("metricId") UUID metricId,
                @BodyParam("application/json") MetricDataQueryOptions body,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/metrics/{metricId}/series/query")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<MetricSeriesList>> getMetricSeries(
                @HostParam("endpoint") String endpoint,
                @PathParam("metricId") UUID metricId,
                @QueryParam("$skip") Integer skip,
                @QueryParam("$maxpagesize") Integer maxpagesize,
                @BodyParam("application/json") MetricSeriesQueryOptions body,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/metrics/{metricId}/dimension/query")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<MetricDimensionList>> getMetricDimension(
                @HostParam("endpoint") String endpoint,
                @PathParam("metricId") UUID metricId,
                @QueryParam("$skip") Integer skip,
                @QueryParam("$maxpagesize") Integer maxpagesize,
                @BodyParam("application/json") MetricDimensionQueryOptions body,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("/metrics/{metricId}/enrichment/anomalyDetection/configurations")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<AnomalyDetectionConfigurationList>> getAnomalyDetectionConfigurationsByMetric(
                @HostParam("endpoint") String endpoint,
                @PathParam("metricId") UUID metricId,
                @QueryParam("$skip") Integer skip,
                @QueryParam("$maxpagesize") Integer maxpagesize,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("/metrics/{metricId}/status/enrichment/anomalyDetection/query")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<EnrichmentStatusList>> getEnrichmentStatusByMetric(
                @HostParam("endpoint") String endpoint,
                @PathParam("metricId") UUID metricId,
                @QueryParam("$skip") Integer skip,
                @QueryParam("$maxpagesize") Integer maxpagesize,
                @BodyParam("application/json") EnrichmentStatusQueryOption body,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<AlertResultList>> getAlertsByAnomalyAlertingConfigurationNext(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @BodyParam("application/json") AlertingResultQuery body,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<AnomalyResultList>> getAnomaliesByAnomalyDetectionConfigurationNext(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @BodyParam("application/json") DetectionAnomalyResultQuery body,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<AnomalyDimensionList>> getDimensionOfAnomaliesByAnomalyDetectionConfigurationNext(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @BodyParam("application/json") AnomalyDimensionQuery body,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<MetricFeedbackList>> listMetricFeedbacksNext(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @BodyParam("application/json") MetricFeedbackFilter body,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<IngestionStatusList>> getDataFeedIngestionStatusNext(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @BodyParam("application/json") IngestionStatusQueryOptions body,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<MetricSeriesList>> getMetricSeriesNext(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @BodyParam("application/json") MetricSeriesQueryOptions body,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<MetricDimensionList>> getMetricDimensionNext(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @BodyParam("application/json") MetricDimensionQueryOptions body,
                @HeaderParam("Accept") String accept,
                Context context);

        @Post("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<EnrichmentStatusList>> getEnrichmentStatusByMetricNext(
                @HostParam("endpoint") String endpoint,
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @BodyParam("application/json") EnrichmentStatusQueryOption body,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<AnomalyResultList>> getAnomaliesFromAlertByAnomalyAlertingConfigurationNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("endpoint") String endpoint,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<IncidentResultList>> getIncidentsFromAlertByAnomalyAlertingConfigurationNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("endpoint") String endpoint,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<AnomalyAlertingConfigurationList>>
                getAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationNext(
                        @PathParam(value = "nextLink", encoded = true) String nextLink,
                        @HostParam("endpoint") String endpoint,
                        @HeaderParam("Accept") String accept,
                        Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<IncidentResultList>> getIncidentsByAnomalyDetectionConfigurationNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("endpoint") String endpoint,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<IncidentResultList>> getIncidentsByAnomalyDetectionConfigurationNextPagesNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("endpoint") String endpoint,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<DataSourceCredentialList>> listCredentialsNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("endpoint") String endpoint,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<DataFeedList>> listDataFeedsNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("endpoint") String endpoint,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<HookList>> listHooksNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("endpoint") String endpoint,
                @HeaderParam("Accept") String accept,
                Context context);

        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(MetricsAdvisorResponseException.class)
        Mono<Response<AnomalyDetectionConfigurationList>> getAnomalyDetectionConfigurationsByMetricNext(
                @PathParam(value = "nextLink", encoded = true) String nextLink,
                @HostParam("endpoint") String endpoint,
                @HeaderParam("Accept") String accept,
                Context context);
    }

    /**
     * Get latest usage stats.
     *
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return latest usage stats.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<UsageStats>> getActiveSeriesCountWithResponseAsync() {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getActiveSeriesCount(this.getEndpoint(), accept, context));
    }

    /**
     * Get latest usage stats.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return latest usage stats.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<UsageStats>> getActiveSeriesCountWithResponseAsync(Context context) {
        final String accept = "application/json";
        return service.getActiveSeriesCount(this.getEndpoint(), accept, context);
    }

    /**
     * Get latest usage stats.
     *
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return latest usage stats.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<UsageStats> getActiveSeriesCountAsync() {
        return getActiveSeriesCountWithResponseAsync()
                .flatMap(
                        (Response<UsageStats> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Get latest usage stats.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return latest usage stats.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<UsageStats> getActiveSeriesCountAsync(Context context) {
        return getActiveSeriesCountWithResponseAsync(context)
                .flatMap(
                        (Response<UsageStats> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Get latest usage stats.
     *
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return latest usage stats.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public UsageStats getActiveSeriesCount() {
        return getActiveSeriesCountAsync().block();
    }

    /**
     * Get latest usage stats.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return latest usage stats.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<UsageStats> getActiveSeriesCountWithResponse(Context context) {
        return getActiveSeriesCountWithResponseAsync(context).block();
    }

    /**
     * Query a single anomaly alerting configuration.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnomalyAlertingConfiguration>> getAnomalyAlertingConfigurationWithResponseAsync(
            UUID configurationId) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getAnomalyAlertingConfiguration(this.getEndpoint(), configurationId, accept, context));
    }

    /**
     * Query a single anomaly alerting configuration.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnomalyAlertingConfiguration>> getAnomalyAlertingConfigurationWithResponseAsync(
            UUID configurationId, Context context) {
        final String accept = "application/json";
        return service.getAnomalyAlertingConfiguration(this.getEndpoint(), configurationId, accept, context);
    }

    /**
     * Query a single anomaly alerting configuration.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnomalyAlertingConfiguration> getAnomalyAlertingConfigurationAsync(UUID configurationId) {
        return getAnomalyAlertingConfigurationWithResponseAsync(configurationId)
                .flatMap(
                        (Response<AnomalyAlertingConfiguration> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Query a single anomaly alerting configuration.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnomalyAlertingConfiguration> getAnomalyAlertingConfigurationAsync(
            UUID configurationId, Context context) {
        return getAnomalyAlertingConfigurationWithResponseAsync(configurationId, context)
                .flatMap(
                        (Response<AnomalyAlertingConfiguration> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Query a single anomaly alerting configuration.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnomalyAlertingConfiguration getAnomalyAlertingConfiguration(UUID configurationId) {
        return getAnomalyAlertingConfigurationAsync(configurationId).block();
    }

    /**
     * Query a single anomaly alerting configuration.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AnomalyAlertingConfiguration> getAnomalyAlertingConfigurationWithResponse(
            UUID configurationId, Context context) {
        return getAnomalyAlertingConfigurationWithResponseAsync(configurationId, context).block();
    }

    /**
     * Update anomaly alerting configuration.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @param body anomaly alerting configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnomalyAlertingConfiguration>> updateAnomalyAlertingConfigurationWithResponseAsync(
            UUID configurationId, AnomalyAlertingConfigurationPatch body) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.updateAnomalyAlertingConfiguration(
                                this.getEndpoint(), configurationId, body, accept, context));
    }

    /**
     * Update anomaly alerting configuration.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @param body anomaly alerting configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnomalyAlertingConfiguration>> updateAnomalyAlertingConfigurationWithResponseAsync(
            UUID configurationId, AnomalyAlertingConfigurationPatch body, Context context) {
        final String accept = "application/json";
        return service.updateAnomalyAlertingConfiguration(this.getEndpoint(), configurationId, body, accept, context);
    }

    /**
     * Update anomaly alerting configuration.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @param body anomaly alerting configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnomalyAlertingConfiguration> updateAnomalyAlertingConfigurationAsync(
            UUID configurationId, AnomalyAlertingConfigurationPatch body) {
        return updateAnomalyAlertingConfigurationWithResponseAsync(configurationId, body)
                .flatMap(
                        (Response<AnomalyAlertingConfiguration> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Update anomaly alerting configuration.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @param body anomaly alerting configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnomalyAlertingConfiguration> updateAnomalyAlertingConfigurationAsync(
            UUID configurationId, AnomalyAlertingConfigurationPatch body, Context context) {
        return updateAnomalyAlertingConfigurationWithResponseAsync(configurationId, body, context)
                .flatMap(
                        (Response<AnomalyAlertingConfiguration> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Update anomaly alerting configuration.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @param body anomaly alerting configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnomalyAlertingConfiguration updateAnomalyAlertingConfiguration(
            UUID configurationId, AnomalyAlertingConfigurationPatch body) {
        return updateAnomalyAlertingConfigurationAsync(configurationId, body).block();
    }

    /**
     * Update anomaly alerting configuration.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @param body anomaly alerting configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AnomalyAlertingConfiguration> updateAnomalyAlertingConfigurationWithResponse(
            UUID configurationId, AnomalyAlertingConfigurationPatch body, Context context) {
        return updateAnomalyAlertingConfigurationWithResponseAsync(configurationId, body, context).block();
    }

    /**
     * Delete anomaly alerting configuration.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteAnomalyAlertingConfigurationWithResponseAsync(UUID configurationId) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.deleteAnomalyAlertingConfiguration(
                                this.getEndpoint(), configurationId, accept, context));
    }

    /**
     * Delete anomaly alerting configuration.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteAnomalyAlertingConfigurationWithResponseAsync(
            UUID configurationId, Context context) {
        final String accept = "application/json";
        return service.deleteAnomalyAlertingConfiguration(this.getEndpoint(), configurationId, accept, context);
    }

    /**
     * Delete anomaly alerting configuration.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAnomalyAlertingConfigurationAsync(UUID configurationId) {
        return deleteAnomalyAlertingConfigurationWithResponseAsync(configurationId)
                .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete anomaly alerting configuration.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAnomalyAlertingConfigurationAsync(UUID configurationId, Context context) {
        return deleteAnomalyAlertingConfigurationWithResponseAsync(configurationId, context)
                .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete anomaly alerting configuration.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteAnomalyAlertingConfiguration(UUID configurationId) {
        deleteAnomalyAlertingConfigurationAsync(configurationId).block();
    }

    /**
     * Delete anomaly alerting configuration.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteAnomalyAlertingConfigurationWithResponse(UUID configurationId, Context context) {
        return deleteAnomalyAlertingConfigurationWithResponseAsync(configurationId, context).block();
    }

    /**
     * Create anomaly alerting configuration.
     *
     * @param body anomaly alerting configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CreateAnomalyAlertingConfigurationResponse> createAnomalyAlertingConfigurationWithResponseAsync(
            AnomalyAlertingConfiguration body) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context -> service.createAnomalyAlertingConfiguration(this.getEndpoint(), body, accept, context));
    }

    /**
     * Create anomaly alerting configuration.
     *
     * @param body anomaly alerting configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CreateAnomalyAlertingConfigurationResponse> createAnomalyAlertingConfigurationWithResponseAsync(
            AnomalyAlertingConfiguration body, Context context) {
        final String accept = "application/json";
        return service.createAnomalyAlertingConfiguration(this.getEndpoint(), body, accept, context);
    }

    /**
     * Create anomaly alerting configuration.
     *
     * @param body anomaly alerting configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> createAnomalyAlertingConfigurationAsync(AnomalyAlertingConfiguration body) {
        return createAnomalyAlertingConfigurationWithResponseAsync(body)
                .flatMap((CreateAnomalyAlertingConfigurationResponse res) -> Mono.empty());
    }

    /**
     * Create anomaly alerting configuration.
     *
     * @param body anomaly alerting configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> createAnomalyAlertingConfigurationAsync(AnomalyAlertingConfiguration body, Context context) {
        return createAnomalyAlertingConfigurationWithResponseAsync(body, context)
                .flatMap((CreateAnomalyAlertingConfigurationResponse res) -> Mono.empty());
    }

    /**
     * Create anomaly alerting configuration.
     *
     * @param body anomaly alerting configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void createAnomalyAlertingConfiguration(AnomalyAlertingConfiguration body) {
        createAnomalyAlertingConfigurationAsync(body).block();
    }

    /**
     * Create anomaly alerting configuration.
     *
     * @param body anomaly alerting configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> createAnomalyAlertingConfigurationWithResponse(
            AnomalyAlertingConfiguration body, Context context) {
        return createAnomalyAlertingConfigurationWithResponseAsync(body, context).block();
    }

    /**
     * Query alerts under anomaly alerting configuration.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @param body query alerting result request.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyAlert>> getAlertsByAnomalyAlertingConfigurationSinglePageAsync(
            UUID configurationId, AlertingResultQuery body, Integer skip, Integer maxpagesize) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.getAlertsByAnomalyAlertingConfiguration(
                                        this.getEndpoint(), configurationId, skip, maxpagesize, body, accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Query alerts under anomaly alerting configuration.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @param body query alerting result request.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyAlert>> getAlertsByAnomalyAlertingConfigurationSinglePageAsync(
            UUID configurationId, AlertingResultQuery body, Integer skip, Integer maxpagesize, Context context) {
        final String accept = "application/json";
        return service.getAlertsByAnomalyAlertingConfiguration(
                        this.getEndpoint(), configurationId, skip, maxpagesize, body, accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Query alerts under anomaly alerting configuration.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @param body query alerting result request.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<AnomalyAlert> getAlertsByAnomalyAlertingConfigurationAsync(
            UUID configurationId, AlertingResultQuery body, Integer skip, Integer maxpagesize) {
        return new PagedFlux<>(
                () -> getAlertsByAnomalyAlertingConfigurationSinglePageAsync(configurationId, body, skip, maxpagesize),
                nextLink -> getAlertsByAnomalyAlertingConfigurationNextSinglePageAsync(nextLink, body));
    }

    /**
     * Query alerts under anomaly alerting configuration.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @param body query alerting result request.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<AnomalyAlert> getAlertsByAnomalyAlertingConfigurationAsync(
            UUID configurationId, AlertingResultQuery body, Integer skip, Integer maxpagesize, Context context) {
        return new PagedFlux<>(
                () ->
                        getAlertsByAnomalyAlertingConfigurationSinglePageAsync(
                                configurationId, body, skip, maxpagesize, context),
                nextLink -> getAlertsByAnomalyAlertingConfigurationNextSinglePageAsync(nextLink, body, context));
    }

    /**
     * Query alerts under anomaly alerting configuration.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @param body query alerting result request.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<AnomalyAlert> getAlertsByAnomalyAlertingConfiguration(
            UUID configurationId, AlertingResultQuery body, Integer skip, Integer maxpagesize) {
        return new PagedIterable<>(
                getAlertsByAnomalyAlertingConfigurationAsync(configurationId, body, skip, maxpagesize));
    }

    /**
     * Query alerts under anomaly alerting configuration.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @param body query alerting result request.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<AnomalyAlert> getAlertsByAnomalyAlertingConfiguration(
            UUID configurationId, AlertingResultQuery body, Integer skip, Integer maxpagesize, Context context) {
        return new PagedIterable<>(
                getAlertsByAnomalyAlertingConfigurationAsync(configurationId, body, skip, maxpagesize, context));
    }

    /**
     * Query anomalies under a specific alert.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @param alertId alert id.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyResult>> getAnomaliesFromAlertByAnomalyAlertingConfigurationSinglePageAsync(
            UUID configurationId, String alertId, Integer skip, Integer maxpagesize) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.getAnomaliesFromAlertByAnomalyAlertingConfiguration(
                                        this.getEndpoint(),
                                        configurationId,
                                        alertId,
                                        skip,
                                        maxpagesize,
                                        accept,
                                        context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Query anomalies under a specific alert.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @param alertId alert id.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyResult>> getAnomaliesFromAlertByAnomalyAlertingConfigurationSinglePageAsync(
            UUID configurationId, String alertId, Integer skip, Integer maxpagesize, Context context) {
        final String accept = "application/json";
        return service.getAnomaliesFromAlertByAnomalyAlertingConfiguration(
                        this.getEndpoint(), configurationId, alertId, skip, maxpagesize, accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Query anomalies under a specific alert.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @param alertId alert id.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<AnomalyResult> getAnomaliesFromAlertByAnomalyAlertingConfigurationAsync(
            UUID configurationId, String alertId, Integer skip, Integer maxpagesize) {
        return new PagedFlux<>(
                () ->
                        getAnomaliesFromAlertByAnomalyAlertingConfigurationSinglePageAsync(
                                configurationId, alertId, skip, maxpagesize),
                nextLink -> getAnomaliesFromAlertByAnomalyAlertingConfigurationNextSinglePageAsync(nextLink));
    }

    /**
     * Query anomalies under a specific alert.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @param alertId alert id.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<AnomalyResult> getAnomaliesFromAlertByAnomalyAlertingConfigurationAsync(
            UUID configurationId, String alertId, Integer skip, Integer maxpagesize, Context context) {
        return new PagedFlux<>(
                () ->
                        getAnomaliesFromAlertByAnomalyAlertingConfigurationSinglePageAsync(
                                configurationId, alertId, skip, maxpagesize, context),
                nextLink -> getAnomaliesFromAlertByAnomalyAlertingConfigurationNextSinglePageAsync(nextLink, context));
    }

    /**
     * Query anomalies under a specific alert.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @param alertId alert id.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<AnomalyResult> getAnomaliesFromAlertByAnomalyAlertingConfiguration(
            UUID configurationId, String alertId, Integer skip, Integer maxpagesize) {
        return new PagedIterable<>(
                getAnomaliesFromAlertByAnomalyAlertingConfigurationAsync(configurationId, alertId, skip, maxpagesize));
    }

    /**
     * Query anomalies under a specific alert.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @param alertId alert id.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<AnomalyResult> getAnomaliesFromAlertByAnomalyAlertingConfiguration(
            UUID configurationId, String alertId, Integer skip, Integer maxpagesize, Context context) {
        return new PagedIterable<>(
                getAnomaliesFromAlertByAnomalyAlertingConfigurationAsync(
                        configurationId, alertId, skip, maxpagesize, context));
    }

    /**
     * Query incidents under a specific alert.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @param alertId alert id.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<IncidentResult>> getIncidentsFromAlertByAnomalyAlertingConfigurationSinglePageAsync(
            UUID configurationId, String alertId, Integer skip, Integer maxpagesize) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.getIncidentsFromAlertByAnomalyAlertingConfiguration(
                                        this.getEndpoint(),
                                        configurationId,
                                        alertId,
                                        skip,
                                        maxpagesize,
                                        accept,
                                        context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Query incidents under a specific alert.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @param alertId alert id.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<IncidentResult>> getIncidentsFromAlertByAnomalyAlertingConfigurationSinglePageAsync(
            UUID configurationId, String alertId, Integer skip, Integer maxpagesize, Context context) {
        final String accept = "application/json";
        return service.getIncidentsFromAlertByAnomalyAlertingConfiguration(
                        this.getEndpoint(), configurationId, alertId, skip, maxpagesize, accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Query incidents under a specific alert.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @param alertId alert id.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<IncidentResult> getIncidentsFromAlertByAnomalyAlertingConfigurationAsync(
            UUID configurationId, String alertId, Integer skip, Integer maxpagesize) {
        return new PagedFlux<>(
                () ->
                        getIncidentsFromAlertByAnomalyAlertingConfigurationSinglePageAsync(
                                configurationId, alertId, skip, maxpagesize),
                nextLink -> getIncidentsFromAlertByAnomalyAlertingConfigurationNextSinglePageAsync(nextLink));
    }

    /**
     * Query incidents under a specific alert.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @param alertId alert id.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<IncidentResult> getIncidentsFromAlertByAnomalyAlertingConfigurationAsync(
            UUID configurationId, String alertId, Integer skip, Integer maxpagesize, Context context) {
        return new PagedFlux<>(
                () ->
                        getIncidentsFromAlertByAnomalyAlertingConfigurationSinglePageAsync(
                                configurationId, alertId, skip, maxpagesize, context),
                nextLink -> getIncidentsFromAlertByAnomalyAlertingConfigurationNextSinglePageAsync(nextLink, context));
    }

    /**
     * Query incidents under a specific alert.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @param alertId alert id.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<IncidentResult> getIncidentsFromAlertByAnomalyAlertingConfiguration(
            UUID configurationId, String alertId, Integer skip, Integer maxpagesize) {
        return new PagedIterable<>(
                getIncidentsFromAlertByAnomalyAlertingConfigurationAsync(configurationId, alertId, skip, maxpagesize));
    }

    /**
     * Query incidents under a specific alert.
     *
     * @param configurationId anomaly alerting configuration unique id.
     * @param alertId alert id.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<IncidentResult> getIncidentsFromAlertByAnomalyAlertingConfiguration(
            UUID configurationId, String alertId, Integer skip, Integer maxpagesize, Context context) {
        return new PagedIterable<>(
                getIncidentsFromAlertByAnomalyAlertingConfigurationAsync(
                        configurationId, alertId, skip, maxpagesize, context));
    }

    /**
     * Query a single anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnomalyDetectionConfiguration>> getAnomalyDetectionConfigurationWithResponseAsync(
            UUID configurationId) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getAnomalyDetectionConfiguration(this.getEndpoint(), configurationId, accept, context));
    }

    /**
     * Query a single anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnomalyDetectionConfiguration>> getAnomalyDetectionConfigurationWithResponseAsync(
            UUID configurationId, Context context) {
        final String accept = "application/json";
        return service.getAnomalyDetectionConfiguration(this.getEndpoint(), configurationId, accept, context);
    }

    /**
     * Query a single anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnomalyDetectionConfiguration> getAnomalyDetectionConfigurationAsync(UUID configurationId) {
        return getAnomalyDetectionConfigurationWithResponseAsync(configurationId)
                .flatMap(
                        (Response<AnomalyDetectionConfiguration> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Query a single anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnomalyDetectionConfiguration> getAnomalyDetectionConfigurationAsync(
            UUID configurationId, Context context) {
        return getAnomalyDetectionConfigurationWithResponseAsync(configurationId, context)
                .flatMap(
                        (Response<AnomalyDetectionConfiguration> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Query a single anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnomalyDetectionConfiguration getAnomalyDetectionConfiguration(UUID configurationId) {
        return getAnomalyDetectionConfigurationAsync(configurationId).block();
    }

    /**
     * Query a single anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AnomalyDetectionConfiguration> getAnomalyDetectionConfigurationWithResponse(
            UUID configurationId, Context context) {
        return getAnomalyDetectionConfigurationWithResponseAsync(configurationId, context).block();
    }

    /**
     * Update anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param body anomaly detection configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnomalyDetectionConfiguration>> updateAnomalyDetectionConfigurationWithResponseAsync(
            UUID configurationId, AnomalyDetectionConfigurationPatch body) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.updateAnomalyDetectionConfiguration(
                                this.getEndpoint(), configurationId, body, accept, context));
    }

    /**
     * Update anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param body anomaly detection configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<AnomalyDetectionConfiguration>> updateAnomalyDetectionConfigurationWithResponseAsync(
            UUID configurationId, AnomalyDetectionConfigurationPatch body, Context context) {
        final String accept = "application/json";
        return service.updateAnomalyDetectionConfiguration(this.getEndpoint(), configurationId, body, accept, context);
    }

    /**
     * Update anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param body anomaly detection configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnomalyDetectionConfiguration> updateAnomalyDetectionConfigurationAsync(
            UUID configurationId, AnomalyDetectionConfigurationPatch body) {
        return updateAnomalyDetectionConfigurationWithResponseAsync(configurationId, body)
                .flatMap(
                        (Response<AnomalyDetectionConfiguration> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Update anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param body anomaly detection configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<AnomalyDetectionConfiguration> updateAnomalyDetectionConfigurationAsync(
            UUID configurationId, AnomalyDetectionConfigurationPatch body, Context context) {
        return updateAnomalyDetectionConfigurationWithResponseAsync(configurationId, body, context)
                .flatMap(
                        (Response<AnomalyDetectionConfiguration> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Update anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param body anomaly detection configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public AnomalyDetectionConfiguration updateAnomalyDetectionConfiguration(
            UUID configurationId, AnomalyDetectionConfigurationPatch body) {
        return updateAnomalyDetectionConfigurationAsync(configurationId, body).block();
    }

    /**
     * Update anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param body anomaly detection configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<AnomalyDetectionConfiguration> updateAnomalyDetectionConfigurationWithResponse(
            UUID configurationId, AnomalyDetectionConfigurationPatch body, Context context) {
        return updateAnomalyDetectionConfigurationWithResponseAsync(configurationId, body, context).block();
    }

    /**
     * Delete anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteAnomalyDetectionConfigurationWithResponseAsync(UUID configurationId) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.deleteAnomalyDetectionConfiguration(
                                this.getEndpoint(), configurationId, accept, context));
    }

    /**
     * Delete anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteAnomalyDetectionConfigurationWithResponseAsync(
            UUID configurationId, Context context) {
        final String accept = "application/json";
        return service.deleteAnomalyDetectionConfiguration(this.getEndpoint(), configurationId, accept, context);
    }

    /**
     * Delete anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAnomalyDetectionConfigurationAsync(UUID configurationId) {
        return deleteAnomalyDetectionConfigurationWithResponseAsync(configurationId)
                .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAnomalyDetectionConfigurationAsync(UUID configurationId, Context context) {
        return deleteAnomalyDetectionConfigurationWithResponseAsync(configurationId, context)
                .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteAnomalyDetectionConfiguration(UUID configurationId) {
        deleteAnomalyDetectionConfigurationAsync(configurationId).block();
    }

    /**
     * Delete anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteAnomalyDetectionConfigurationWithResponse(UUID configurationId, Context context) {
        return deleteAnomalyDetectionConfigurationWithResponseAsync(configurationId, context).block();
    }

    /**
     * Create anomaly detection configuration.
     *
     * @param body anomaly detection configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CreateAnomalyDetectionConfigurationResponse> createAnomalyDetectionConfigurationWithResponseAsync(
            AnomalyDetectionConfiguration body) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context -> service.createAnomalyDetectionConfiguration(this.getEndpoint(), body, accept, context));
    }

    /**
     * Create anomaly detection configuration.
     *
     * @param body anomaly detection configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CreateAnomalyDetectionConfigurationResponse> createAnomalyDetectionConfigurationWithResponseAsync(
            AnomalyDetectionConfiguration body, Context context) {
        final String accept = "application/json";
        return service.createAnomalyDetectionConfiguration(this.getEndpoint(), body, accept, context);
    }

    /**
     * Create anomaly detection configuration.
     *
     * @param body anomaly detection configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> createAnomalyDetectionConfigurationAsync(AnomalyDetectionConfiguration body) {
        return createAnomalyDetectionConfigurationWithResponseAsync(body)
                .flatMap((CreateAnomalyDetectionConfigurationResponse res) -> Mono.empty());
    }

    /**
     * Create anomaly detection configuration.
     *
     * @param body anomaly detection configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> createAnomalyDetectionConfigurationAsync(AnomalyDetectionConfiguration body, Context context) {
        return createAnomalyDetectionConfigurationWithResponseAsync(body, context)
                .flatMap((CreateAnomalyDetectionConfigurationResponse res) -> Mono.empty());
    }

    /**
     * Create anomaly detection configuration.
     *
     * @param body anomaly detection configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void createAnomalyDetectionConfiguration(AnomalyDetectionConfiguration body) {
        createAnomalyDetectionConfigurationAsync(body).block();
    }

    /**
     * Create anomaly detection configuration.
     *
     * @param body anomaly detection configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> createAnomalyDetectionConfigurationWithResponse(
            AnomalyDetectionConfiguration body, Context context) {
        return createAnomalyDetectionConfigurationWithResponseAsync(body, context).block();
    }

    /**
     * List all anomaly alerting configurations for specific anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyAlertingConfiguration>>
            getAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationSinglePageAsync(
                    UUID configurationId, Integer skip, Integer maxpagesize) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.getAnomalyAlertingConfigurationsByAnomalyDetectionConfiguration(
                                        this.getEndpoint(), configurationId, skip, maxpagesize, accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * List all anomaly alerting configurations for specific anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyAlertingConfiguration>>
            getAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationSinglePageAsync(
                    UUID configurationId, Integer skip, Integer maxpagesize, Context context) {
        final String accept = "application/json";
        return service.getAnomalyAlertingConfigurationsByAnomalyDetectionConfiguration(
                        this.getEndpoint(), configurationId, skip, maxpagesize, accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * List all anomaly alerting configurations for specific anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<AnomalyAlertingConfiguration> getAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationAsync(
            UUID configurationId, Integer skip, Integer maxpagesize) {
        return new PagedFlux<>(
                () ->
                        getAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationSinglePageAsync(
                                configurationId, skip, maxpagesize),
                nextLink ->
                        getAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationNextSinglePageAsync(nextLink));
    }

    /**
     * List all anomaly alerting configurations for specific anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<AnomalyAlertingConfiguration> getAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationAsync(
            UUID configurationId, Integer skip, Integer maxpagesize, Context context) {
        return new PagedFlux<>(
                () ->
                        getAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationSinglePageAsync(
                                configurationId, skip, maxpagesize, context),
                nextLink ->
                        getAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationNextSinglePageAsync(
                                nextLink, context));
    }

    /**
     * List all anomaly alerting configurations for specific anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<AnomalyAlertingConfiguration> getAnomalyAlertingConfigurationsByAnomalyDetectionConfiguration(
            UUID configurationId, Integer skip, Integer maxpagesize) {
        return new PagedIterable<>(
                getAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationAsync(
                        configurationId, skip, maxpagesize));
    }

    /**
     * List all anomaly alerting configurations for specific anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<AnomalyAlertingConfiguration> getAnomalyAlertingConfigurationsByAnomalyDetectionConfiguration(
            UUID configurationId, Integer skip, Integer maxpagesize, Context context) {
        return new PagedIterable<>(
                getAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationAsync(
                        configurationId, skip, maxpagesize, context));
    }

    /**
     * Query series enriched by anomaly detection.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param body query series detection result request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SeriesResultList>> getSeriesByAnomalyDetectionConfigurationWithResponseAsync(
            UUID configurationId, DetectionSeriesQuery body) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getSeriesByAnomalyDetectionConfiguration(
                                this.getEndpoint(), configurationId, body, accept, context));
    }

    /**
     * Query series enriched by anomaly detection.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param body query series detection result request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SeriesResultList>> getSeriesByAnomalyDetectionConfigurationWithResponseAsync(
            UUID configurationId, DetectionSeriesQuery body, Context context) {
        final String accept = "application/json";
        return service.getSeriesByAnomalyDetectionConfiguration(
                this.getEndpoint(), configurationId, body, accept, context);
    }

    /**
     * Query series enriched by anomaly detection.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param body query series detection result request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SeriesResultList> getSeriesByAnomalyDetectionConfigurationAsync(
            UUID configurationId, DetectionSeriesQuery body) {
        return getSeriesByAnomalyDetectionConfigurationWithResponseAsync(configurationId, body)
                .flatMap(
                        (Response<SeriesResultList> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Query series enriched by anomaly detection.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param body query series detection result request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SeriesResultList> getSeriesByAnomalyDetectionConfigurationAsync(
            UUID configurationId, DetectionSeriesQuery body, Context context) {
        return getSeriesByAnomalyDetectionConfigurationWithResponseAsync(configurationId, body, context)
                .flatMap(
                        (Response<SeriesResultList> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Query series enriched by anomaly detection.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param body query series detection result request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SeriesResultList getSeriesByAnomalyDetectionConfiguration(UUID configurationId, DetectionSeriesQuery body) {
        return getSeriesByAnomalyDetectionConfigurationAsync(configurationId, body).block();
    }

    /**
     * Query series enriched by anomaly detection.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param body query series detection result request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SeriesResultList> getSeriesByAnomalyDetectionConfigurationWithResponse(
            UUID configurationId, DetectionSeriesQuery body, Context context) {
        return getSeriesByAnomalyDetectionConfigurationWithResponseAsync(configurationId, body, context).block();
    }

    /**
     * Query anomalies under anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param body query detection anomaly result request.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyResult>> getAnomaliesByAnomalyDetectionConfigurationSinglePageAsync(
            UUID configurationId, DetectionAnomalyResultQuery body, Integer skip, Integer maxpagesize) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.getAnomaliesByAnomalyDetectionConfiguration(
                                        this.getEndpoint(), configurationId, skip, maxpagesize, body, accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Query anomalies under anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param body query detection anomaly result request.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyResult>> getAnomaliesByAnomalyDetectionConfigurationSinglePageAsync(
            UUID configurationId,
            DetectionAnomalyResultQuery body,
            Integer skip,
            Integer maxpagesize,
            Context context) {
        final String accept = "application/json";
        return service.getAnomaliesByAnomalyDetectionConfiguration(
                        this.getEndpoint(), configurationId, skip, maxpagesize, body, accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Query anomalies under anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param body query detection anomaly result request.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<AnomalyResult> getAnomaliesByAnomalyDetectionConfigurationAsync(
            UUID configurationId, DetectionAnomalyResultQuery body, Integer skip, Integer maxpagesize) {
        return new PagedFlux<>(
                () ->
                        getAnomaliesByAnomalyDetectionConfigurationSinglePageAsync(
                                configurationId, body, skip, maxpagesize),
                nextLink -> getAnomaliesByAnomalyDetectionConfigurationNextSinglePageAsync(nextLink, body));
    }

    /**
     * Query anomalies under anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param body query detection anomaly result request.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<AnomalyResult> getAnomaliesByAnomalyDetectionConfigurationAsync(
            UUID configurationId,
            DetectionAnomalyResultQuery body,
            Integer skip,
            Integer maxpagesize,
            Context context) {
        return new PagedFlux<>(
                () ->
                        getAnomaliesByAnomalyDetectionConfigurationSinglePageAsync(
                                configurationId, body, skip, maxpagesize, context),
                nextLink -> getAnomaliesByAnomalyDetectionConfigurationNextSinglePageAsync(nextLink, body, context));
    }

    /**
     * Query anomalies under anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param body query detection anomaly result request.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<AnomalyResult> getAnomaliesByAnomalyDetectionConfiguration(
            UUID configurationId, DetectionAnomalyResultQuery body, Integer skip, Integer maxpagesize) {
        return new PagedIterable<>(
                getAnomaliesByAnomalyDetectionConfigurationAsync(configurationId, body, skip, maxpagesize));
    }

    /**
     * Query anomalies under anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param body query detection anomaly result request.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<AnomalyResult> getAnomaliesByAnomalyDetectionConfiguration(
            UUID configurationId,
            DetectionAnomalyResultQuery body,
            Integer skip,
            Integer maxpagesize,
            Context context) {
        return new PagedIterable<>(
                getAnomaliesByAnomalyDetectionConfigurationAsync(configurationId, body, skip, maxpagesize, context));
    }

    /**
     * Query dimension values of anomalies.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param body query dimension values request.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<String>> getDimensionOfAnomaliesByAnomalyDetectionConfigurationSinglePageAsync(
            UUID configurationId, AnomalyDimensionQuery body, Integer skip, Integer maxpagesize) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.getDimensionOfAnomaliesByAnomalyDetectionConfiguration(
                                        this.getEndpoint(), configurationId, skip, maxpagesize, body, accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Query dimension values of anomalies.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param body query dimension values request.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<String>> getDimensionOfAnomaliesByAnomalyDetectionConfigurationSinglePageAsync(
            UUID configurationId, AnomalyDimensionQuery body, Integer skip, Integer maxpagesize, Context context) {
        final String accept = "application/json";
        return service.getDimensionOfAnomaliesByAnomalyDetectionConfiguration(
                        this.getEndpoint(), configurationId, skip, maxpagesize, body, accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Query dimension values of anomalies.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param body query dimension values request.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<String> getDimensionOfAnomaliesByAnomalyDetectionConfigurationAsync(
            UUID configurationId, AnomalyDimensionQuery body, Integer skip, Integer maxpagesize) {
        return new PagedFlux<>(
                () ->
                        getDimensionOfAnomaliesByAnomalyDetectionConfigurationSinglePageAsync(
                                configurationId, body, skip, maxpagesize),
                nextLink -> getDimensionOfAnomaliesByAnomalyDetectionConfigurationNextSinglePageAsync(nextLink, body));
    }

    /**
     * Query dimension values of anomalies.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param body query dimension values request.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<String> getDimensionOfAnomaliesByAnomalyDetectionConfigurationAsync(
            UUID configurationId, AnomalyDimensionQuery body, Integer skip, Integer maxpagesize, Context context) {
        return new PagedFlux<>(
                () ->
                        getDimensionOfAnomaliesByAnomalyDetectionConfigurationSinglePageAsync(
                                configurationId, body, skip, maxpagesize, context),
                nextLink ->
                        getDimensionOfAnomaliesByAnomalyDetectionConfigurationNextSinglePageAsync(
                                nextLink, body, context));
    }

    /**
     * Query dimension values of anomalies.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param body query dimension values request.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<String> getDimensionOfAnomaliesByAnomalyDetectionConfiguration(
            UUID configurationId, AnomalyDimensionQuery body, Integer skip, Integer maxpagesize) {
        return new PagedIterable<>(
                getDimensionOfAnomaliesByAnomalyDetectionConfigurationAsync(configurationId, body, skip, maxpagesize));
    }

    /**
     * Query dimension values of anomalies.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param body query dimension values request.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<String> getDimensionOfAnomaliesByAnomalyDetectionConfiguration(
            UUID configurationId, AnomalyDimensionQuery body, Integer skip, Integer maxpagesize, Context context) {
        return new PagedIterable<>(
                getDimensionOfAnomaliesByAnomalyDetectionConfigurationAsync(
                        configurationId, body, skip, maxpagesize, context));
    }

    /**
     * Query incidents under anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param body query detection incident result request.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<IncidentResult>> getIncidentsByAnomalyDetectionConfigurationSinglePageAsync(
            UUID configurationId, DetectionIncidentResultQuery body, Integer maxpagesize) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.getIncidentsByAnomalyDetectionConfiguration(
                                        this.getEndpoint(), configurationId, maxpagesize, body, accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Query incidents under anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param body query detection incident result request.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<IncidentResult>> getIncidentsByAnomalyDetectionConfigurationSinglePageAsync(
            UUID configurationId, DetectionIncidentResultQuery body, Integer maxpagesize, Context context) {
        final String accept = "application/json";
        return service.getIncidentsByAnomalyDetectionConfiguration(
                        this.getEndpoint(), configurationId, maxpagesize, body, accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Query incidents under anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param body query detection incident result request.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<IncidentResult> getIncidentsByAnomalyDetectionConfigurationAsync(
            UUID configurationId, DetectionIncidentResultQuery body, Integer maxpagesize) {
        return new PagedFlux<>(
                () -> getIncidentsByAnomalyDetectionConfigurationSinglePageAsync(configurationId, body, maxpagesize),
                nextLink -> getIncidentsByAnomalyDetectionConfigurationNextSinglePageAsync(nextLink));
    }

    /**
     * Query incidents under anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param body query detection incident result request.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<IncidentResult> getIncidentsByAnomalyDetectionConfigurationAsync(
            UUID configurationId, DetectionIncidentResultQuery body, Integer maxpagesize, Context context) {
        return new PagedFlux<>(
                () ->
                        getIncidentsByAnomalyDetectionConfigurationSinglePageAsync(
                                configurationId, body, maxpagesize, context),
                nextLink -> getIncidentsByAnomalyDetectionConfigurationNextSinglePageAsync(nextLink, context));
    }

    /**
     * Query incidents under anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param body query detection incident result request.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<IncidentResult> getIncidentsByAnomalyDetectionConfiguration(
            UUID configurationId, DetectionIncidentResultQuery body, Integer maxpagesize) {
        return new PagedIterable<>(
                getIncidentsByAnomalyDetectionConfigurationAsync(configurationId, body, maxpagesize));
    }

    /**
     * Query incidents under anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param body query detection incident result request.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<IncidentResult> getIncidentsByAnomalyDetectionConfiguration(
            UUID configurationId, DetectionIncidentResultQuery body, Integer maxpagesize, Context context) {
        return new PagedIterable<>(
                getIncidentsByAnomalyDetectionConfigurationAsync(configurationId, body, maxpagesize, context));
    }

    /**
     * Query incidents under anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param maxpagesize the maximum number of items in one page.
     * @param token the token for getting the next page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<IncidentResult>> getIncidentsByAnomalyDetectionConfigurationNextPagesSinglePageAsync(
            UUID configurationId, Integer maxpagesize, String token) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.getIncidentsByAnomalyDetectionConfigurationNextPages(
                                        this.getEndpoint(), configurationId, maxpagesize, token, accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Query incidents under anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param maxpagesize the maximum number of items in one page.
     * @param token the token for getting the next page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<IncidentResult>> getIncidentsByAnomalyDetectionConfigurationNextPagesSinglePageAsync(
            UUID configurationId, Integer maxpagesize, String token, Context context) {
        final String accept = "application/json";
        return service.getIncidentsByAnomalyDetectionConfigurationNextPages(
                        this.getEndpoint(), configurationId, maxpagesize, token, accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Query incidents under anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param maxpagesize the maximum number of items in one page.
     * @param token the token for getting the next page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<IncidentResult> getIncidentsByAnomalyDetectionConfigurationNextPagesAsync(
            UUID configurationId, Integer maxpagesize, String token) {
        return new PagedFlux<>(
                () ->
                        getIncidentsByAnomalyDetectionConfigurationNextPagesSinglePageAsync(
                                configurationId, maxpagesize, token),
                nextLink -> getIncidentsByAnomalyDetectionConfigurationNextPagesNextSinglePageAsync(nextLink));
    }

    /**
     * Query incidents under anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param maxpagesize the maximum number of items in one page.
     * @param token the token for getting the next page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<IncidentResult> getIncidentsByAnomalyDetectionConfigurationNextPagesAsync(
            UUID configurationId, Integer maxpagesize, String token, Context context) {
        return new PagedFlux<>(
                () ->
                        getIncidentsByAnomalyDetectionConfigurationNextPagesSinglePageAsync(
                                configurationId, maxpagesize, token, context),
                nextLink -> getIncidentsByAnomalyDetectionConfigurationNextPagesNextSinglePageAsync(nextLink, context));
    }

    /**
     * Query incidents under anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param maxpagesize the maximum number of items in one page.
     * @param token the token for getting the next page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<IncidentResult> getIncidentsByAnomalyDetectionConfigurationNextPages(
            UUID configurationId, Integer maxpagesize, String token) {
        return new PagedIterable<>(
                getIncidentsByAnomalyDetectionConfigurationNextPagesAsync(configurationId, maxpagesize, token));
    }

    /**
     * Query incidents under anomaly detection configuration.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param maxpagesize the maximum number of items in one page.
     * @param token the token for getting the next page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<IncidentResult> getIncidentsByAnomalyDetectionConfigurationNextPages(
            UUID configurationId, Integer maxpagesize, String token, Context context) {
        return new PagedIterable<>(
                getIncidentsByAnomalyDetectionConfigurationNextPagesAsync(
                        configurationId, maxpagesize, token, context));
    }

    /**
     * Query root cause for incident.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param incidentId incident id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RootCauseList>> getRootCauseOfIncidentByAnomalyDetectionConfigurationWithResponseAsync(
            UUID configurationId, String incidentId) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context ->
                        service.getRootCauseOfIncidentByAnomalyDetectionConfiguration(
                                this.getEndpoint(), configurationId, incidentId, accept, context));
    }

    /**
     * Query root cause for incident.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param incidentId incident id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RootCauseList>> getRootCauseOfIncidentByAnomalyDetectionConfigurationWithResponseAsync(
            UUID configurationId, String incidentId, Context context) {
        final String accept = "application/json";
        return service.getRootCauseOfIncidentByAnomalyDetectionConfiguration(
                this.getEndpoint(), configurationId, incidentId, accept, context);
    }

    /**
     * Query root cause for incident.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param incidentId incident id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RootCauseList> getRootCauseOfIncidentByAnomalyDetectionConfigurationAsync(
            UUID configurationId, String incidentId) {
        return getRootCauseOfIncidentByAnomalyDetectionConfigurationWithResponseAsync(configurationId, incidentId)
                .flatMap(
                        (Response<RootCauseList> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Query root cause for incident.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param incidentId incident id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RootCauseList> getRootCauseOfIncidentByAnomalyDetectionConfigurationAsync(
            UUID configurationId, String incidentId, Context context) {
        return getRootCauseOfIncidentByAnomalyDetectionConfigurationWithResponseAsync(
                        configurationId, incidentId, context)
                .flatMap(
                        (Response<RootCauseList> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Query root cause for incident.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param incidentId incident id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RootCauseList getRootCauseOfIncidentByAnomalyDetectionConfiguration(
            UUID configurationId, String incidentId) {
        return getRootCauseOfIncidentByAnomalyDetectionConfigurationAsync(configurationId, incidentId).block();
    }

    /**
     * Query root cause for incident.
     *
     * @param configurationId anomaly detection configuration unique id.
     * @param incidentId incident id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RootCauseList> getRootCauseOfIncidentByAnomalyDetectionConfigurationWithResponse(
            UUID configurationId, String incidentId, Context context) {
        return getRootCauseOfIncidentByAnomalyDetectionConfigurationWithResponseAsync(
                        configurationId, incidentId, context)
                .block();
    }

    /**
     * Create a new data source credential.
     *
     * @param body Create data source credential request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CreateCredentialResponse> createCredentialWithResponseAsync(DataSourceCredential body) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.createCredential(this.getEndpoint(), body, accept, context));
    }

    /**
     * Create a new data source credential.
     *
     * @param body Create data source credential request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CreateCredentialResponse> createCredentialWithResponseAsync(
            DataSourceCredential body, Context context) {
        final String accept = "application/json";
        return service.createCredential(this.getEndpoint(), body, accept, context);
    }

    /**
     * Create a new data source credential.
     *
     * @param body Create data source credential request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> createCredentialAsync(DataSourceCredential body) {
        return createCredentialWithResponseAsync(body).flatMap((CreateCredentialResponse res) -> Mono.empty());
    }

    /**
     * Create a new data source credential.
     *
     * @param body Create data source credential request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> createCredentialAsync(DataSourceCredential body, Context context) {
        return createCredentialWithResponseAsync(body, context).flatMap((CreateCredentialResponse res) -> Mono.empty());
    }

    /**
     * Create a new data source credential.
     *
     * @param body Create data source credential request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void createCredential(DataSourceCredential body) {
        createCredentialAsync(body).block();
    }

    /**
     * Create a new data source credential.
     *
     * @param body Create data source credential request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> createCredentialWithResponse(DataSourceCredential body, Context context) {
        return createCredentialWithResponseAsync(body, context).block();
    }

    /**
     * List all credentials.
     *
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DataSourceCredential>> listCredentialsSinglePageAsync(Integer skip, Integer maxpagesize) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context -> service.listCredentials(this.getEndpoint(), skip, maxpagesize, accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * List all credentials.
     *
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DataSourceCredential>> listCredentialsSinglePageAsync(
            Integer skip, Integer maxpagesize, Context context) {
        final String accept = "application/json";
        return service.listCredentials(this.getEndpoint(), skip, maxpagesize, accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * List all credentials.
     *
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DataSourceCredential> listCredentialsAsync(Integer skip, Integer maxpagesize) {
        return new PagedFlux<>(
                () -> listCredentialsSinglePageAsync(skip, maxpagesize),
                nextLink -> listCredentialsNextSinglePageAsync(nextLink));
    }

    /**
     * List all credentials.
     *
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DataSourceCredential> listCredentialsAsync(Integer skip, Integer maxpagesize, Context context) {
        return new PagedFlux<>(
                () -> listCredentialsSinglePageAsync(skip, maxpagesize, context),
                nextLink -> listCredentialsNextSinglePageAsync(nextLink, context));
    }

    /**
     * List all credentials.
     *
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DataSourceCredential> listCredentials(Integer skip, Integer maxpagesize) {
        return new PagedIterable<>(listCredentialsAsync(skip, maxpagesize));
    }

    /**
     * List all credentials.
     *
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DataSourceCredential> listCredentials(Integer skip, Integer maxpagesize, Context context) {
        return new PagedIterable<>(listCredentialsAsync(skip, maxpagesize, context));
    }

    /**
     * Update a data source credential.
     *
     * @param credentialId Data source credential unique ID.
     * @param body Update data source credential request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DataSourceCredential>> updateCredentialWithResponseAsync(
            UUID credentialId, DataSourceCredentialPatch body) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context -> service.updateCredential(this.getEndpoint(), credentialId, body, accept, context));
    }

    /**
     * Update a data source credential.
     *
     * @param credentialId Data source credential unique ID.
     * @param body Update data source credential request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DataSourceCredential>> updateCredentialWithResponseAsync(
            UUID credentialId, DataSourceCredentialPatch body, Context context) {
        final String accept = "application/json";
        return service.updateCredential(this.getEndpoint(), credentialId, body, accept, context);
    }

    /**
     * Update a data source credential.
     *
     * @param credentialId Data source credential unique ID.
     * @param body Update data source credential request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DataSourceCredential> updateCredentialAsync(UUID credentialId, DataSourceCredentialPatch body) {
        return updateCredentialWithResponseAsync(credentialId, body)
                .flatMap(
                        (Response<DataSourceCredential> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Update a data source credential.
     *
     * @param credentialId Data source credential unique ID.
     * @param body Update data source credential request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DataSourceCredential> updateCredentialAsync(
            UUID credentialId, DataSourceCredentialPatch body, Context context) {
        return updateCredentialWithResponseAsync(credentialId, body, context)
                .flatMap(
                        (Response<DataSourceCredential> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Update a data source credential.
     *
     * @param credentialId Data source credential unique ID.
     * @param body Update data source credential request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DataSourceCredential updateCredential(UUID credentialId, DataSourceCredentialPatch body) {
        return updateCredentialAsync(credentialId, body).block();
    }

    /**
     * Update a data source credential.
     *
     * @param credentialId Data source credential unique ID.
     * @param body Update data source credential request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DataSourceCredential> updateCredentialWithResponse(
            UUID credentialId, DataSourceCredentialPatch body, Context context) {
        return updateCredentialWithResponseAsync(credentialId, body, context).block();
    }

    /**
     * Delete a data source credential.
     *
     * @param credentialId Data source credential unique ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteCredentialWithResponseAsync(UUID credentialId) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context -> service.deleteCredential(this.getEndpoint(), credentialId, accept, context));
    }

    /**
     * Delete a data source credential.
     *
     * @param credentialId Data source credential unique ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteCredentialWithResponseAsync(UUID credentialId, Context context) {
        final String accept = "application/json";
        return service.deleteCredential(this.getEndpoint(), credentialId, accept, context);
    }

    /**
     * Delete a data source credential.
     *
     * @param credentialId Data source credential unique ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteCredentialAsync(UUID credentialId) {
        return deleteCredentialWithResponseAsync(credentialId).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete a data source credential.
     *
     * @param credentialId Data source credential unique ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteCredentialAsync(UUID credentialId, Context context) {
        return deleteCredentialWithResponseAsync(credentialId, context).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete a data source credential.
     *
     * @param credentialId Data source credential unique ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteCredential(UUID credentialId) {
        deleteCredentialAsync(credentialId).block();
    }

    /**
     * Delete a data source credential.
     *
     * @param credentialId Data source credential unique ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteCredentialWithResponse(UUID credentialId, Context context) {
        return deleteCredentialWithResponseAsync(credentialId, context).block();
    }

    /**
     * Get a data source credential.
     *
     * @param credentialId Data source credential unique ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a data source credential.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DataSourceCredential>> getCredentialWithResponseAsync(UUID credentialId) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context -> service.getCredential(this.getEndpoint(), credentialId, accept, context));
    }

    /**
     * Get a data source credential.
     *
     * @param credentialId Data source credential unique ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a data source credential.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DataSourceCredential>> getCredentialWithResponseAsync(UUID credentialId, Context context) {
        final String accept = "application/json";
        return service.getCredential(this.getEndpoint(), credentialId, accept, context);
    }

    /**
     * Get a data source credential.
     *
     * @param credentialId Data source credential unique ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a data source credential.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DataSourceCredential> getCredentialAsync(UUID credentialId) {
        return getCredentialWithResponseAsync(credentialId)
                .flatMap(
                        (Response<DataSourceCredential> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Get a data source credential.
     *
     * @param credentialId Data source credential unique ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a data source credential.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DataSourceCredential> getCredentialAsync(UUID credentialId, Context context) {
        return getCredentialWithResponseAsync(credentialId, context)
                .flatMap(
                        (Response<DataSourceCredential> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Get a data source credential.
     *
     * @param credentialId Data source credential unique ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a data source credential.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DataSourceCredential getCredential(UUID credentialId) {
        return getCredentialAsync(credentialId).block();
    }

    /**
     * Get a data source credential.
     *
     * @param credentialId Data source credential unique ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a data source credential.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DataSourceCredential> getCredentialWithResponse(UUID credentialId, Context context) {
        return getCredentialWithResponseAsync(credentialId, context).block();
    }

    /**
     * List all data feeds.
     *
     * @param dataFeedName filter data feed by its name.
     * @param dataSourceType filter data feed by its source type.
     * @param granularityName filter data feed by its granularity.
     * @param status filter data feed by its status.
     * @param creator filter data feed by its creator.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DataFeedDetail>> listDataFeedsSinglePageAsync(
            String dataFeedName,
            DataSourceType dataSourceType,
            Granularity granularityName,
            EntityStatus status,
            String creator,
            Integer skip,
            Integer maxpagesize) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.listDataFeeds(
                                        this.getEndpoint(),
                                        dataFeedName,
                                        dataSourceType,
                                        granularityName,
                                        status,
                                        creator,
                                        skip,
                                        maxpagesize,
                                        accept,
                                        context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * List all data feeds.
     *
     * @param dataFeedName filter data feed by its name.
     * @param dataSourceType filter data feed by its source type.
     * @param granularityName filter data feed by its granularity.
     * @param status filter data feed by its status.
     * @param creator filter data feed by its creator.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DataFeedDetail>> listDataFeedsSinglePageAsync(
            String dataFeedName,
            DataSourceType dataSourceType,
            Granularity granularityName,
            EntityStatus status,
            String creator,
            Integer skip,
            Integer maxpagesize,
            Context context) {
        final String accept = "application/json";
        return service.listDataFeeds(
                        this.getEndpoint(),
                        dataFeedName,
                        dataSourceType,
                        granularityName,
                        status,
                        creator,
                        skip,
                        maxpagesize,
                        accept,
                        context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * List all data feeds.
     *
     * @param dataFeedName filter data feed by its name.
     * @param dataSourceType filter data feed by its source type.
     * @param granularityName filter data feed by its granularity.
     * @param status filter data feed by its status.
     * @param creator filter data feed by its creator.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DataFeedDetail> listDataFeedsAsync(
            String dataFeedName,
            DataSourceType dataSourceType,
            Granularity granularityName,
            EntityStatus status,
            String creator,
            Integer skip,
            Integer maxpagesize) {
        return new PagedFlux<>(
                () ->
                        listDataFeedsSinglePageAsync(
                                dataFeedName, dataSourceType, granularityName, status, creator, skip, maxpagesize),
                nextLink -> listDataFeedsNextSinglePageAsync(nextLink));
    }

    /**
     * List all data feeds.
     *
     * @param dataFeedName filter data feed by its name.
     * @param dataSourceType filter data feed by its source type.
     * @param granularityName filter data feed by its granularity.
     * @param status filter data feed by its status.
     * @param creator filter data feed by its creator.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DataFeedDetail> listDataFeedsAsync(
            String dataFeedName,
            DataSourceType dataSourceType,
            Granularity granularityName,
            EntityStatus status,
            String creator,
            Integer skip,
            Integer maxpagesize,
            Context context) {
        return new PagedFlux<>(
                () ->
                        listDataFeedsSinglePageAsync(
                                dataFeedName,
                                dataSourceType,
                                granularityName,
                                status,
                                creator,
                                skip,
                                maxpagesize,
                                context),
                nextLink -> listDataFeedsNextSinglePageAsync(nextLink, context));
    }

    /**
     * List all data feeds.
     *
     * @param dataFeedName filter data feed by its name.
     * @param dataSourceType filter data feed by its source type.
     * @param granularityName filter data feed by its granularity.
     * @param status filter data feed by its status.
     * @param creator filter data feed by its creator.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DataFeedDetail> listDataFeeds(
            String dataFeedName,
            DataSourceType dataSourceType,
            Granularity granularityName,
            EntityStatus status,
            String creator,
            Integer skip,
            Integer maxpagesize) {
        return new PagedIterable<>(
                listDataFeedsAsync(dataFeedName, dataSourceType, granularityName, status, creator, skip, maxpagesize));
    }

    /**
     * List all data feeds.
     *
     * @param dataFeedName filter data feed by its name.
     * @param dataSourceType filter data feed by its source type.
     * @param granularityName filter data feed by its granularity.
     * @param status filter data feed by its status.
     * @param creator filter data feed by its creator.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DataFeedDetail> listDataFeeds(
            String dataFeedName,
            DataSourceType dataSourceType,
            Granularity granularityName,
            EntityStatus status,
            String creator,
            Integer skip,
            Integer maxpagesize,
            Context context) {
        return new PagedIterable<>(
                listDataFeedsAsync(
                        dataFeedName, dataSourceType, granularityName, status, creator, skip, maxpagesize, context));
    }

    /**
     * Create a new data feed.
     *
     * @param body parameters to create a data feed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CreateDataFeedResponse> createDataFeedWithResponseAsync(DataFeedDetail body) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.createDataFeed(this.getEndpoint(), body, accept, context));
    }

    /**
     * Create a new data feed.
     *
     * @param body parameters to create a data feed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CreateDataFeedResponse> createDataFeedWithResponseAsync(DataFeedDetail body, Context context) {
        final String accept = "application/json";
        return service.createDataFeed(this.getEndpoint(), body, accept, context);
    }

    /**
     * Create a new data feed.
     *
     * @param body parameters to create a data feed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> createDataFeedAsync(DataFeedDetail body) {
        return createDataFeedWithResponseAsync(body).flatMap((CreateDataFeedResponse res) -> Mono.empty());
    }

    /**
     * Create a new data feed.
     *
     * @param body parameters to create a data feed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> createDataFeedAsync(DataFeedDetail body, Context context) {
        return createDataFeedWithResponseAsync(body, context).flatMap((CreateDataFeedResponse res) -> Mono.empty());
    }

    /**
     * Create a new data feed.
     *
     * @param body parameters to create a data feed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void createDataFeed(DataFeedDetail body) {
        createDataFeedAsync(body).block();
    }

    /**
     * Create a new data feed.
     *
     * @param body parameters to create a data feed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> createDataFeedWithResponse(DataFeedDetail body, Context context) {
        return createDataFeedWithResponseAsync(body, context).block();
    }

    /**
     * Get a data feed by its id.
     *
     * @param dataFeedId The data feed unique id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a data feed by its id.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DataFeedDetail>> getDataFeedByIdWithResponseAsync(UUID dataFeedId) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context -> service.getDataFeedById(this.getEndpoint(), dataFeedId, accept, context));
    }

    /**
     * Get a data feed by its id.
     *
     * @param dataFeedId The data feed unique id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a data feed by its id.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DataFeedDetail>> getDataFeedByIdWithResponseAsync(UUID dataFeedId, Context context) {
        final String accept = "application/json";
        return service.getDataFeedById(this.getEndpoint(), dataFeedId, accept, context);
    }

    /**
     * Get a data feed by its id.
     *
     * @param dataFeedId The data feed unique id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a data feed by its id.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DataFeedDetail> getDataFeedByIdAsync(UUID dataFeedId) {
        return getDataFeedByIdWithResponseAsync(dataFeedId)
                .flatMap(
                        (Response<DataFeedDetail> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Get a data feed by its id.
     *
     * @param dataFeedId The data feed unique id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a data feed by its id.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DataFeedDetail> getDataFeedByIdAsync(UUID dataFeedId, Context context) {
        return getDataFeedByIdWithResponseAsync(dataFeedId, context)
                .flatMap(
                        (Response<DataFeedDetail> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Get a data feed by its id.
     *
     * @param dataFeedId The data feed unique id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a data feed by its id.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DataFeedDetail getDataFeedById(UUID dataFeedId) {
        return getDataFeedByIdAsync(dataFeedId).block();
    }

    /**
     * Get a data feed by its id.
     *
     * @param dataFeedId The data feed unique id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a data feed by its id.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DataFeedDetail> getDataFeedByIdWithResponse(UUID dataFeedId, Context context) {
        return getDataFeedByIdWithResponseAsync(dataFeedId, context).block();
    }

    /**
     * Update a data feed.
     *
     * @param dataFeedId The data feed unique id.
     * @param body parameters to update a data feed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DataFeedDetail>> updateDataFeedWithResponseAsync(UUID dataFeedId, DataFeedDetailPatch body) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context -> service.updateDataFeed(this.getEndpoint(), dataFeedId, body, accept, context));
    }

    /**
     * Update a data feed.
     *
     * @param dataFeedId The data feed unique id.
     * @param body parameters to update a data feed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DataFeedDetail>> updateDataFeedWithResponseAsync(
            UUID dataFeedId, DataFeedDetailPatch body, Context context) {
        final String accept = "application/json";
        return service.updateDataFeed(this.getEndpoint(), dataFeedId, body, accept, context);
    }

    /**
     * Update a data feed.
     *
     * @param dataFeedId The data feed unique id.
     * @param body parameters to update a data feed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DataFeedDetail> updateDataFeedAsync(UUID dataFeedId, DataFeedDetailPatch body) {
        return updateDataFeedWithResponseAsync(dataFeedId, body)
                .flatMap(
                        (Response<DataFeedDetail> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Update a data feed.
     *
     * @param dataFeedId The data feed unique id.
     * @param body parameters to update a data feed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DataFeedDetail> updateDataFeedAsync(UUID dataFeedId, DataFeedDetailPatch body, Context context) {
        return updateDataFeedWithResponseAsync(dataFeedId, body, context)
                .flatMap(
                        (Response<DataFeedDetail> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Update a data feed.
     *
     * @param dataFeedId The data feed unique id.
     * @param body parameters to update a data feed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DataFeedDetail updateDataFeed(UUID dataFeedId, DataFeedDetailPatch body) {
        return updateDataFeedAsync(dataFeedId, body).block();
    }

    /**
     * Update a data feed.
     *
     * @param dataFeedId The data feed unique id.
     * @param body parameters to update a data feed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DataFeedDetail> updateDataFeedWithResponse(
            UUID dataFeedId, DataFeedDetailPatch body, Context context) {
        return updateDataFeedWithResponseAsync(dataFeedId, body, context).block();
    }

    /**
     * Delete a data feed.
     *
     * @param dataFeedId The data feed unique id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDataFeedWithResponseAsync(UUID dataFeedId) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.deleteDataFeed(this.getEndpoint(), dataFeedId, accept, context));
    }

    /**
     * Delete a data feed.
     *
     * @param dataFeedId The data feed unique id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDataFeedWithResponseAsync(UUID dataFeedId, Context context) {
        final String accept = "application/json";
        return service.deleteDataFeed(this.getEndpoint(), dataFeedId, accept, context);
    }

    /**
     * Delete a data feed.
     *
     * @param dataFeedId The data feed unique id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteDataFeedAsync(UUID dataFeedId) {
        return deleteDataFeedWithResponseAsync(dataFeedId).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete a data feed.
     *
     * @param dataFeedId The data feed unique id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteDataFeedAsync(UUID dataFeedId, Context context) {
        return deleteDataFeedWithResponseAsync(dataFeedId, context).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete a data feed.
     *
     * @param dataFeedId The data feed unique id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteDataFeed(UUID dataFeedId) {
        deleteDataFeedAsync(dataFeedId).block();
    }

    /**
     * Delete a data feed.
     *
     * @param dataFeedId The data feed unique id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteDataFeedWithResponse(UUID dataFeedId, Context context) {
        return deleteDataFeedWithResponseAsync(dataFeedId, context).block();
    }

    /**
     * Get a metric feedback by its id.
     *
     * @param feedbackId the unique feedback ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a metric feedback by its id.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MetricFeedback>> getMetricFeedbackWithResponseAsync(UUID feedbackId) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context -> service.getMetricFeedback(this.getEndpoint(), feedbackId, accept, context));
    }

    /**
     * Get a metric feedback by its id.
     *
     * @param feedbackId the unique feedback ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a metric feedback by its id.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MetricFeedback>> getMetricFeedbackWithResponseAsync(UUID feedbackId, Context context) {
        final String accept = "application/json";
        return service.getMetricFeedback(this.getEndpoint(), feedbackId, accept, context);
    }

    /**
     * Get a metric feedback by its id.
     *
     * @param feedbackId the unique feedback ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a metric feedback by its id.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MetricFeedback> getMetricFeedbackAsync(UUID feedbackId) {
        return getMetricFeedbackWithResponseAsync(feedbackId)
                .flatMap(
                        (Response<MetricFeedback> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Get a metric feedback by its id.
     *
     * @param feedbackId the unique feedback ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a metric feedback by its id.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MetricFeedback> getMetricFeedbackAsync(UUID feedbackId, Context context) {
        return getMetricFeedbackWithResponseAsync(feedbackId, context)
                .flatMap(
                        (Response<MetricFeedback> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Get a metric feedback by its id.
     *
     * @param feedbackId the unique feedback ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a metric feedback by its id.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MetricFeedback getMetricFeedback(UUID feedbackId) {
        return getMetricFeedbackAsync(feedbackId).block();
    }

    /**
     * Get a metric feedback by its id.
     *
     * @param feedbackId the unique feedback ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a metric feedback by its id.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MetricFeedback> getMetricFeedbackWithResponse(UUID feedbackId, Context context) {
        return getMetricFeedbackWithResponseAsync(feedbackId, context).block();
    }

    /**
     * List feedback on the given metric.
     *
     * @param body metric feedback filter.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<MetricFeedback>> listMetricFeedbacksSinglePageAsync(
            MetricFeedbackFilter body, Integer skip, Integer maxpagesize) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.listMetricFeedbacks(
                                        this.getEndpoint(), skip, maxpagesize, body, accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * List feedback on the given metric.
     *
     * @param body metric feedback filter.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<MetricFeedback>> listMetricFeedbacksSinglePageAsync(
            MetricFeedbackFilter body, Integer skip, Integer maxpagesize, Context context) {
        final String accept = "application/json";
        return service.listMetricFeedbacks(this.getEndpoint(), skip, maxpagesize, body, accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * List feedback on the given metric.
     *
     * @param body metric feedback filter.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MetricFeedback> listMetricFeedbacksAsync(
            MetricFeedbackFilter body, Integer skip, Integer maxpagesize) {
        return new PagedFlux<>(
                () -> listMetricFeedbacksSinglePageAsync(body, skip, maxpagesize),
                nextLink -> listMetricFeedbacksNextSinglePageAsync(nextLink, body));
    }

    /**
     * List feedback on the given metric.
     *
     * @param body metric feedback filter.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MetricFeedback> listMetricFeedbacksAsync(
            MetricFeedbackFilter body, Integer skip, Integer maxpagesize, Context context) {
        return new PagedFlux<>(
                () -> listMetricFeedbacksSinglePageAsync(body, skip, maxpagesize, context),
                nextLink -> listMetricFeedbacksNextSinglePageAsync(nextLink, body, context));
    }

    /**
     * List feedback on the given metric.
     *
     * @param body metric feedback filter.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MetricFeedback> listMetricFeedbacks(
            MetricFeedbackFilter body, Integer skip, Integer maxpagesize) {
        return new PagedIterable<>(listMetricFeedbacksAsync(body, skip, maxpagesize));
    }

    /**
     * List feedback on the given metric.
     *
     * @param body metric feedback filter.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MetricFeedback> listMetricFeedbacks(
            MetricFeedbackFilter body, Integer skip, Integer maxpagesize, Context context) {
        return new PagedIterable<>(listMetricFeedbacksAsync(body, skip, maxpagesize, context));
    }

    /**
     * Create a new metric feedback.
     *
     * @param body metric feedback.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CreateMetricFeedbackResponse> createMetricFeedbackWithResponseAsync(MetricFeedback body) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.createMetricFeedback(this.getEndpoint(), body, accept, context));
    }

    /**
     * Create a new metric feedback.
     *
     * @param body metric feedback.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CreateMetricFeedbackResponse> createMetricFeedbackWithResponseAsync(
            MetricFeedback body, Context context) {
        final String accept = "application/json";
        return service.createMetricFeedback(this.getEndpoint(), body, accept, context);
    }

    /**
     * Create a new metric feedback.
     *
     * @param body metric feedback.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> createMetricFeedbackAsync(MetricFeedback body) {
        return createMetricFeedbackWithResponseAsync(body).flatMap((CreateMetricFeedbackResponse res) -> Mono.empty());
    }

    /**
     * Create a new metric feedback.
     *
     * @param body metric feedback.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> createMetricFeedbackAsync(MetricFeedback body, Context context) {
        return createMetricFeedbackWithResponseAsync(body, context)
                .flatMap((CreateMetricFeedbackResponse res) -> Mono.empty());
    }

    /**
     * Create a new metric feedback.
     *
     * @param body metric feedback.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void createMetricFeedback(MetricFeedback body) {
        createMetricFeedbackAsync(body).block();
    }

    /**
     * Create a new metric feedback.
     *
     * @param body metric feedback.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> createMetricFeedbackWithResponse(MetricFeedback body, Context context) {
        return createMetricFeedbackWithResponseAsync(body, context).block();
    }

    /**
     * List all hooks.
     *
     * @param hookName filter hook by its name.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<HookInfo>> listHooksSinglePageAsync(String hookName, Integer skip, Integer maxpagesize) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context -> service.listHooks(this.getEndpoint(), hookName, skip, maxpagesize, accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * List all hooks.
     *
     * @param hookName filter hook by its name.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<HookInfo>> listHooksSinglePageAsync(
            String hookName, Integer skip, Integer maxpagesize, Context context) {
        final String accept = "application/json";
        return service.listHooks(this.getEndpoint(), hookName, skip, maxpagesize, accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * List all hooks.
     *
     * @param hookName filter hook by its name.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<HookInfo> listHooksAsync(String hookName, Integer skip, Integer maxpagesize) {
        return new PagedFlux<>(
                () -> listHooksSinglePageAsync(hookName, skip, maxpagesize),
                nextLink -> listHooksNextSinglePageAsync(nextLink));
    }

    /**
     * List all hooks.
     *
     * @param hookName filter hook by its name.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<HookInfo> listHooksAsync(String hookName, Integer skip, Integer maxpagesize, Context context) {
        return new PagedFlux<>(
                () -> listHooksSinglePageAsync(hookName, skip, maxpagesize, context),
                nextLink -> listHooksNextSinglePageAsync(nextLink, context));
    }

    /**
     * List all hooks.
     *
     * @param hookName filter hook by its name.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<HookInfo> listHooks(String hookName, Integer skip, Integer maxpagesize) {
        return new PagedIterable<>(listHooksAsync(hookName, skip, maxpagesize));
    }

    /**
     * List all hooks.
     *
     * @param hookName filter hook by its name.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<HookInfo> listHooks(String hookName, Integer skip, Integer maxpagesize, Context context) {
        return new PagedIterable<>(listHooksAsync(hookName, skip, maxpagesize, context));
    }

    /**
     * Create a new hook.
     *
     * @param body Create hook request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CreateHookResponse> createHookWithResponseAsync(HookInfo body) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.createHook(this.getEndpoint(), body, accept, context));
    }

    /**
     * Create a new hook.
     *
     * @param body Create hook request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<CreateHookResponse> createHookWithResponseAsync(HookInfo body, Context context) {
        final String accept = "application/json";
        return service.createHook(this.getEndpoint(), body, accept, context);
    }

    /**
     * Create a new hook.
     *
     * @param body Create hook request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> createHookAsync(HookInfo body) {
        return createHookWithResponseAsync(body).flatMap((CreateHookResponse res) -> Mono.empty());
    }

    /**
     * Create a new hook.
     *
     * @param body Create hook request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> createHookAsync(HookInfo body, Context context) {
        return createHookWithResponseAsync(body, context).flatMap((CreateHookResponse res) -> Mono.empty());
    }

    /**
     * Create a new hook.
     *
     * @param body Create hook request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void createHook(HookInfo body) {
        createHookAsync(body).block();
    }

    /**
     * Create a new hook.
     *
     * @param body Create hook request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> createHookWithResponse(HookInfo body, Context context) {
        return createHookWithResponseAsync(body, context).block();
    }

    /**
     * Get a hook by its id.
     *
     * @param hookId Hook unique ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a hook by its id.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<HookInfo>> getHookWithResponseAsync(UUID hookId) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.getHook(this.getEndpoint(), hookId, accept, context));
    }

    /**
     * Get a hook by its id.
     *
     * @param hookId Hook unique ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a hook by its id.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<HookInfo>> getHookWithResponseAsync(UUID hookId, Context context) {
        final String accept = "application/json";
        return service.getHook(this.getEndpoint(), hookId, accept, context);
    }

    /**
     * Get a hook by its id.
     *
     * @param hookId Hook unique ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a hook by its id.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<HookInfo> getHookAsync(UUID hookId) {
        return getHookWithResponseAsync(hookId)
                .flatMap(
                        (Response<HookInfo> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Get a hook by its id.
     *
     * @param hookId Hook unique ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a hook by its id.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<HookInfo> getHookAsync(UUID hookId, Context context) {
        return getHookWithResponseAsync(hookId, context)
                .flatMap(
                        (Response<HookInfo> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Get a hook by its id.
     *
     * @param hookId Hook unique ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a hook by its id.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public HookInfo getHook(UUID hookId) {
        return getHookAsync(hookId).block();
    }

    /**
     * Get a hook by its id.
     *
     * @param hookId Hook unique ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a hook by its id.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<HookInfo> getHookWithResponse(UUID hookId, Context context) {
        return getHookWithResponseAsync(hookId, context).block();
    }

    /**
     * Update a hook.
     *
     * @param hookId Hook unique ID.
     * @param body Update hook request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<HookInfo>> updateHookWithResponseAsync(UUID hookId, HookInfoPatch body) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.updateHook(this.getEndpoint(), hookId, body, accept, context));
    }

    /**
     * Update a hook.
     *
     * @param hookId Hook unique ID.
     * @param body Update hook request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<HookInfo>> updateHookWithResponseAsync(UUID hookId, HookInfoPatch body, Context context) {
        final String accept = "application/json";
        return service.updateHook(this.getEndpoint(), hookId, body, accept, context);
    }

    /**
     * Update a hook.
     *
     * @param hookId Hook unique ID.
     * @param body Update hook request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<HookInfo> updateHookAsync(UUID hookId, HookInfoPatch body) {
        return updateHookWithResponseAsync(hookId, body)
                .flatMap(
                        (Response<HookInfo> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Update a hook.
     *
     * @param hookId Hook unique ID.
     * @param body Update hook request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<HookInfo> updateHookAsync(UUID hookId, HookInfoPatch body, Context context) {
        return updateHookWithResponseAsync(hookId, body, context)
                .flatMap(
                        (Response<HookInfo> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Update a hook.
     *
     * @param hookId Hook unique ID.
     * @param body Update hook request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public HookInfo updateHook(UUID hookId, HookInfoPatch body) {
        return updateHookAsync(hookId, body).block();
    }

    /**
     * Update a hook.
     *
     * @param hookId Hook unique ID.
     * @param body Update hook request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<HookInfo> updateHookWithResponse(UUID hookId, HookInfoPatch body, Context context) {
        return updateHookWithResponseAsync(hookId, body, context).block();
    }

    /**
     * Delete a hook.
     *
     * @param hookId Hook unique ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteHookWithResponseAsync(UUID hookId) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.deleteHook(this.getEndpoint(), hookId, accept, context));
    }

    /**
     * Delete a hook.
     *
     * @param hookId Hook unique ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteHookWithResponseAsync(UUID hookId, Context context) {
        final String accept = "application/json";
        return service.deleteHook(this.getEndpoint(), hookId, accept, context);
    }

    /**
     * Delete a hook.
     *
     * @param hookId Hook unique ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteHookAsync(UUID hookId) {
        return deleteHookWithResponseAsync(hookId).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete a hook.
     *
     * @param hookId Hook unique ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteHookAsync(UUID hookId, Context context) {
        return deleteHookWithResponseAsync(hookId, context).flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Delete a hook.
     *
     * @param hookId Hook unique ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteHook(UUID hookId) {
        deleteHookAsync(hookId).block();
    }

    /**
     * Delete a hook.
     *
     * @param hookId Hook unique ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteHookWithResponse(UUID hookId, Context context) {
        return deleteHookWithResponseAsync(hookId, context).block();
    }

    /**
     * Get data ingestion status by data feed.
     *
     * @param dataFeedId The data feed unique id.
     * @param body The query time range.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data ingestion status by data feed.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DataFeedIngestionStatus>> getDataFeedIngestionStatusSinglePageAsync(
            UUID dataFeedId, IngestionStatusQueryOptions body, Integer skip, Integer maxpagesize) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.getDataFeedIngestionStatus(
                                        this.getEndpoint(), dataFeedId, skip, maxpagesize, body, accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get data ingestion status by data feed.
     *
     * @param dataFeedId The data feed unique id.
     * @param body The query time range.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data ingestion status by data feed.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DataFeedIngestionStatus>> getDataFeedIngestionStatusSinglePageAsync(
            UUID dataFeedId, IngestionStatusQueryOptions body, Integer skip, Integer maxpagesize, Context context) {
        final String accept = "application/json";
        return service.getDataFeedIngestionStatus(
                        this.getEndpoint(), dataFeedId, skip, maxpagesize, body, accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get data ingestion status by data feed.
     *
     * @param dataFeedId The data feed unique id.
     * @param body The query time range.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data ingestion status by data feed.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DataFeedIngestionStatus> getDataFeedIngestionStatusAsync(
            UUID dataFeedId, IngestionStatusQueryOptions body, Integer skip, Integer maxpagesize) {
        return new PagedFlux<>(
                () -> getDataFeedIngestionStatusSinglePageAsync(dataFeedId, body, skip, maxpagesize),
                nextLink -> getDataFeedIngestionStatusNextSinglePageAsync(nextLink, body));
    }

    /**
     * Get data ingestion status by data feed.
     *
     * @param dataFeedId The data feed unique id.
     * @param body The query time range.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data ingestion status by data feed.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<DataFeedIngestionStatus> getDataFeedIngestionStatusAsync(
            UUID dataFeedId, IngestionStatusQueryOptions body, Integer skip, Integer maxpagesize, Context context) {
        return new PagedFlux<>(
                () -> getDataFeedIngestionStatusSinglePageAsync(dataFeedId, body, skip, maxpagesize, context),
                nextLink -> getDataFeedIngestionStatusNextSinglePageAsync(nextLink, body, context));
    }

    /**
     * Get data ingestion status by data feed.
     *
     * @param dataFeedId The data feed unique id.
     * @param body The query time range.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data ingestion status by data feed.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DataFeedIngestionStatus> getDataFeedIngestionStatus(
            UUID dataFeedId, IngestionStatusQueryOptions body, Integer skip, Integer maxpagesize) {
        return new PagedIterable<>(getDataFeedIngestionStatusAsync(dataFeedId, body, skip, maxpagesize));
    }

    /**
     * Get data ingestion status by data feed.
     *
     * @param dataFeedId The data feed unique id.
     * @param body The query time range.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data ingestion status by data feed.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<DataFeedIngestionStatus> getDataFeedIngestionStatus(
            UUID dataFeedId, IngestionStatusQueryOptions body, Integer skip, Integer maxpagesize, Context context) {
        return new PagedIterable<>(getDataFeedIngestionStatusAsync(dataFeedId, body, skip, maxpagesize, context));
    }

    /**
     * Reset data ingestion status by data feed to backfill data.
     *
     * @param dataFeedId The data feed unique id.
     * @param body The backfill time range.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> resetDataFeedIngestionStatusWithResponseAsync(
            UUID dataFeedId, IngestionProgressResetOptions body) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context -> service.resetDataFeedIngestionStatus(this.getEndpoint(), dataFeedId, body, accept, context));
    }

    /**
     * Reset data ingestion status by data feed to backfill data.
     *
     * @param dataFeedId The data feed unique id.
     * @param body The backfill time range.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> resetDataFeedIngestionStatusWithResponseAsync(
            UUID dataFeedId, IngestionProgressResetOptions body, Context context) {
        final String accept = "application/json";
        return service.resetDataFeedIngestionStatus(this.getEndpoint(), dataFeedId, body, accept, context);
    }

    /**
     * Reset data ingestion status by data feed to backfill data.
     *
     * @param dataFeedId The data feed unique id.
     * @param body The backfill time range.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> resetDataFeedIngestionStatusAsync(UUID dataFeedId, IngestionProgressResetOptions body) {
        return resetDataFeedIngestionStatusWithResponseAsync(dataFeedId, body)
                .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Reset data ingestion status by data feed to backfill data.
     *
     * @param dataFeedId The data feed unique id.
     * @param body The backfill time range.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> resetDataFeedIngestionStatusAsync(
            UUID dataFeedId, IngestionProgressResetOptions body, Context context) {
        return resetDataFeedIngestionStatusWithResponseAsync(dataFeedId, body, context)
                .flatMap((Response<Void> res) -> Mono.empty());
    }

    /**
     * Reset data ingestion status by data feed to backfill data.
     *
     * @param dataFeedId The data feed unique id.
     * @param body The backfill time range.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void resetDataFeedIngestionStatus(UUID dataFeedId, IngestionProgressResetOptions body) {
        resetDataFeedIngestionStatusAsync(dataFeedId, body).block();
    }

    /**
     * Reset data ingestion status by data feed to backfill data.
     *
     * @param dataFeedId The data feed unique id.
     * @param body The backfill time range.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> resetDataFeedIngestionStatusWithResponse(
            UUID dataFeedId, IngestionProgressResetOptions body, Context context) {
        return resetDataFeedIngestionStatusWithResponseAsync(dataFeedId, body, context).block();
    }

    /**
     * Get data last success ingestion job timestamp by data feed.
     *
     * @param dataFeedId The data feed unique id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data last success ingestion job timestamp by data feed.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DataFeedIngestionProgress>> getIngestionProgressWithResponseAsync(UUID dataFeedId) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context -> service.getIngestionProgress(this.getEndpoint(), dataFeedId, accept, context));
    }

    /**
     * Get data last success ingestion job timestamp by data feed.
     *
     * @param dataFeedId The data feed unique id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data last success ingestion job timestamp by data feed.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<DataFeedIngestionProgress>> getIngestionProgressWithResponseAsync(
            UUID dataFeedId, Context context) {
        final String accept = "application/json";
        return service.getIngestionProgress(this.getEndpoint(), dataFeedId, accept, context);
    }

    /**
     * Get data last success ingestion job timestamp by data feed.
     *
     * @param dataFeedId The data feed unique id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data last success ingestion job timestamp by data feed.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DataFeedIngestionProgress> getIngestionProgressAsync(UUID dataFeedId) {
        return getIngestionProgressWithResponseAsync(dataFeedId)
                .flatMap(
                        (Response<DataFeedIngestionProgress> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Get data last success ingestion job timestamp by data feed.
     *
     * @param dataFeedId The data feed unique id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data last success ingestion job timestamp by data feed.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<DataFeedIngestionProgress> getIngestionProgressAsync(UUID dataFeedId, Context context) {
        return getIngestionProgressWithResponseAsync(dataFeedId, context)
                .flatMap(
                        (Response<DataFeedIngestionProgress> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Get data last success ingestion job timestamp by data feed.
     *
     * @param dataFeedId The data feed unique id.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data last success ingestion job timestamp by data feed.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public DataFeedIngestionProgress getIngestionProgress(UUID dataFeedId) {
        return getIngestionProgressAsync(dataFeedId).block();
    }

    /**
     * Get data last success ingestion job timestamp by data feed.
     *
     * @param dataFeedId The data feed unique id.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data last success ingestion job timestamp by data feed.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<DataFeedIngestionProgress> getIngestionProgressWithResponse(UUID dataFeedId, Context context) {
        return getIngestionProgressWithResponseAsync(dataFeedId, context).block();
    }

    /**
     * Get time series data from metric.
     *
     * @param metricId metric unique id.
     * @param body query time series data condition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return time series data from metric.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MetricDataList>> getMetricDataWithResponseAsync(UUID metricId, MetricDataQueryOptions body) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                context -> service.getMetricData(this.getEndpoint(), metricId, body, accept, context));
    }

    /**
     * Get time series data from metric.
     *
     * @param metricId metric unique id.
     * @param body query time series data condition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return time series data from metric.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<MetricDataList>> getMetricDataWithResponseAsync(
            UUID metricId, MetricDataQueryOptions body, Context context) {
        final String accept = "application/json";
        return service.getMetricData(this.getEndpoint(), metricId, body, accept, context);
    }

    /**
     * Get time series data from metric.
     *
     * @param metricId metric unique id.
     * @param body query time series data condition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return time series data from metric.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MetricDataList> getMetricDataAsync(UUID metricId, MetricDataQueryOptions body) {
        return getMetricDataWithResponseAsync(metricId, body)
                .flatMap(
                        (Response<MetricDataList> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Get time series data from metric.
     *
     * @param metricId metric unique id.
     * @param body query time series data condition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return time series data from metric.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<MetricDataList> getMetricDataAsync(UUID metricId, MetricDataQueryOptions body, Context context) {
        return getMetricDataWithResponseAsync(metricId, body, context)
                .flatMap(
                        (Response<MetricDataList> res) -> {
                            if (res.getValue() != null) {
                                return Mono.just(res.getValue());
                            } else {
                                return Mono.empty();
                            }
                        });
    }

    /**
     * Get time series data from metric.
     *
     * @param metricId metric unique id.
     * @param body query time series data condition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return time series data from metric.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public MetricDataList getMetricData(UUID metricId, MetricDataQueryOptions body) {
        return getMetricDataAsync(metricId, body).block();
    }

    /**
     * Get time series data from metric.
     *
     * @param metricId metric unique id.
     * @param body query time series data condition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return time series data from metric.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<MetricDataList> getMetricDataWithResponse(
            UUID metricId, MetricDataQueryOptions body, Context context) {
        return getMetricDataWithResponseAsync(metricId, body, context).block();
    }

    /**
     * List series (dimension combinations) from metric.
     *
     * @param metricId metric unique id.
     * @param body filter to query series.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<MetricSeriesItem>> getMetricSeriesSinglePageAsync(
            UUID metricId, MetricSeriesQueryOptions body, Integer skip, Integer maxpagesize) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.getMetricSeries(
                                        this.getEndpoint(), metricId, skip, maxpagesize, body, accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * List series (dimension combinations) from metric.
     *
     * @param metricId metric unique id.
     * @param body filter to query series.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<MetricSeriesItem>> getMetricSeriesSinglePageAsync(
            UUID metricId, MetricSeriesQueryOptions body, Integer skip, Integer maxpagesize, Context context) {
        final String accept = "application/json";
        return service.getMetricSeries(this.getEndpoint(), metricId, skip, maxpagesize, body, accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * List series (dimension combinations) from metric.
     *
     * @param metricId metric unique id.
     * @param body filter to query series.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MetricSeriesItem> getMetricSeriesAsync(
            UUID metricId, MetricSeriesQueryOptions body, Integer skip, Integer maxpagesize) {
        return new PagedFlux<>(
                () -> getMetricSeriesSinglePageAsync(metricId, body, skip, maxpagesize),
                nextLink -> getMetricSeriesNextSinglePageAsync(nextLink, body));
    }

    /**
     * List series (dimension combinations) from metric.
     *
     * @param metricId metric unique id.
     * @param body filter to query series.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<MetricSeriesItem> getMetricSeriesAsync(
            UUID metricId, MetricSeriesQueryOptions body, Integer skip, Integer maxpagesize, Context context) {
        return new PagedFlux<>(
                () -> getMetricSeriesSinglePageAsync(metricId, body, skip, maxpagesize, context),
                nextLink -> getMetricSeriesNextSinglePageAsync(nextLink, body, context));
    }

    /**
     * List series (dimension combinations) from metric.
     *
     * @param metricId metric unique id.
     * @param body filter to query series.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MetricSeriesItem> getMetricSeries(
            UUID metricId, MetricSeriesQueryOptions body, Integer skip, Integer maxpagesize) {
        return new PagedIterable<>(getMetricSeriesAsync(metricId, body, skip, maxpagesize));
    }

    /**
     * List series (dimension combinations) from metric.
     *
     * @param metricId metric unique id.
     * @param body filter to query series.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<MetricSeriesItem> getMetricSeries(
            UUID metricId, MetricSeriesQueryOptions body, Integer skip, Integer maxpagesize, Context context) {
        return new PagedIterable<>(getMetricSeriesAsync(metricId, body, skip, maxpagesize, context));
    }

    /**
     * List dimension from certain metric.
     *
     * @param metricId metric unique id.
     * @param body query dimension option.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<String>> getMetricDimensionSinglePageAsync(
            UUID metricId, MetricDimensionQueryOptions body, Integer skip, Integer maxpagesize) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.getMetricDimension(
                                        this.getEndpoint(), metricId, skip, maxpagesize, body, accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * List dimension from certain metric.
     *
     * @param metricId metric unique id.
     * @param body query dimension option.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<String>> getMetricDimensionSinglePageAsync(
            UUID metricId, MetricDimensionQueryOptions body, Integer skip, Integer maxpagesize, Context context) {
        final String accept = "application/json";
        return service.getMetricDimension(this.getEndpoint(), metricId, skip, maxpagesize, body, accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * List dimension from certain metric.
     *
     * @param metricId metric unique id.
     * @param body query dimension option.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<String> getMetricDimensionAsync(
            UUID metricId, MetricDimensionQueryOptions body, Integer skip, Integer maxpagesize) {
        return new PagedFlux<>(
                () -> getMetricDimensionSinglePageAsync(metricId, body, skip, maxpagesize),
                nextLink -> getMetricDimensionNextSinglePageAsync(nextLink, body));
    }

    /**
     * List dimension from certain metric.
     *
     * @param metricId metric unique id.
     * @param body query dimension option.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<String> getMetricDimensionAsync(
            UUID metricId, MetricDimensionQueryOptions body, Integer skip, Integer maxpagesize, Context context) {
        return new PagedFlux<>(
                () -> getMetricDimensionSinglePageAsync(metricId, body, skip, maxpagesize, context),
                nextLink -> getMetricDimensionNextSinglePageAsync(nextLink, body, context));
    }

    /**
     * List dimension from certain metric.
     *
     * @param metricId metric unique id.
     * @param body query dimension option.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<String> getMetricDimension(
            UUID metricId, MetricDimensionQueryOptions body, Integer skip, Integer maxpagesize) {
        return new PagedIterable<>(getMetricDimensionAsync(metricId, body, skip, maxpagesize));
    }

    /**
     * List dimension from certain metric.
     *
     * @param metricId metric unique id.
     * @param body query dimension option.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<String> getMetricDimension(
            UUID metricId, MetricDimensionQueryOptions body, Integer skip, Integer maxpagesize, Context context) {
        return new PagedIterable<>(getMetricDimensionAsync(metricId, body, skip, maxpagesize, context));
    }

    /**
     * List all anomaly detection configurations for specific metric.
     *
     * @param metricId metric unique id.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyDetectionConfiguration>> getAnomalyDetectionConfigurationsByMetricSinglePageAsync(
            UUID metricId, Integer skip, Integer maxpagesize) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.getAnomalyDetectionConfigurationsByMetric(
                                        this.getEndpoint(), metricId, skip, maxpagesize, accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * List all anomaly detection configurations for specific metric.
     *
     * @param metricId metric unique id.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyDetectionConfiguration>> getAnomalyDetectionConfigurationsByMetricSinglePageAsync(
            UUID metricId, Integer skip, Integer maxpagesize, Context context) {
        final String accept = "application/json";
        return service.getAnomalyDetectionConfigurationsByMetric(
                        this.getEndpoint(), metricId, skip, maxpagesize, accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * List all anomaly detection configurations for specific metric.
     *
     * @param metricId metric unique id.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<AnomalyDetectionConfiguration> getAnomalyDetectionConfigurationsByMetricAsync(
            UUID metricId, Integer skip, Integer maxpagesize) {
        return new PagedFlux<>(
                () -> getAnomalyDetectionConfigurationsByMetricSinglePageAsync(metricId, skip, maxpagesize),
                nextLink -> getAnomalyDetectionConfigurationsByMetricNextSinglePageAsync(nextLink));
    }

    /**
     * List all anomaly detection configurations for specific metric.
     *
     * @param metricId metric unique id.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<AnomalyDetectionConfiguration> getAnomalyDetectionConfigurationsByMetricAsync(
            UUID metricId, Integer skip, Integer maxpagesize, Context context) {
        return new PagedFlux<>(
                () -> getAnomalyDetectionConfigurationsByMetricSinglePageAsync(metricId, skip, maxpagesize, context),
                nextLink -> getAnomalyDetectionConfigurationsByMetricNextSinglePageAsync(nextLink, context));
    }

    /**
     * List all anomaly detection configurations for specific metric.
     *
     * @param metricId metric unique id.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<AnomalyDetectionConfiguration> getAnomalyDetectionConfigurationsByMetric(
            UUID metricId, Integer skip, Integer maxpagesize) {
        return new PagedIterable<>(getAnomalyDetectionConfigurationsByMetricAsync(metricId, skip, maxpagesize));
    }

    /**
     * List all anomaly detection configurations for specific metric.
     *
     * @param metricId metric unique id.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<AnomalyDetectionConfiguration> getAnomalyDetectionConfigurationsByMetric(
            UUID metricId, Integer skip, Integer maxpagesize, Context context) {
        return new PagedIterable<>(
                getAnomalyDetectionConfigurationsByMetricAsync(metricId, skip, maxpagesize, context));
    }

    /**
     * Query anomaly detection status.
     *
     * @param metricId metric unique id.
     * @param body query options.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<EnrichmentStatus>> getEnrichmentStatusByMetricSinglePageAsync(
            UUID metricId, EnrichmentStatusQueryOption body, Integer skip, Integer maxpagesize) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.getEnrichmentStatusByMetric(
                                        this.getEndpoint(), metricId, skip, maxpagesize, body, accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Query anomaly detection status.
     *
     * @param metricId metric unique id.
     * @param body query options.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<EnrichmentStatus>> getEnrichmentStatusByMetricSinglePageAsync(
            UUID metricId, EnrichmentStatusQueryOption body, Integer skip, Integer maxpagesize, Context context) {
        final String accept = "application/json";
        return service.getEnrichmentStatusByMetric(
                        this.getEndpoint(), metricId, skip, maxpagesize, body, accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Query anomaly detection status.
     *
     * @param metricId metric unique id.
     * @param body query options.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<EnrichmentStatus> getEnrichmentStatusByMetricAsync(
            UUID metricId, EnrichmentStatusQueryOption body, Integer skip, Integer maxpagesize) {
        return new PagedFlux<>(
                () -> getEnrichmentStatusByMetricSinglePageAsync(metricId, body, skip, maxpagesize),
                nextLink -> getEnrichmentStatusByMetricNextSinglePageAsync(nextLink, body));
    }

    /**
     * Query anomaly detection status.
     *
     * @param metricId metric unique id.
     * @param body query options.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<EnrichmentStatus> getEnrichmentStatusByMetricAsync(
            UUID metricId, EnrichmentStatusQueryOption body, Integer skip, Integer maxpagesize, Context context) {
        return new PagedFlux<>(
                () -> getEnrichmentStatusByMetricSinglePageAsync(metricId, body, skip, maxpagesize, context),
                nextLink -> getEnrichmentStatusByMetricNextSinglePageAsync(nextLink, body, context));
    }

    /**
     * Query anomaly detection status.
     *
     * @param metricId metric unique id.
     * @param body query options.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<EnrichmentStatus> getEnrichmentStatusByMetric(
            UUID metricId, EnrichmentStatusQueryOption body, Integer skip, Integer maxpagesize) {
        return new PagedIterable<>(getEnrichmentStatusByMetricAsync(metricId, body, skip, maxpagesize));
    }

    /**
     * Query anomaly detection status.
     *
     * @param metricId metric unique id.
     * @param body query options.
     * @param skip for paging, skipped number.
     * @param maxpagesize the maximum number of items in one page.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<EnrichmentStatus> getEnrichmentStatusByMetric(
            UUID metricId, EnrichmentStatusQueryOption body, Integer skip, Integer maxpagesize, Context context) {
        return new PagedIterable<>(getEnrichmentStatusByMetricAsync(metricId, body, skip, maxpagesize, context));
    }

    /**
     * Query alerts under anomaly alerting configuration.
     *
     * @param nextLink the next link.
     * @param body query alerting result request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyAlert>> getAlertsByAnomalyAlertingConfigurationNextSinglePageAsync(
            String nextLink, AlertingResultQuery body) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.getAlertsByAnomalyAlertingConfigurationNext(
                                        this.getEndpoint(), nextLink, body, accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Query alerts under anomaly alerting configuration.
     *
     * @param nextLink the next link.
     * @param body query alerting result request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyAlert>> getAlertsByAnomalyAlertingConfigurationNextSinglePageAsync(
            String nextLink, AlertingResultQuery body, Context context) {
        final String accept = "application/json";
        return service.getAlertsByAnomalyAlertingConfigurationNext(this.getEndpoint(), nextLink, body, accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Query anomalies under anomaly detection configuration.
     *
     * @param nextLink the next link.
     * @param body query detection anomaly result request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyResult>> getAnomaliesByAnomalyDetectionConfigurationNextSinglePageAsync(
            String nextLink, DetectionAnomalyResultQuery body) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.getAnomaliesByAnomalyDetectionConfigurationNext(
                                        this.getEndpoint(), nextLink, body, accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Query anomalies under anomaly detection configuration.
     *
     * @param nextLink the next link.
     * @param body query detection anomaly result request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyResult>> getAnomaliesByAnomalyDetectionConfigurationNextSinglePageAsync(
            String nextLink, DetectionAnomalyResultQuery body, Context context) {
        final String accept = "application/json";
        return service.getAnomaliesByAnomalyDetectionConfigurationNext(
                        this.getEndpoint(), nextLink, body, accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Query dimension values of anomalies.
     *
     * @param nextLink the next link.
     * @param body query dimension values request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<String>> getDimensionOfAnomaliesByAnomalyDetectionConfigurationNextSinglePageAsync(
            String nextLink, AnomalyDimensionQuery body) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.getDimensionOfAnomaliesByAnomalyDetectionConfigurationNext(
                                        this.getEndpoint(), nextLink, body, accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Query dimension values of anomalies.
     *
     * @param nextLink the next link.
     * @param body query dimension values request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<String>> getDimensionOfAnomaliesByAnomalyDetectionConfigurationNextSinglePageAsync(
            String nextLink, AnomalyDimensionQuery body, Context context) {
        final String accept = "application/json";
        return service.getDimensionOfAnomaliesByAnomalyDetectionConfigurationNext(
                        this.getEndpoint(), nextLink, body, accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * List feedback on the given metric.
     *
     * @param nextLink the next link.
     * @param body metric feedback filter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<MetricFeedback>> listMetricFeedbacksNextSinglePageAsync(
            String nextLink, MetricFeedbackFilter body) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context -> service.listMetricFeedbacksNext(this.getEndpoint(), nextLink, body, accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * List feedback on the given metric.
     *
     * @param nextLink the next link.
     * @param body metric feedback filter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<MetricFeedback>> listMetricFeedbacksNextSinglePageAsync(
            String nextLink, MetricFeedbackFilter body, Context context) {
        final String accept = "application/json";
        return service.listMetricFeedbacksNext(this.getEndpoint(), nextLink, body, accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get data ingestion status by data feed.
     *
     * @param nextLink the next link.
     * @param body The query time range.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data ingestion status by data feed.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DataFeedIngestionStatus>> getDataFeedIngestionStatusNextSinglePageAsync(
            String nextLink, IngestionStatusQueryOptions body) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.getDataFeedIngestionStatusNext(
                                        this.getEndpoint(), nextLink, body, accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get data ingestion status by data feed.
     *
     * @param nextLink the next link.
     * @param body The query time range.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return data ingestion status by data feed.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DataFeedIngestionStatus>> getDataFeedIngestionStatusNextSinglePageAsync(
            String nextLink, IngestionStatusQueryOptions body, Context context) {
        final String accept = "application/json";
        return service.getDataFeedIngestionStatusNext(this.getEndpoint(), nextLink, body, accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * List series (dimension combinations) from metric.
     *
     * @param nextLink the next link.
     * @param body filter to query series.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<MetricSeriesItem>> getMetricSeriesNextSinglePageAsync(
            String nextLink, MetricSeriesQueryOptions body) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context -> service.getMetricSeriesNext(this.getEndpoint(), nextLink, body, accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * List series (dimension combinations) from metric.
     *
     * @param nextLink the next link.
     * @param body filter to query series.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<MetricSeriesItem>> getMetricSeriesNextSinglePageAsync(
            String nextLink, MetricSeriesQueryOptions body, Context context) {
        final String accept = "application/json";
        return service.getMetricSeriesNext(this.getEndpoint(), nextLink, body, accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * List dimension from certain metric.
     *
     * @param nextLink the next link.
     * @param body query dimension option.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<String>> getMetricDimensionNextSinglePageAsync(
            String nextLink, MetricDimensionQueryOptions body) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context -> service.getMetricDimensionNext(this.getEndpoint(), nextLink, body, accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                    null));
    }

    /**
     * List dimension from certain metric.
     *
     * @param nextLink the next link.
     * @param body query dimension option.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<String>> getMetricDimensionNextSinglePageAsync(
            String nextLink, MetricDimensionQueryOptions body, Context context) {
        final String accept = "application/json";
        return service.getMetricDimensionNext(this.getEndpoint(), nextLink, body, accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                    null));
    }

    /**
     * Query anomaly detection status.
     *
     * @param nextLink the next link.
     * @param body query options.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<EnrichmentStatus>> getEnrichmentStatusByMetricNextSinglePageAsync(
            String nextLink, EnrichmentStatusQueryOption body) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.getEnrichmentStatusByMetricNext(
                                        this.getEndpoint(), nextLink, body, accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                    null));
    }

    /**
     * Query anomaly detection status.
     *
     * @param nextLink the next link.
     * @param body query options.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<EnrichmentStatus>> getEnrichmentStatusByMetricNextSinglePageAsync(
            String nextLink, EnrichmentStatusQueryOption body, Context context) {
        final String accept = "application/json";
        return service.getEnrichmentStatusByMetricNext(this.getEndpoint(), nextLink, body, accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyResult>> getAnomaliesFromAlertByAnomalyAlertingConfigurationNextSinglePageAsync(
            String nextLink) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.getAnomaliesFromAlertByAnomalyAlertingConfigurationNext(
                                        nextLink, this.getEndpoint(), accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyResult>> getAnomaliesFromAlertByAnomalyAlertingConfigurationNextSinglePageAsync(
            String nextLink, Context context) {
        final String accept = "application/json";
        return service.getAnomaliesFromAlertByAnomalyAlertingConfigurationNext(
                        nextLink, this.getEndpoint(), accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<IncidentResult>> getIncidentsFromAlertByAnomalyAlertingConfigurationNextSinglePageAsync(
            String nextLink) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.getIncidentsFromAlertByAnomalyAlertingConfigurationNext(
                                        nextLink, this.getEndpoint(), accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<IncidentResult>> getIncidentsFromAlertByAnomalyAlertingConfigurationNextSinglePageAsync(
            String nextLink, Context context) {
        final String accept = "application/json";
        return service.getIncidentsFromAlertByAnomalyAlertingConfigurationNext(
                        nextLink, this.getEndpoint(), accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyAlertingConfiguration>>
            getAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationNextSinglePageAsync(String nextLink) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.getAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationNext(
                                        nextLink, this.getEndpoint(), accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyAlertingConfiguration>>
            getAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationNextSinglePageAsync(
                    String nextLink, Context context) {
        final String accept = "application/json";
        return service.getAnomalyAlertingConfigurationsByAnomalyDetectionConfigurationNext(
                        nextLink, this.getEndpoint(), accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<IncidentResult>> getIncidentsByAnomalyDetectionConfigurationNextSinglePageAsync(
            String nextLink) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.getIncidentsByAnomalyDetectionConfigurationNext(
                                        nextLink, this.getEndpoint(), accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<IncidentResult>> getIncidentsByAnomalyDetectionConfigurationNextSinglePageAsync(
            String nextLink, Context context) {
        final String accept = "application/json";
        return service.getIncidentsByAnomalyDetectionConfigurationNext(nextLink, this.getEndpoint(), accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<IncidentResult>> getIncidentsByAnomalyDetectionConfigurationNextPagesNextSinglePageAsync(
            String nextLink) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.getIncidentsByAnomalyDetectionConfigurationNextPagesNext(
                                        nextLink, this.getEndpoint(), accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<IncidentResult>> getIncidentsByAnomalyDetectionConfigurationNextPagesNextSinglePageAsync(
            String nextLink, Context context) {
        final String accept = "application/json";
        return service.getIncidentsByAnomalyDetectionConfigurationNextPagesNext(
                        nextLink, this.getEndpoint(), accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DataSourceCredential>> listCredentialsNextSinglePageAsync(String nextLink) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context -> service.listCredentialsNext(nextLink, this.getEndpoint(), accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DataSourceCredential>> listCredentialsNextSinglePageAsync(
            String nextLink, Context context) {
        final String accept = "application/json";
        return service.listCredentialsNext(nextLink, this.getEndpoint(), accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DataFeedDetail>> listDataFeedsNextSinglePageAsync(String nextLink) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.listDataFeedsNext(nextLink, this.getEndpoint(), accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<DataFeedDetail>> listDataFeedsNextSinglePageAsync(String nextLink, Context context) {
        final String accept = "application/json";
        return service.listDataFeedsNext(nextLink, this.getEndpoint(), accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<HookInfo>> listHooksNextSinglePageAsync(String nextLink) {
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.listHooksNext(nextLink, this.getEndpoint(), accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<HookInfo>> listHooksNextSinglePageAsync(String nextLink, Context context) {
        final String accept = "application/json";
        return service.listHooksNext(nextLink, this.getEndpoint(), accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyDetectionConfiguration>>
            getAnomalyDetectionConfigurationsByMetricNextSinglePageAsync(String nextLink) {
        final String accept = "application/json";
        return FluxUtil.withContext(
                        context ->
                                service.getAnomalyDetectionConfigurationsByMetricNext(
                                        nextLink, this.getEndpoint(), accept, context))
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws MetricsAdvisorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PagedResponse<AnomalyDetectionConfiguration>>
            getAnomalyDetectionConfigurationsByMetricNextSinglePageAsync(String nextLink, Context context) {
        final String accept = "application/json";
        return service.getAnomalyDetectionConfigurationsByMetricNext(nextLink, this.getEndpoint(), accept, context)
                .map(
                        res ->
                                new PagedResponseBase<>(
                                        res.getRequest(),
                                        res.getStatusCode(),
                                        res.getHeaders(),
                                        res.getValue().getValue(),
                                        res.getValue().getNextLink(),
                                        null));
    }
}
