// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.implementation.models;

import com.azure.ai.metricsadvisor.models.AlertQueryTimeMode;
import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** The AlertingResultQuery model. */
@Fluent
public final class AlertingResultQuery {
    /*
     * start time
     */
    @JsonProperty(value = "startTime", required = true)
    private OffsetDateTime startTime;

    /*
     * end time
     */
    @JsonProperty(value = "endTime", required = true)
    private OffsetDateTime endTime;

    /*
     * time mode
     */
    @JsonProperty(value = "timeMode", required = true)
    private AlertQueryTimeMode timeMode;

    /**
     * Get the startTime property: start time.
     *
     * @return the startTime value.
     */
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: start time.
     *
     * @param startTime the startTime value to set.
     * @return the AlertingResultQuery object itself.
     */
    public AlertingResultQuery setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the endTime property: end time.
     *
     * @return the endTime value.
     */
    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    /**
     * Set the endTime property: end time.
     *
     * @param endTime the endTime value to set.
     * @return the AlertingResultQuery object itself.
     */
    public AlertingResultQuery setEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    /**
     * Get the timeMode property: time mode.
     *
     * @return the timeMode value.
     */
    public AlertQueryTimeMode getTimeMode() {
        return this.timeMode;
    }

    /**
     * Set the timeMode property: time mode.
     *
     * @param timeMode the timeMode value to set.
     * @return the AlertingResultQuery object itself.
     */
    public AlertingResultQuery setTimeMode(AlertQueryTimeMode timeMode) {
        this.timeMode = timeMode;
        return this;
    }
}
