// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.UUID;

/** The AnomalyDetectionConfiguration model. */
@Fluent
public final class AnomalyDetectionConfiguration {
    /*
     * anomaly detection configuration unique id
     */
    @JsonProperty(value = "anomalyDetectionConfigurationId", access = JsonProperty.Access.WRITE_ONLY)
    private UUID anomalyDetectionConfigurationId;

    /*
     * anomaly detection configuration name
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /*
     * anomaly detection configuration description
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * metric unique id
     */
    @JsonProperty(value = "metricId", required = true)
    private UUID metricId;

    /*
     * The wholeMetricConfiguration property.
     */
    @JsonProperty(value = "wholeMetricConfiguration", required = true)
    private WholeMetricConfiguration wholeMetricConfiguration;

    /*
     * detection configuration for series group
     */
    @JsonProperty(value = "dimensionGroupOverrideConfigurations")
    private List<DimensionGroupConfiguration> dimensionGroupOverrideConfigurations;

    /*
     * detection configuration for specific series
     */
    @JsonProperty(value = "seriesOverrideConfigurations")
    private List<SeriesConfiguration> seriesOverrideConfigurations;

    /**
     * Get the anomalyDetectionConfigurationId property: anomaly detection configuration unique id.
     *
     * @return the anomalyDetectionConfigurationId value.
     */
    public UUID getAnomalyDetectionConfigurationId() {
        return this.anomalyDetectionConfigurationId;
    }

    /**
     * Get the name property: anomaly detection configuration name.
     *
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: anomaly detection configuration name.
     *
     * @param name the name value to set.
     * @return the AnomalyDetectionConfiguration object itself.
     */
    public AnomalyDetectionConfiguration setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the description property: anomaly detection configuration description.
     *
     * @return the description value.
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: anomaly detection configuration description.
     *
     * @param description the description value to set.
     * @return the AnomalyDetectionConfiguration object itself.
     */
    public AnomalyDetectionConfiguration setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the metricId property: metric unique id.
     *
     * @return the metricId value.
     */
    public UUID getMetricId() {
        return this.metricId;
    }

    /**
     * Set the metricId property: metric unique id.
     *
     * @param metricId the metricId value to set.
     * @return the AnomalyDetectionConfiguration object itself.
     */
    public AnomalyDetectionConfiguration setMetricId(UUID metricId) {
        this.metricId = metricId;
        return this;
    }

    /**
     * Get the wholeMetricConfiguration property: The wholeMetricConfiguration property.
     *
     * @return the wholeMetricConfiguration value.
     */
    public WholeMetricConfiguration getWholeMetricConfiguration() {
        return this.wholeMetricConfiguration;
    }

    /**
     * Set the wholeMetricConfiguration property: The wholeMetricConfiguration property.
     *
     * @param wholeMetricConfiguration the wholeMetricConfiguration value to set.
     * @return the AnomalyDetectionConfiguration object itself.
     */
    public AnomalyDetectionConfiguration setWholeMetricConfiguration(
            WholeMetricConfiguration wholeMetricConfiguration) {
        this.wholeMetricConfiguration = wholeMetricConfiguration;
        return this;
    }

    /**
     * Get the dimensionGroupOverrideConfigurations property: detection configuration for series group.
     *
     * @return the dimensionGroupOverrideConfigurations value.
     */
    public List<DimensionGroupConfiguration> getDimensionGroupOverrideConfigurations() {
        return this.dimensionGroupOverrideConfigurations;
    }

    /**
     * Set the dimensionGroupOverrideConfigurations property: detection configuration for series group.
     *
     * @param dimensionGroupOverrideConfigurations the dimensionGroupOverrideConfigurations value to set.
     * @return the AnomalyDetectionConfiguration object itself.
     */
    public AnomalyDetectionConfiguration setDimensionGroupOverrideConfigurations(
            List<DimensionGroupConfiguration> dimensionGroupOverrideConfigurations) {
        this.dimensionGroupOverrideConfigurations = dimensionGroupOverrideConfigurations;
        return this;
    }

    /**
     * Get the seriesOverrideConfigurations property: detection configuration for specific series.
     *
     * @return the seriesOverrideConfigurations value.
     */
    public List<SeriesConfiguration> getSeriesOverrideConfigurations() {
        return this.seriesOverrideConfigurations;
    }

    /**
     * Set the seriesOverrideConfigurations property: detection configuration for specific series.
     *
     * @param seriesOverrideConfigurations the seriesOverrideConfigurations value to set.
     * @return the AnomalyDetectionConfiguration object itself.
     */
    public AnomalyDetectionConfiguration setSeriesOverrideConfigurations(
            List<SeriesConfiguration> seriesOverrideConfigurations) {
        this.seriesOverrideConfigurations = seriesOverrideConfigurations;
        return this;
    }
}
