// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.implementation.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for AnomalyDetectionConfigurationLogicType. */
public final class AnomalyDetectionConfigurationLogicType
        extends ExpandableStringEnum<AnomalyDetectionConfigurationLogicType> {
    /** Static value AND for AnomalyDetectionConfigurationLogicType. */
    public static final AnomalyDetectionConfigurationLogicType AND = fromString("AND");

    /** Static value OR for AnomalyDetectionConfigurationLogicType. */
    public static final AnomalyDetectionConfigurationLogicType OR = fromString("OR");

    /**
     * Creates or finds a AnomalyDetectionConfigurationLogicType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding AnomalyDetectionConfigurationLogicType.
     */
    @JsonCreator
    public static AnomalyDetectionConfigurationLogicType fromString(String name) {
        return fromString(name, AnomalyDetectionConfigurationLogicType.class);
    }

    /** @return known AnomalyDetectionConfigurationLogicType values. */
    public static Collection<AnomalyDetectionConfigurationLogicType> values() {
        return values(AnomalyDetectionConfigurationLogicType.class);
    }
}
