// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The AnomalyDetectionConfigurationPatch model. */
@Fluent
public final class AnomalyDetectionConfigurationPatch {
    /*
     * anomaly detection configuration name
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * anomaly detection configuration description
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * The wholeMetricConfiguration property.
     */
    @JsonProperty(value = "wholeMetricConfiguration")
    private WholeMetricConfigurationPatch wholeMetricConfiguration;

    /*
     * detection configuration for series group
     */
    @JsonProperty(value = "dimensionGroupOverrideConfigurations")
    private List<DimensionGroupConfiguration> dimensionGroupOverrideConfigurations;

    /*
     * detection configuration for specific series
     */
    @JsonProperty(value = "seriesOverrideConfigurations")
    private List<SeriesConfiguration> seriesOverrideConfigurations;

    /**
     * Get the name property: anomaly detection configuration name.
     *
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: anomaly detection configuration name.
     *
     * @param name the name value to set.
     * @return the AnomalyDetectionConfigurationPatch object itself.
     */
    public AnomalyDetectionConfigurationPatch setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the description property: anomaly detection configuration description.
     *
     * @return the description value.
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: anomaly detection configuration description.
     *
     * @param description the description value to set.
     * @return the AnomalyDetectionConfigurationPatch object itself.
     */
    public AnomalyDetectionConfigurationPatch setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the wholeMetricConfiguration property: The wholeMetricConfiguration property.
     *
     * @return the wholeMetricConfiguration value.
     */
    public WholeMetricConfigurationPatch getWholeMetricConfiguration() {
        return this.wholeMetricConfiguration;
    }

    /**
     * Set the wholeMetricConfiguration property: The wholeMetricConfiguration property.
     *
     * @param wholeMetricConfiguration the wholeMetricConfiguration value to set.
     * @return the AnomalyDetectionConfigurationPatch object itself.
     */
    public AnomalyDetectionConfigurationPatch setWholeMetricConfiguration(
            WholeMetricConfigurationPatch wholeMetricConfiguration) {
        this.wholeMetricConfiguration = wholeMetricConfiguration;
        return this;
    }

    /**
     * Get the dimensionGroupOverrideConfigurations property: detection configuration for series group.
     *
     * @return the dimensionGroupOverrideConfigurations value.
     */
    public List<DimensionGroupConfiguration> getDimensionGroupOverrideConfigurations() {
        return this.dimensionGroupOverrideConfigurations;
    }

    /**
     * Set the dimensionGroupOverrideConfigurations property: detection configuration for series group.
     *
     * @param dimensionGroupOverrideConfigurations the dimensionGroupOverrideConfigurations value to set.
     * @return the AnomalyDetectionConfigurationPatch object itself.
     */
    public AnomalyDetectionConfigurationPatch setDimensionGroupOverrideConfigurations(
            List<DimensionGroupConfiguration> dimensionGroupOverrideConfigurations) {
        this.dimensionGroupOverrideConfigurations = dimensionGroupOverrideConfigurations;
        return this;
    }

    /**
     * Get the seriesOverrideConfigurations property: detection configuration for specific series.
     *
     * @return the seriesOverrideConfigurations value.
     */
    public List<SeriesConfiguration> getSeriesOverrideConfigurations() {
        return this.seriesOverrideConfigurations;
    }

    /**
     * Set the seriesOverrideConfigurations property: detection configuration for specific series.
     *
     * @param seriesOverrideConfigurations the seriesOverrideConfigurations value to set.
     * @return the AnomalyDetectionConfigurationPatch object itself.
     */
    public AnomalyDetectionConfigurationPatch setSeriesOverrideConfigurations(
            List<SeriesConfiguration> seriesOverrideConfigurations) {
        this.seriesOverrideConfigurations = seriesOverrideConfigurations;
        return this;
    }
}
