// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** The AnomalyDimensionQuery model. */
@Fluent
public final class AnomalyDimensionQuery {
    /*
     * start time
     */
    @JsonProperty(value = "startTime", required = true)
    private OffsetDateTime startTime;

    /*
     * end time
     */
    @JsonProperty(value = "endTime", required = true)
    private OffsetDateTime endTime;

    /*
     * dimension to query
     */
    @JsonProperty(value = "dimensionName", required = true)
    private String dimensionName;

    /*
     * The dimensionFilter property.
     */
    @JsonProperty(value = "dimensionFilter")
    private DimensionGroupIdentity dimensionFilter;

    /**
     * Get the startTime property: start time.
     *
     * @return the startTime value.
     */
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: start time.
     *
     * @param startTime the startTime value to set.
     * @return the AnomalyDimensionQuery object itself.
     */
    public AnomalyDimensionQuery setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the endTime property: end time.
     *
     * @return the endTime value.
     */
    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    /**
     * Set the endTime property: end time.
     *
     * @param endTime the endTime value to set.
     * @return the AnomalyDimensionQuery object itself.
     */
    public AnomalyDimensionQuery setEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    /**
     * Get the dimensionName property: dimension to query.
     *
     * @return the dimensionName value.
     */
    public String getDimensionName() {
        return this.dimensionName;
    }

    /**
     * Set the dimensionName property: dimension to query.
     *
     * @param dimensionName the dimensionName value to set.
     * @return the AnomalyDimensionQuery object itself.
     */
    public AnomalyDimensionQuery setDimensionName(String dimensionName) {
        this.dimensionName = dimensionName;
        return this;
    }

    /**
     * Get the dimensionFilter property: The dimensionFilter property.
     *
     * @return the dimensionFilter value.
     */
    public DimensionGroupIdentity getDimensionFilter() {
        return this.dimensionFilter;
    }

    /**
     * Set the dimensionFilter property: The dimensionFilter property.
     *
     * @param dimensionFilter the dimensionFilter value to set.
     * @return the AnomalyDimensionQuery object itself.
     */
    public AnomalyDimensionQuery setDimensionFilter(DimensionGroupIdentity dimensionFilter) {
        this.dimensionFilter = dimensionFilter;
        return this;
    }
}
