// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.implementation.models;

import com.azure.ai.metricsadvisor.administration.models.AnomalySeverity;
import com.azure.ai.metricsadvisor.models.AnomalyStatus;
import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The AnomalyProperty model. */
@Fluent
public final class AnomalyProperty {
    /*
     * anomaly severity
     */
    @JsonProperty(value = "anomalySeverity", required = true)
    private AnomalySeverity anomalySeverity;

    /*
     * anomaly status
     *
     * only return for alerting anomaly result
     */
    @JsonProperty(value = "anomalyStatus", access = JsonProperty.Access.WRITE_ONLY)
    private AnomalyStatus anomalyStatus;

    /*
     * value of the anomaly
     */
    @JsonProperty(value = "value", access = JsonProperty.Access.WRITE_ONLY)
    private Double value;

    /*
     * expected value of the anomaly given by smart detector
     */
    @JsonProperty(value = "expectedValue", access = JsonProperty.Access.WRITE_ONLY)
    private Double expectedValue;

    /**
     * Get the anomalySeverity property: anomaly severity.
     *
     * @return the anomalySeverity value.
     */
    public AnomalySeverity getAnomalySeverity() {
        return this.anomalySeverity;
    }

    /**
     * Set the anomalySeverity property: anomaly severity.
     *
     * @param anomalySeverity the anomalySeverity value to set.
     * @return the AnomalyProperty object itself.
     */
    public AnomalyProperty setAnomalySeverity(AnomalySeverity anomalySeverity) {
        this.anomalySeverity = anomalySeverity;
        return this;
    }

    /**
     * Get the anomalyStatus property: anomaly status
     *
     * <p>only return for alerting anomaly result.
     *
     * @return the anomalyStatus value.
     */
    public AnomalyStatus getAnomalyStatus() {
        return this.anomalyStatus;
    }

    /**
     * Get the value property: value of the anomaly.
     *
     * @return the value value.
     */
    public Double getValue() {
        return this.value;
    }

    /**
     * Get the expectedValue property: expected value of the anomaly given by smart detector.
     *
     * @return the expectedValue value.
     */
    public Double getExpectedValue() {
        return this.expectedValue;
    }
}
