// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.implementation.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for AuthenticationTypeEnum. */
public final class AuthenticationTypeEnum extends ExpandableStringEnum<AuthenticationTypeEnum> {
    /** Static value Basic for AuthenticationTypeEnum. */
    public static final AuthenticationTypeEnum BASIC = fromString("Basic");

    /** Static value ManagedIdentity for AuthenticationTypeEnum. */
    public static final AuthenticationTypeEnum MANAGED_IDENTITY = fromString("ManagedIdentity");

    /** Static value AzureSQLConnectionString for AuthenticationTypeEnum. */
    public static final AuthenticationTypeEnum AZURE_SQLCONNECTION_STRING = fromString("AzureSQLConnectionString");

    /** Static value DataLakeGen2SharedKey for AuthenticationTypeEnum. */
    public static final AuthenticationTypeEnum DATA_LAKE_GEN2SHARED_KEY = fromString("DataLakeGen2SharedKey");

    /** Static value ServicePrincipal for AuthenticationTypeEnum. */
    public static final AuthenticationTypeEnum SERVICE_PRINCIPAL = fromString("ServicePrincipal");

    /** Static value ServicePrincipalInKV for AuthenticationTypeEnum. */
    public static final AuthenticationTypeEnum SERVICE_PRINCIPAL_IN_KV = fromString("ServicePrincipalInKV");

    /**
     * Creates or finds a AuthenticationTypeEnum from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding AuthenticationTypeEnum.
     */
    @JsonCreator
    public static AuthenticationTypeEnum fromString(String name) {
        return fromString(name, AuthenticationTypeEnum.class);
    }

    /** @return known AuthenticationTypeEnum values. */
    public static Collection<AuthenticationTypeEnum> values() {
        return values(AuthenticationTypeEnum.class);
    }
}
