// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The AzureCosmosDBParameter model. */
@Fluent
public final class AzureCosmosDBParameter {
    /*
     * The connection string of this Azure CosmosDB
     */
    @JsonProperty(value = "connectionString")
    private String connectionString;

    /*
     * The statement to query this collection
     */
    @JsonProperty(value = "sqlQuery", required = true)
    private String sqlQuery;

    /*
     * A database name in this Azure CosmosDB
     */
    @JsonProperty(value = "database", required = true)
    private String database;

    /*
     * A collection id in this database
     */
    @JsonProperty(value = "collectionId", required = true)
    private String collectionId;

    /**
     * Get the connectionString property: The connection string of this Azure CosmosDB.
     *
     * @return the connectionString value.
     */
    public String getConnectionString() {
        return this.connectionString;
    }

    /**
     * Set the connectionString property: The connection string of this Azure CosmosDB.
     *
     * @param connectionString the connectionString value to set.
     * @return the AzureCosmosDBParameter object itself.
     */
    public AzureCosmosDBParameter setConnectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    /**
     * Get the sqlQuery property: The statement to query this collection.
     *
     * @return the sqlQuery value.
     */
    public String getSqlQuery() {
        return this.sqlQuery;
    }

    /**
     * Set the sqlQuery property: The statement to query this collection.
     *
     * @param sqlQuery the sqlQuery value to set.
     * @return the AzureCosmosDBParameter object itself.
     */
    public AzureCosmosDBParameter setSqlQuery(String sqlQuery) {
        this.sqlQuery = sqlQuery;
        return this;
    }

    /**
     * Get the database property: A database name in this Azure CosmosDB.
     *
     * @return the database value.
     */
    public String getDatabase() {
        return this.database;
    }

    /**
     * Set the database property: A database name in this Azure CosmosDB.
     *
     * @param database the database value to set.
     * @return the AzureCosmosDBParameter object itself.
     */
    public AzureCosmosDBParameter setDatabase(String database) {
        this.database = database;
        return this;
    }

    /**
     * Get the collectionId property: A collection id in this database.
     *
     * @return the collectionId value.
     */
    public String getCollectionId() {
        return this.collectionId;
    }

    /**
     * Set the collectionId property: A collection id in this database.
     *
     * @param collectionId the collectionId value to set.
     * @return the AzureCosmosDBParameter object itself.
     */
    public AzureCosmosDBParameter setCollectionId(String collectionId) {
        this.collectionId = collectionId;
        return this;
    }
}
