// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The AzureDataLakeStorageGen2Parameter model. */
@Fluent
public final class AzureDataLakeStorageGen2Parameter {
    /*
     * The account name of this Azure Data Lake
     */
    @JsonProperty(value = "accountName")
    private String accountName;

    /*
     * The account key that can access this Azure Data Lake
     */
    @JsonProperty(value = "accountKey")
    private String accountKey;

    /*
     * The file system (container) name in this Azure Data Lake
     */
    @JsonProperty(value = "fileSystemName", required = true)
    private String fileSystemName;

    /*
     * The directory template under this file system
     */
    @JsonProperty(value = "directoryTemplate", required = true)
    private String directoryTemplate;

    /*
     * The file template
     */
    @JsonProperty(value = "fileTemplate", required = true)
    private String fileTemplate;

    /**
     * Get the accountName property: The account name of this Azure Data Lake.
     *
     * @return the accountName value.
     */
    public String getAccountName() {
        return this.accountName;
    }

    /**
     * Set the accountName property: The account name of this Azure Data Lake.
     *
     * @param accountName the accountName value to set.
     * @return the AzureDataLakeStorageGen2Parameter object itself.
     */
    public AzureDataLakeStorageGen2Parameter setAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    /**
     * Get the accountKey property: The account key that can access this Azure Data Lake.
     *
     * @return the accountKey value.
     */
    public String getAccountKey() {
        return this.accountKey;
    }

    /**
     * Set the accountKey property: The account key that can access this Azure Data Lake.
     *
     * @param accountKey the accountKey value to set.
     * @return the AzureDataLakeStorageGen2Parameter object itself.
     */
    public AzureDataLakeStorageGen2Parameter setAccountKey(String accountKey) {
        this.accountKey = accountKey;
        return this;
    }

    /**
     * Get the fileSystemName property: The file system (container) name in this Azure Data Lake.
     *
     * @return the fileSystemName value.
     */
    public String getFileSystemName() {
        return this.fileSystemName;
    }

    /**
     * Set the fileSystemName property: The file system (container) name in this Azure Data Lake.
     *
     * @param fileSystemName the fileSystemName value to set.
     * @return the AzureDataLakeStorageGen2Parameter object itself.
     */
    public AzureDataLakeStorageGen2Parameter setFileSystemName(String fileSystemName) {
        this.fileSystemName = fileSystemName;
        return this;
    }

    /**
     * Get the directoryTemplate property: The directory template under this file system.
     *
     * @return the directoryTemplate value.
     */
    public String getDirectoryTemplate() {
        return this.directoryTemplate;
    }

    /**
     * Set the directoryTemplate property: The directory template under this file system.
     *
     * @param directoryTemplate the directoryTemplate value to set.
     * @return the AzureDataLakeStorageGen2Parameter object itself.
     */
    public AzureDataLakeStorageGen2Parameter setDirectoryTemplate(String directoryTemplate) {
        this.directoryTemplate = directoryTemplate;
        return this;
    }

    /**
     * Get the fileTemplate property: The file template.
     *
     * @return the fileTemplate value.
     */
    public String getFileTemplate() {
        return this.fileTemplate;
    }

    /**
     * Set the fileTemplate property: The file template.
     *
     * @param fileTemplate the fileTemplate value to set.
     * @return the AzureDataLakeStorageGen2Parameter object itself.
     */
    public AzureDataLakeStorageGen2Parameter setFileTemplate(String fileTemplate) {
        this.fileTemplate = fileTemplate;
        return this;
    }
}
