// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The AzureEventHubsParameter model. */
@Fluent
public final class AzureEventHubsParameter {
    /*
     * The connection string of this Azure Event Hubs
     */
    @JsonProperty(value = "connectionString")
    private String connectionString;

    /*
     * The consumer group to be used in this data feed
     */
    @JsonProperty(value = "consumerGroup", required = true)
    private String consumerGroup;

    /**
     * Get the connectionString property: The connection string of this Azure Event Hubs.
     *
     * @return the connectionString value.
     */
    public String getConnectionString() {
        return this.connectionString;
    }

    /**
     * Set the connectionString property: The connection string of this Azure Event Hubs.
     *
     * @param connectionString the connectionString value to set.
     * @return the AzureEventHubsParameter object itself.
     */
    public AzureEventHubsParameter setConnectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    /**
     * Get the consumerGroup property: The consumer group to be used in this data feed.
     *
     * @return the consumerGroup value.
     */
    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    /**
     * Set the consumerGroup property: The consumer group to be used in this data feed.
     *
     * @param consumerGroup the consumerGroup value to set.
     * @return the AzureEventHubsParameter object itself.
     */
    public AzureEventHubsParameter setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
        return this;
    }
}
