// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.OffsetDateTime;

/** The ChangePointFeedback model. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "feedbackType")
@JsonTypeName("ChangePoint")
@Fluent
public final class ChangePointFeedback extends MetricFeedback {
    /*
     * the start timestamp of feedback time range
     */
    @JsonProperty(value = "startTime", required = true)
    private OffsetDateTime startTime;

    /*
     * the end timestamp of feedback time range, when equals to startTime means
     * only one timestamp
     */
    @JsonProperty(value = "endTime", required = true)
    private OffsetDateTime endTime;

    /*
     * The value property.
     */
    @JsonProperty(value = "value", required = true)
    private ChangePointFeedbackValue value;

    /**
     * Get the startTime property: the start timestamp of feedback time range.
     *
     * @return the startTime value.
     */
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: the start timestamp of feedback time range.
     *
     * @param startTime the startTime value to set.
     * @return the ChangePointFeedback object itself.
     */
    public ChangePointFeedback setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the endTime property: the end timestamp of feedback time range, when equals to startTime means only one
     * timestamp.
     *
     * @return the endTime value.
     */
    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    /**
     * Set the endTime property: the end timestamp of feedback time range, when equals to startTime means only one
     * timestamp.
     *
     * @param endTime the endTime value to set.
     * @return the ChangePointFeedback object itself.
     */
    public ChangePointFeedback setEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    /**
     * Get the value property: The value property.
     *
     * @return the value value.
     */
    public ChangePointFeedbackValue getValue() {
        return this.value;
    }

    /**
     * Set the value property: The value property.
     *
     * @param value the value value to set.
     * @return the ChangePointFeedback object itself.
     */
    public ChangePointFeedback setValue(ChangePointFeedbackValue value) {
        this.value = value;
        return this;
    }
}
