// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.OffsetDateTime;
import java.util.List;

/** The DataFeedDetailPatch model. */
@JsonTypeInfo(
        use = JsonTypeInfo.Id.NAME,
        include = JsonTypeInfo.As.PROPERTY,
        property = "dataSourceType",
        defaultImpl = DataFeedDetailPatch.class)
@JsonTypeName("DataFeedDetailPatch")
@JsonSubTypes({
    @JsonSubTypes.Type(name = "AzureApplicationInsights", value = AzureApplicationInsightsDataFeedPatch.class),
    @JsonSubTypes.Type(name = "AzureBlob", value = AzureBlobDataFeedPatch.class),
    @JsonSubTypes.Type(name = "AzureCosmosDB", value = AzureCosmosDBDataFeedPatch.class),
    @JsonSubTypes.Type(name = "AzureDataExplorer", value = AzureDataExplorerDataFeedPatch.class),
    @JsonSubTypes.Type(name = "AzureDataLakeStorageGen2", value = AzureDataLakeStorageGen2DataFeedPatch.class),
    @JsonSubTypes.Type(name = "AzureEventHubs", value = AzureEventHubsDataFeedPatch.class),
    @JsonSubTypes.Type(name = "AzureLogAnalytics", value = AzureLogAnalyticsDataFeedPatch.class),
    @JsonSubTypes.Type(name = "AzureTable", value = AzureTableDataFeedPatch.class),
    @JsonSubTypes.Type(name = "InfluxDB", value = InfluxDBDataFeedPatch.class),
    @JsonSubTypes.Type(name = "MySql", value = MySqlDataFeedPatch.class),
    @JsonSubTypes.Type(name = "PostgreSql", value = PostgreSqlDataFeedPatch.class),
    @JsonSubTypes.Type(name = "SqlServer", value = SQLServerDataFeedPatch.class),
    @JsonSubTypes.Type(name = "MongoDB", value = MongoDBDataFeedPatch.class)
})
@Fluent
public class DataFeedDetailPatch {
    /*
     * data feed name
     */
    @JsonProperty(value = "dataFeedName")
    private String dataFeedName;

    /*
     * data feed description
     */
    @JsonProperty(value = "dataFeedDescription")
    private String dataFeedDescription;

    /*
     * user-defined timestamp column. if timestampColumn is null, start time of
     * every time slice will be used as default value.
     */
    @JsonProperty(value = "timestampColumn")
    private String timestampColumn;

    /*
     * ingestion start time
     */
    @JsonProperty(value = "dataStartFrom")
    private OffsetDateTime dataStartFrom;

    /*
     * the time that the beginning of data ingestion task will delay for every
     * data slice according to this offset.
     */
    @JsonProperty(value = "startOffsetInSeconds")
    private Long startOffsetInSeconds;

    /*
     * the max concurrency of data ingestion queries against user data source.
     * 0 means no limitation.
     */
    @JsonProperty(value = "maxConcurrency")
    private Integer maxConcurrency;

    /*
     * the min retry interval for failed data ingestion tasks.
     */
    @JsonProperty(value = "minRetryIntervalInSeconds")
    private Long minRetryIntervalInSeconds;

    /*
     * stop retry data ingestion after the data slice first schedule time in
     * seconds.
     */
    @JsonProperty(value = "stopRetryAfterInSeconds")
    private Long stopRetryAfterInSeconds;

    /*
     * mark if the data feed need rollup
     */
    @JsonProperty(value = "needRollup")
    private NeedRollupEnum needRollup;

    /*
     * roll up method
     */
    @JsonProperty(value = "rollUpMethod")
    private RollUpMethod rollUpMethod;

    /*
     * roll up columns
     */
    @JsonProperty(value = "rollUpColumns")
    private List<String> rollUpColumns;

    /*
     * the identification value for the row of calculated all-up value.
     */
    @JsonProperty(value = "allUpIdentification")
    private String allUpIdentification;

    /*
     * the type of fill missing point for anomaly detection
     */
    @JsonProperty(value = "fillMissingPointType")
    private FillMissingPointType fillMissingPointType;

    /*
     * the value of fill missing point for anomaly detection
     */
    @JsonProperty(value = "fillMissingPointValue")
    private Double fillMissingPointValue;

    /*
     * data feed access mode, default is Private
     */
    @JsonProperty(value = "viewMode")
    private ViewMode viewMode;

    /*
     * data feed administrator
     */
    @JsonProperty(value = "admins")
    private List<String> admins;

    /*
     * data feed viewer
     */
    @JsonProperty(value = "viewers")
    private List<String> viewers;

    /*
     * data feed status
     */
    @JsonProperty(value = "status")
    private EntityStatus status;

    /*
     * action link for alert
     */
    @JsonProperty(value = "actionLinkTemplate")
    private String actionLinkTemplate;

    /*
     * authentication type for corresponding data source
     */
    @JsonProperty(value = "authenticationType")
    private AuthenticationTypeEnum authenticationType;

    /*
     * The credential entity id
     */
    @JsonProperty(value = "credentialId")
    private String credentialId;

    /**
     * Get the dataFeedName property: data feed name.
     *
     * @return the dataFeedName value.
     */
    public String getDataFeedName() {
        return this.dataFeedName;
    }

    /**
     * Set the dataFeedName property: data feed name.
     *
     * @param dataFeedName the dataFeedName value to set.
     * @return the DataFeedDetailPatch object itself.
     */
    public DataFeedDetailPatch setDataFeedName(String dataFeedName) {
        this.dataFeedName = dataFeedName;
        return this;
    }

    /**
     * Get the dataFeedDescription property: data feed description.
     *
     * @return the dataFeedDescription value.
     */
    public String getDataFeedDescription() {
        return this.dataFeedDescription;
    }

    /**
     * Set the dataFeedDescription property: data feed description.
     *
     * @param dataFeedDescription the dataFeedDescription value to set.
     * @return the DataFeedDetailPatch object itself.
     */
    public DataFeedDetailPatch setDataFeedDescription(String dataFeedDescription) {
        this.dataFeedDescription = dataFeedDescription;
        return this;
    }

    /**
     * Get the timestampColumn property: user-defined timestamp column. if timestampColumn is null, start time of every
     * time slice will be used as default value.
     *
     * @return the timestampColumn value.
     */
    public String getTimestampColumn() {
        return this.timestampColumn;
    }

    /**
     * Set the timestampColumn property: user-defined timestamp column. if timestampColumn is null, start time of every
     * time slice will be used as default value.
     *
     * @param timestampColumn the timestampColumn value to set.
     * @return the DataFeedDetailPatch object itself.
     */
    public DataFeedDetailPatch setTimestampColumn(String timestampColumn) {
        this.timestampColumn = timestampColumn;
        return this;
    }

    /**
     * Get the dataStartFrom property: ingestion start time.
     *
     * @return the dataStartFrom value.
     */
    public OffsetDateTime getDataStartFrom() {
        return this.dataStartFrom;
    }

    /**
     * Set the dataStartFrom property: ingestion start time.
     *
     * @param dataStartFrom the dataStartFrom value to set.
     * @return the DataFeedDetailPatch object itself.
     */
    public DataFeedDetailPatch setDataStartFrom(OffsetDateTime dataStartFrom) {
        this.dataStartFrom = dataStartFrom;
        return this;
    }

    /**
     * Get the startOffsetInSeconds property: the time that the beginning of data ingestion task will delay for every
     * data slice according to this offset.
     *
     * @return the startOffsetInSeconds value.
     */
    public Long getStartOffsetInSeconds() {
        return this.startOffsetInSeconds;
    }

    /**
     * Set the startOffsetInSeconds property: the time that the beginning of data ingestion task will delay for every
     * data slice according to this offset.
     *
     * @param startOffsetInSeconds the startOffsetInSeconds value to set.
     * @return the DataFeedDetailPatch object itself.
     */
    public DataFeedDetailPatch setStartOffsetInSeconds(Long startOffsetInSeconds) {
        this.startOffsetInSeconds = startOffsetInSeconds;
        return this;
    }

    /**
     * Get the maxConcurrency property: the max concurrency of data ingestion queries against user data source. 0 means
     * no limitation.
     *
     * @return the maxConcurrency value.
     */
    public Integer getMaxConcurrency() {
        return this.maxConcurrency;
    }

    /**
     * Set the maxConcurrency property: the max concurrency of data ingestion queries against user data source. 0 means
     * no limitation.
     *
     * @param maxConcurrency the maxConcurrency value to set.
     * @return the DataFeedDetailPatch object itself.
     */
    public DataFeedDetailPatch setMaxConcurrency(Integer maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
        return this;
    }

    /**
     * Get the minRetryIntervalInSeconds property: the min retry interval for failed data ingestion tasks.
     *
     * @return the minRetryIntervalInSeconds value.
     */
    public Long getMinRetryIntervalInSeconds() {
        return this.minRetryIntervalInSeconds;
    }

    /**
     * Set the minRetryIntervalInSeconds property: the min retry interval for failed data ingestion tasks.
     *
     * @param minRetryIntervalInSeconds the minRetryIntervalInSeconds value to set.
     * @return the DataFeedDetailPatch object itself.
     */
    public DataFeedDetailPatch setMinRetryIntervalInSeconds(Long minRetryIntervalInSeconds) {
        this.minRetryIntervalInSeconds = minRetryIntervalInSeconds;
        return this;
    }

    /**
     * Get the stopRetryAfterInSeconds property: stop retry data ingestion after the data slice first schedule time in
     * seconds.
     *
     * @return the stopRetryAfterInSeconds value.
     */
    public Long getStopRetryAfterInSeconds() {
        return this.stopRetryAfterInSeconds;
    }

    /**
     * Set the stopRetryAfterInSeconds property: stop retry data ingestion after the data slice first schedule time in
     * seconds.
     *
     * @param stopRetryAfterInSeconds the stopRetryAfterInSeconds value to set.
     * @return the DataFeedDetailPatch object itself.
     */
    public DataFeedDetailPatch setStopRetryAfterInSeconds(Long stopRetryAfterInSeconds) {
        this.stopRetryAfterInSeconds = stopRetryAfterInSeconds;
        return this;
    }

    /**
     * Get the needRollup property: mark if the data feed need rollup.
     *
     * @return the needRollup value.
     */
    public NeedRollupEnum getNeedRollup() {
        return this.needRollup;
    }

    /**
     * Set the needRollup property: mark if the data feed need rollup.
     *
     * @param needRollup the needRollup value to set.
     * @return the DataFeedDetailPatch object itself.
     */
    public DataFeedDetailPatch setNeedRollup(NeedRollupEnum needRollup) {
        this.needRollup = needRollup;
        return this;
    }

    /**
     * Get the rollUpMethod property: roll up method.
     *
     * @return the rollUpMethod value.
     */
    public RollUpMethod getRollUpMethod() {
        return this.rollUpMethod;
    }

    /**
     * Set the rollUpMethod property: roll up method.
     *
     * @param rollUpMethod the rollUpMethod value to set.
     * @return the DataFeedDetailPatch object itself.
     */
    public DataFeedDetailPatch setRollUpMethod(RollUpMethod rollUpMethod) {
        this.rollUpMethod = rollUpMethod;
        return this;
    }

    /**
     * Get the rollUpColumns property: roll up columns.
     *
     * @return the rollUpColumns value.
     */
    public List<String> getRollUpColumns() {
        return this.rollUpColumns;
    }

    /**
     * Set the rollUpColumns property: roll up columns.
     *
     * @param rollUpColumns the rollUpColumns value to set.
     * @return the DataFeedDetailPatch object itself.
     */
    public DataFeedDetailPatch setRollUpColumns(List<String> rollUpColumns) {
        this.rollUpColumns = rollUpColumns;
        return this;
    }

    /**
     * Get the allUpIdentification property: the identification value for the row of calculated all-up value.
     *
     * @return the allUpIdentification value.
     */
    public String getAllUpIdentification() {
        return this.allUpIdentification;
    }

    /**
     * Set the allUpIdentification property: the identification value for the row of calculated all-up value.
     *
     * @param allUpIdentification the allUpIdentification value to set.
     * @return the DataFeedDetailPatch object itself.
     */
    public DataFeedDetailPatch setAllUpIdentification(String allUpIdentification) {
        this.allUpIdentification = allUpIdentification;
        return this;
    }

    /**
     * Get the fillMissingPointType property: the type of fill missing point for anomaly detection.
     *
     * @return the fillMissingPointType value.
     */
    public FillMissingPointType getFillMissingPointType() {
        return this.fillMissingPointType;
    }

    /**
     * Set the fillMissingPointType property: the type of fill missing point for anomaly detection.
     *
     * @param fillMissingPointType the fillMissingPointType value to set.
     * @return the DataFeedDetailPatch object itself.
     */
    public DataFeedDetailPatch setFillMissingPointType(FillMissingPointType fillMissingPointType) {
        this.fillMissingPointType = fillMissingPointType;
        return this;
    }

    /**
     * Get the fillMissingPointValue property: the value of fill missing point for anomaly detection.
     *
     * @return the fillMissingPointValue value.
     */
    public Double getFillMissingPointValue() {
        return this.fillMissingPointValue;
    }

    /**
     * Set the fillMissingPointValue property: the value of fill missing point for anomaly detection.
     *
     * @param fillMissingPointValue the fillMissingPointValue value to set.
     * @return the DataFeedDetailPatch object itself.
     */
    public DataFeedDetailPatch setFillMissingPointValue(Double fillMissingPointValue) {
        this.fillMissingPointValue = fillMissingPointValue;
        return this;
    }

    /**
     * Get the viewMode property: data feed access mode, default is Private.
     *
     * @return the viewMode value.
     */
    public ViewMode getViewMode() {
        return this.viewMode;
    }

    /**
     * Set the viewMode property: data feed access mode, default is Private.
     *
     * @param viewMode the viewMode value to set.
     * @return the DataFeedDetailPatch object itself.
     */
    public DataFeedDetailPatch setViewMode(ViewMode viewMode) {
        this.viewMode = viewMode;
        return this;
    }

    /**
     * Get the admins property: data feed administrator.
     *
     * @return the admins value.
     */
    public List<String> getAdmins() {
        return this.admins;
    }

    /**
     * Set the admins property: data feed administrator.
     *
     * @param admins the admins value to set.
     * @return the DataFeedDetailPatch object itself.
     */
    public DataFeedDetailPatch setAdmins(List<String> admins) {
        this.admins = admins;
        return this;
    }

    /**
     * Get the viewers property: data feed viewer.
     *
     * @return the viewers value.
     */
    public List<String> getViewers() {
        return this.viewers;
    }

    /**
     * Set the viewers property: data feed viewer.
     *
     * @param viewers the viewers value to set.
     * @return the DataFeedDetailPatch object itself.
     */
    public DataFeedDetailPatch setViewers(List<String> viewers) {
        this.viewers = viewers;
        return this;
    }

    /**
     * Get the status property: data feed status.
     *
     * @return the status value.
     */
    public EntityStatus getStatus() {
        return this.status;
    }

    /**
     * Set the status property: data feed status.
     *
     * @param status the status value to set.
     * @return the DataFeedDetailPatch object itself.
     */
    public DataFeedDetailPatch setStatus(EntityStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the actionLinkTemplate property: action link for alert.
     *
     * @return the actionLinkTemplate value.
     */
    public String getActionLinkTemplate() {
        return this.actionLinkTemplate;
    }

    /**
     * Set the actionLinkTemplate property: action link for alert.
     *
     * @param actionLinkTemplate the actionLinkTemplate value to set.
     * @return the DataFeedDetailPatch object itself.
     */
    public DataFeedDetailPatch setActionLinkTemplate(String actionLinkTemplate) {
        this.actionLinkTemplate = actionLinkTemplate;
        return this;
    }

    /**
     * Get the authenticationType property: authentication type for corresponding data source.
     *
     * @return the authenticationType value.
     */
    public AuthenticationTypeEnum getAuthenticationType() {
        return this.authenticationType;
    }

    /**
     * Set the authenticationType property: authentication type for corresponding data source.
     *
     * @param authenticationType the authenticationType value to set.
     * @return the DataFeedDetailPatch object itself.
     */
    public DataFeedDetailPatch setAuthenticationType(AuthenticationTypeEnum authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    /**
     * Get the credentialId property: The credential entity id.
     *
     * @return the credentialId value.
     */
    public String getCredentialId() {
        return this.credentialId;
    }

    /**
     * Set the credentialId property: The credential entity id.
     *
     * @param credentialId the credentialId value to set.
     * @return the DataFeedDetailPatch object itself.
     */
    public DataFeedDetailPatch setCredentialId(String credentialId) {
        this.credentialId = credentialId;
        return this;
    }
}
