// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.implementation.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for DataFeedDetailPatchNeedRollup. */
public final class DataFeedDetailPatchNeedRollup extends ExpandableStringEnum<DataFeedDetailPatchNeedRollup> {
    /** Static value NoRollup for DataFeedDetailPatchNeedRollup. */
    public static final DataFeedDetailPatchNeedRollup NO_ROLLUP = fromString("NoRollup");

    /** Static value NeedRollup for DataFeedDetailPatchNeedRollup. */
    public static final DataFeedDetailPatchNeedRollup NEED_ROLLUP = fromString("NeedRollup");

    /** Static value AlreadyRollup for DataFeedDetailPatchNeedRollup. */
    public static final DataFeedDetailPatchNeedRollup ALREADY_ROLLUP = fromString("AlreadyRollup");

    /**
     * Creates or finds a DataFeedDetailPatchNeedRollup from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding DataFeedDetailPatchNeedRollup.
     */
    @JsonCreator
    public static DataFeedDetailPatchNeedRollup fromString(String name) {
        return fromString(name, DataFeedDetailPatchNeedRollup.class);
    }

    /** @return known DataFeedDetailPatchNeedRollup values. */
    public static Collection<DataFeedDetailPatchNeedRollup> values() {
        return values(DataFeedDetailPatchNeedRollup.class);
    }
}
