// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.implementation.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for DataSourceType. */
public final class DataSourceType extends ExpandableStringEnum<DataSourceType> {
    /** Static value AzureApplicationInsights for DataSourceType. */
    public static final DataSourceType AZURE_APPLICATION_INSIGHTS = fromString("AzureApplicationInsights");

    /** Static value AzureBlob for DataSourceType. */
    public static final DataSourceType AZURE_BLOB = fromString("AzureBlob");

    /** Static value AzureCosmosDB for DataSourceType. */
    public static final DataSourceType AZURE_COSMOS_DB = fromString("AzureCosmosDB");

    /** Static value AzureDataExplorer for DataSourceType. */
    public static final DataSourceType AZURE_DATA_EXPLORER = fromString("AzureDataExplorer");

    /** Static value AzureDataLakeStorageGen2 for DataSourceType. */
    public static final DataSourceType AZURE_DATA_LAKE_STORAGE_GEN2 = fromString("AzureDataLakeStorageGen2");

    /** Static value AzureEventHubs for DataSourceType. */
    public static final DataSourceType AZURE_EVENT_HUBS = fromString("AzureEventHubs");

    /** Static value AzureLogAnalytics for DataSourceType. */
    public static final DataSourceType AZURE_LOG_ANALYTICS = fromString("AzureLogAnalytics");

    /** Static value AzureTable for DataSourceType. */
    public static final DataSourceType AZURE_TABLE = fromString("AzureTable");

    /** Static value InfluxDB for DataSourceType. */
    public static final DataSourceType INFLUX_DB = fromString("InfluxDB");

    /** Static value MongoDB for DataSourceType. */
    public static final DataSourceType MONGO_DB = fromString("MongoDB");

    /** Static value MySql for DataSourceType. */
    public static final DataSourceType MY_SQL = fromString("MySql");

    /** Static value PostgreSql for DataSourceType. */
    public static final DataSourceType POSTGRE_SQL = fromString("PostgreSql");

    /** Static value SqlServer for DataSourceType. */
    public static final DataSourceType SQL_SERVER = fromString("SqlServer");

    /**
     * Creates or finds a DataSourceType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding DataSourceType.
     */
    @JsonCreator
    public static DataSourceType fromString(String name) {
        return fromString(name, DataSourceType.class);
    }

    /** @return known DataSourceType values. */
    public static Collection<DataSourceType> values() {
        return values(DataSourceType.class);
    }
}
