// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** The DetectionAnomalyResultQuery model. */
@Fluent
public final class DetectionAnomalyResultQuery {
    /*
     * start time
     */
    @JsonProperty(value = "startTime", required = true)
    private OffsetDateTime startTime;

    /*
     * end time
     */
    @JsonProperty(value = "endTime", required = true)
    private OffsetDateTime endTime;

    /*
     * The filter property.
     */
    @JsonProperty(value = "filter")
    private DetectionAnomalyFilterCondition filter;

    /**
     * Get the startTime property: start time.
     *
     * @return the startTime value.
     */
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: start time.
     *
     * @param startTime the startTime value to set.
     * @return the DetectionAnomalyResultQuery object itself.
     */
    public DetectionAnomalyResultQuery setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the endTime property: end time.
     *
     * @return the endTime value.
     */
    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    /**
     * Set the endTime property: end time.
     *
     * @param endTime the endTime value to set.
     * @return the DetectionAnomalyResultQuery object itself.
     */
    public DetectionAnomalyResultQuery setEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    /**
     * Get the filter property: The filter property.
     *
     * @return the filter value.
     */
    public DetectionAnomalyFilterCondition getFilter() {
        return this.filter;
    }

    /**
     * Set the filter property: The filter property.
     *
     * @param filter the filter value to set.
     * @return the DetectionAnomalyResultQuery object itself.
     */
    public DetectionAnomalyResultQuery setFilter(DetectionAnomalyFilterCondition filter) {
        this.filter = filter;
        return this;
    }
}
