// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** The EnrichmentStatusQueryOption model. */
@Fluent
public final class EnrichmentStatusQueryOption {
    /*
     * the start point of time range to query anomaly detection status.
     */
    @JsonProperty(value = "startTime", required = true)
    private OffsetDateTime startTime;

    /*
     * the end point of time range to query anomaly detection status.
     */
    @JsonProperty(value = "endTime", required = true)
    private OffsetDateTime endTime;

    /**
     * Get the startTime property: the start point of time range to query anomaly detection status.
     *
     * @return the startTime value.
     */
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: the start point of time range to query anomaly detection status.
     *
     * @param startTime the startTime value to set.
     * @return the EnrichmentStatusQueryOption object itself.
     */
    public EnrichmentStatusQueryOption setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the endTime property: the end point of time range to query anomaly detection status.
     *
     * @return the endTime value.
     */
    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    /**
     * Set the endTime property: the end point of time range to query anomaly detection status.
     *
     * @param endTime the endTime value to set.
     * @return the EnrichmentStatusQueryOption object itself.
     */
    public EnrichmentStatusQueryOption setEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }
}
