// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.implementation.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for FillMissingPointType. */
public final class FillMissingPointType extends ExpandableStringEnum<FillMissingPointType> {
    /** Static value SmartFilling for FillMissingPointType. */
    public static final FillMissingPointType SMART_FILLING = fromString("SmartFilling");

    /** Static value PreviousValue for FillMissingPointType. */
    public static final FillMissingPointType PREVIOUS_VALUE = fromString("PreviousValue");

    /** Static value CustomValue for FillMissingPointType. */
    public static final FillMissingPointType CUSTOM_VALUE = fromString("CustomValue");

    /** Static value NoFilling for FillMissingPointType. */
    public static final FillMissingPointType NO_FILLING = fromString("NoFilling");

    /**
     * Creates or finds a FillMissingPointType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding FillMissingPointType.
     */
    @JsonCreator
    public static FillMissingPointType fromString(String name) {
        return fromString(name, FillMissingPointType.class);
    }

    /** @return known FillMissingPointType values. */
    public static Collection<FillMissingPointType> values() {
        return values(FillMissingPointType.class);
    }
}
