// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** The IngestionProgressResetOptions model. */
@Fluent
public final class IngestionProgressResetOptions {
    /*
     * the start point of time range to reset data ingestion status.
     */
    @JsonProperty(value = "startTime", required = true)
    private OffsetDateTime startTime;

    /*
     * the end point of time range to reset data ingestion status.
     */
    @JsonProperty(value = "endTime", required = true)
    private OffsetDateTime endTime;

    /**
     * Get the startTime property: the start point of time range to reset data ingestion status.
     *
     * @return the startTime value.
     */
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: the start point of time range to reset data ingestion status.
     *
     * @param startTime the startTime value to set.
     * @return the IngestionProgressResetOptions object itself.
     */
    public IngestionProgressResetOptions setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the endTime property: the end point of time range to reset data ingestion status.
     *
     * @return the endTime value.
     */
    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    /**
     * Set the endTime property: the end point of time range to reset data ingestion status.
     *
     * @param endTime the endTime value to set.
     * @return the IngestionProgressResetOptions object itself.
     */
    public IngestionProgressResetOptions setEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }
}
