// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The MetricDimensionQueryOptions model. */
@Fluent
public final class MetricDimensionQueryOptions {
    /*
     * dimension name
     */
    @JsonProperty(value = "dimensionName", required = true)
    private String dimensionName;

    /*
     * dimension value to be filtered
     */
    @JsonProperty(value = "dimensionValueFilter")
    private String dimensionValueFilter;

    /**
     * Get the dimensionName property: dimension name.
     *
     * @return the dimensionName value.
     */
    public String getDimensionName() {
        return this.dimensionName;
    }

    /**
     * Set the dimensionName property: dimension name.
     *
     * @param dimensionName the dimensionName value to set.
     * @return the MetricDimensionQueryOptions object itself.
     */
    public MetricDimensionQueryOptions setDimensionName(String dimensionName) {
        this.dimensionName = dimensionName;
        return this;
    }

    /**
     * Get the dimensionValueFilter property: dimension value to be filtered.
     *
     * @return the dimensionValueFilter value.
     */
    public String getDimensionValueFilter() {
        return this.dimensionValueFilter;
    }

    /**
     * Set the dimensionValueFilter property: dimension value to be filtered.
     *
     * @param dimensionValueFilter the dimensionValueFilter value to set.
     * @return the MetricDimensionQueryOptions object itself.
     */
    public MetricDimensionQueryOptions setDimensionValueFilter(String dimensionValueFilter) {
        this.dimensionValueFilter = dimensionValueFilter;
        return this;
    }
}
