// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/** The MetricSeriesData model. */
@Fluent
public final class MetricSeriesData {
    /*
     * The id property.
     */
    @JsonProperty(value = "id")
    private MetricSeriesItem id;

    /*
     * timestamps of the data related to this time series
     */
    @JsonProperty(value = "timestampList", access = JsonProperty.Access.WRITE_ONLY)
    private List<OffsetDateTime> timestampList;

    /*
     * values of the data related to this time series
     */
    @JsonProperty(value = "valueList", access = JsonProperty.Access.WRITE_ONLY)
    private List<Double> valueList;

    /**
     * Get the id property: The id property.
     *
     * @return the id value.
     */
    public MetricSeriesItem getId() {
        return this.id;
    }

    /**
     * Set the id property: The id property.
     *
     * @param id the id value to set.
     * @return the MetricSeriesData object itself.
     */
    public MetricSeriesData setId(MetricSeriesItem id) {
        this.id = id;
        return this;
    }

    /**
     * Get the timestampList property: timestamps of the data related to this time series.
     *
     * @return the timestampList value.
     */
    public List<OffsetDateTime> getTimestampList() {
        return this.timestampList;
    }

    /**
     * Get the valueList property: values of the data related to this time series.
     *
     * @return the valueList value.
     */
    public List<Double> getValueList() {
        return this.valueList;
    }
}
