// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

/** The MetricSeriesQueryOptions model. */
@Fluent
public final class MetricSeriesQueryOptions {
    /*
     * query series ingested after this time, the format should be
     * yyyy-MM-ddTHH:mm:ssZ
     */
    @JsonProperty(value = "activeSince", required = true)
    private OffsetDateTime activeSince;

    /*
     * filter specific dimension name and values
     */
    @JsonProperty(value = "dimensionFilter")
    private Map<String, List<String>> dimensionFilter;

    /**
     * Get the activeSince property: query series ingested after this time, the format should be yyyy-MM-ddTHH:mm:ssZ.
     *
     * @return the activeSince value.
     */
    public OffsetDateTime getActiveSince() {
        return this.activeSince;
    }

    /**
     * Set the activeSince property: query series ingested after this time, the format should be yyyy-MM-ddTHH:mm:ssZ.
     *
     * @param activeSince the activeSince value to set.
     * @return the MetricSeriesQueryOptions object itself.
     */
    public MetricSeriesQueryOptions setActiveSince(OffsetDateTime activeSince) {
        this.activeSince = activeSince;
        return this;
    }

    /**
     * Get the dimensionFilter property: filter specific dimension name and values.
     *
     * @return the dimensionFilter value.
     */
    public Map<String, List<String>> getDimensionFilter() {
        return this.dimensionFilter;
    }

    /**
     * Set the dimensionFilter property: filter specific dimension name and values.
     *
     * @param dimensionFilter the dimensionFilter value to set.
     * @return the MetricSeriesQueryOptions object itself.
     */
    public MetricSeriesQueryOptions setDimensionFilter(Map<String, List<String>> dimensionFilter) {
        this.dimensionFilter = dimensionFilter;
        return this;
    }
}
