// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.implementation.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for NeedRollupEnum. */
public final class NeedRollupEnum extends ExpandableStringEnum<NeedRollupEnum> {
    /** Static value NoRollup for NeedRollupEnum. */
    public static final NeedRollupEnum NO_ROLLUP = fromString("NoRollup");

    /** Static value NeedRollup for NeedRollupEnum. */
    public static final NeedRollupEnum NEED_ROLLUP = fromString("NeedRollup");

    /** Static value AlreadyRollup for NeedRollupEnum. */
    public static final NeedRollupEnum ALREADY_ROLLUP = fromString("AlreadyRollup");

    /**
     * Creates or finds a NeedRollupEnum from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding NeedRollupEnum.
     */
    @JsonCreator
    public static NeedRollupEnum fromString(String name) {
        return fromString(name, NeedRollupEnum.class);
    }

    /** @return known NeedRollupEnum values. */
    public static Collection<NeedRollupEnum> values() {
        return values(NeedRollupEnum.class);
    }
}
