// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.implementation.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for RollUpMethod. */
public final class RollUpMethod extends ExpandableStringEnum<RollUpMethod> {
    /** Static value None for RollUpMethod. */
    public static final RollUpMethod NONE = fromString("None");

    /** Static value Sum for RollUpMethod. */
    public static final RollUpMethod SUM = fromString("Sum");

    /** Static value Max for RollUpMethod. */
    public static final RollUpMethod MAX = fromString("Max");

    /** Static value Min for RollUpMethod. */
    public static final RollUpMethod MIN = fromString("Min");

    /** Static value Avg for RollUpMethod. */
    public static final RollUpMethod AVG = fromString("Avg");

    /** Static value Count for RollUpMethod. */
    public static final RollUpMethod COUNT = fromString("Count");

    /**
     * Creates or finds a RollUpMethod from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding RollUpMethod.
     */
    @JsonCreator
    public static RollUpMethod fromString(String name) {
        return fromString(name, RollUpMethod.class);
    }

    /** @return known RollUpMethod values. */
    public static Collection<RollUpMethod> values() {
        return values(RollUpMethod.class);
    }
}
