// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The ServicePrincipalInKVParamPatch model. */
@Fluent
public final class ServicePrincipalInKVParamPatch {
    /*
     * The Key Vault endpoint that storing the service principal.
     */
    @JsonProperty(value = "keyVaultEndpoint")
    private String keyVaultEndpoint;

    /*
     * The Client Id to access the Key Vault.
     */
    @JsonProperty(value = "keyVaultClientId")
    private String keyVaultClientId;

    /*
     * The Client Secret to access the Key Vault.
     */
    @JsonProperty(value = "keyVaultClientSecret")
    private String keyVaultClientSecret;

    /*
     * The secret name of the service principal's client Id in the Key Vault.
     */
    @JsonProperty(value = "servicePrincipalIdNameInKV")
    private String servicePrincipalIdNameInKV;

    /*
     * The secret name of the service principal's client secret in the Key
     * Vault.
     */
    @JsonProperty(value = "servicePrincipalSecretNameInKV")
    private String servicePrincipalSecretNameInKV;

    /*
     * The tenant id of your service principal.
     */
    @JsonProperty(value = "tenantId")
    private String tenantId;

    /**
     * Get the keyVaultEndpoint property: The Key Vault endpoint that storing the service principal.
     *
     * @return the keyVaultEndpoint value.
     */
    public String getKeyVaultEndpoint() {
        return this.keyVaultEndpoint;
    }

    /**
     * Set the keyVaultEndpoint property: The Key Vault endpoint that storing the service principal.
     *
     * @param keyVaultEndpoint the keyVaultEndpoint value to set.
     * @return the ServicePrincipalInKVParamPatch object itself.
     */
    public ServicePrincipalInKVParamPatch setKeyVaultEndpoint(String keyVaultEndpoint) {
        this.keyVaultEndpoint = keyVaultEndpoint;
        return this;
    }

    /**
     * Get the keyVaultClientId property: The Client Id to access the Key Vault.
     *
     * @return the keyVaultClientId value.
     */
    public String getKeyVaultClientId() {
        return this.keyVaultClientId;
    }

    /**
     * Set the keyVaultClientId property: The Client Id to access the Key Vault.
     *
     * @param keyVaultClientId the keyVaultClientId value to set.
     * @return the ServicePrincipalInKVParamPatch object itself.
     */
    public ServicePrincipalInKVParamPatch setKeyVaultClientId(String keyVaultClientId) {
        this.keyVaultClientId = keyVaultClientId;
        return this;
    }

    /**
     * Get the keyVaultClientSecret property: The Client Secret to access the Key Vault.
     *
     * @return the keyVaultClientSecret value.
     */
    public String getKeyVaultClientSecret() {
        return this.keyVaultClientSecret;
    }

    /**
     * Set the keyVaultClientSecret property: The Client Secret to access the Key Vault.
     *
     * @param keyVaultClientSecret the keyVaultClientSecret value to set.
     * @return the ServicePrincipalInKVParamPatch object itself.
     */
    public ServicePrincipalInKVParamPatch setKeyVaultClientSecret(String keyVaultClientSecret) {
        this.keyVaultClientSecret = keyVaultClientSecret;
        return this;
    }

    /**
     * Get the servicePrincipalIdNameInKV property: The secret name of the service principal's client Id in the Key
     * Vault.
     *
     * @return the servicePrincipalIdNameInKV value.
     */
    public String getServicePrincipalIdNameInKV() {
        return this.servicePrincipalIdNameInKV;
    }

    /**
     * Set the servicePrincipalIdNameInKV property: The secret name of the service principal's client Id in the Key
     * Vault.
     *
     * @param servicePrincipalIdNameInKV the servicePrincipalIdNameInKV value to set.
     * @return the ServicePrincipalInKVParamPatch object itself.
     */
    public ServicePrincipalInKVParamPatch setServicePrincipalIdNameInKV(String servicePrincipalIdNameInKV) {
        this.servicePrincipalIdNameInKV = servicePrincipalIdNameInKV;
        return this;
    }

    /**
     * Get the servicePrincipalSecretNameInKV property: The secret name of the service principal's client secret in the
     * Key Vault.
     *
     * @return the servicePrincipalSecretNameInKV value.
     */
    public String getServicePrincipalSecretNameInKV() {
        return this.servicePrincipalSecretNameInKV;
    }

    /**
     * Set the servicePrincipalSecretNameInKV property: The secret name of the service principal's client secret in the
     * Key Vault.
     *
     * @param servicePrincipalSecretNameInKV the servicePrincipalSecretNameInKV value to set.
     * @return the ServicePrincipalInKVParamPatch object itself.
     */
    public ServicePrincipalInKVParamPatch setServicePrincipalSecretNameInKV(String servicePrincipalSecretNameInKV) {
        this.servicePrincipalSecretNameInKV = servicePrincipalSecretNameInKV;
        return this;
    }

    /**
     * Get the tenantId property: The tenant id of your service principal.
     *
     * @return the tenantId value.
     */
    public String getTenantId() {
        return this.tenantId;
    }

    /**
     * Set the tenantId property: The tenant id of your service principal.
     *
     * @param tenantId the tenantId value to set.
     * @return the ServicePrincipalInKVParamPatch object itself.
     */
    public ServicePrincipalInKVParamPatch setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }
}
