// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The ServicePrincipalParamPatch model. */
@Fluent
public final class ServicePrincipalParamPatch {
    /*
     * The client id of the service principal.
     */
    @JsonProperty(value = "clientId")
    private String clientId;

    /*
     * The client secret of the service principal.
     */
    @JsonProperty(value = "clientSecret")
    private String clientSecret;

    /*
     * The tenant id of the service principal.
     */
    @JsonProperty(value = "tenantId")
    private String tenantId;

    /**
     * Get the clientId property: The client id of the service principal.
     *
     * @return the clientId value.
     */
    public String getClientId() {
        return this.clientId;
    }

    /**
     * Set the clientId property: The client id of the service principal.
     *
     * @param clientId the clientId value to set.
     * @return the ServicePrincipalParamPatch object itself.
     */
    public ServicePrincipalParamPatch setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    /**
     * Get the clientSecret property: The client secret of the service principal.
     *
     * @return the clientSecret value.
     */
    public String getClientSecret() {
        return this.clientSecret;
    }

    /**
     * Set the clientSecret property: The client secret of the service principal.
     *
     * @param clientSecret the clientSecret value to set.
     * @return the ServicePrincipalParamPatch object itself.
     */
    public ServicePrincipalParamPatch setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    /**
     * Get the tenantId property: The tenant id of the service principal.
     *
     * @return the tenantId value.
     */
    public String getTenantId() {
        return this.tenantId;
    }

    /**
     * Set the tenantId property: The tenant id of the service principal.
     *
     * @param tenantId the tenantId value to set.
     * @return the ServicePrincipalParamPatch object itself.
     */
    public ServicePrincipalParamPatch setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }
}
