// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.implementation.models;

import com.azure.ai.metricsadvisor.administration.models.AnomalySeverity;
import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The SeverityCondition model. */
@Fluent
public final class SeverityCondition {
    /*
     * min alert severity
     */
    @JsonProperty(value = "minAlertSeverity", required = true)
    private AnomalySeverity minAlertSeverity;

    /*
     * max alert severity
     */
    @JsonProperty(value = "maxAlertSeverity", required = true)
    private AnomalySeverity maxAlertSeverity;

    /**
     * Get the minAlertSeverity property: min alert severity.
     *
     * @return the minAlertSeverity value.
     */
    public AnomalySeverity getMinAlertSeverity() {
        return this.minAlertSeverity;
    }

    /**
     * Set the minAlertSeverity property: min alert severity.
     *
     * @param minAlertSeverity the minAlertSeverity value to set.
     * @return the SeverityCondition object itself.
     */
    public SeverityCondition setMinAlertSeverity(AnomalySeverity minAlertSeverity) {
        this.minAlertSeverity = minAlertSeverity;
        return this;
    }

    /**
     * Get the maxAlertSeverity property: max alert severity.
     *
     * @return the maxAlertSeverity value.
     */
    public AnomalySeverity getMaxAlertSeverity() {
        return this.maxAlertSeverity;
    }

    /**
     * Set the maxAlertSeverity property: max alert severity.
     *
     * @param maxAlertSeverity the maxAlertSeverity value to set.
     * @return the SeverityCondition object itself.
     */
    public SeverityCondition setMaxAlertSeverity(AnomalySeverity maxAlertSeverity) {
        this.maxAlertSeverity = maxAlertSeverity;
        return this;
    }
}
