// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.implementation.models;

import com.azure.ai.metricsadvisor.administration.models.AnomalyDetectorDirection;
import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The SmartDetectionCondition model. */
@Fluent
public final class SmartDetectionCondition {
    /*
     * sensitivity, value range : (0, 100]
     */
    @JsonProperty(value = "sensitivity", required = true)
    private double sensitivity;

    /*
     * detection direction
     */
    @JsonProperty(value = "anomalyDetectorDirection", required = true)
    private AnomalyDetectorDirection anomalyDetectorDirection;

    /*
     * The suppressCondition property.
     */
    @JsonProperty(value = "suppressCondition", required = true)
    private SuppressCondition suppressCondition;

    /**
     * Get the sensitivity property: sensitivity, value range : (0, 100].
     *
     * @return the sensitivity value.
     */
    public double getSensitivity() {
        return this.sensitivity;
    }

    /**
     * Set the sensitivity property: sensitivity, value range : (0, 100].
     *
     * @param sensitivity the sensitivity value to set.
     * @return the SmartDetectionCondition object itself.
     */
    public SmartDetectionCondition setSensitivity(double sensitivity) {
        this.sensitivity = sensitivity;
        return this;
    }

    /**
     * Get the anomalyDetectorDirection property: detection direction.
     *
     * @return the anomalyDetectorDirection value.
     */
    public AnomalyDetectorDirection getAnomalyDetectorDirection() {
        return this.anomalyDetectorDirection;
    }

    /**
     * Set the anomalyDetectorDirection property: detection direction.
     *
     * @param anomalyDetectorDirection the anomalyDetectorDirection value to set.
     * @return the SmartDetectionCondition object itself.
     */
    public SmartDetectionCondition setAnomalyDetectorDirection(AnomalyDetectorDirection anomalyDetectorDirection) {
        this.anomalyDetectorDirection = anomalyDetectorDirection;
        return this;
    }

    /**
     * Get the suppressCondition property: The suppressCondition property.
     *
     * @return the suppressCondition value.
     */
    public SuppressCondition getSuppressCondition() {
        return this.suppressCondition;
    }

    /**
     * Set the suppressCondition property: The suppressCondition property.
     *
     * @param suppressCondition the suppressCondition value to set.
     * @return the SmartDetectionCondition object itself.
     */
    public SmartDetectionCondition setSuppressCondition(SuppressCondition suppressCondition) {
        this.suppressCondition = suppressCondition;
        return this;
    }
}
