// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.implementation.util;

import com.azure.ai.metricsadvisor.administration.models.AnomalyAlertConfiguration;

import java.util.List;

/**
 * The helper class to set the non-public properties of an {@link AnomalyAlertConfiguration} instance.
 */
public final class AnomalyAlertConfigurationHelper {
    private static AnomalyAlertConfigurationAccessor accessor;

    private AnomalyAlertConfigurationHelper() { }

    /**
     * Type defining the methods to set the non-public properties of an {@link AnomalyAlertConfiguration} instance.
     */
    public interface AnomalyAlertConfigurationAccessor {
        void setId(AnomalyAlertConfiguration configuration, String id);
        List<String> getHookIdsToAlertRaw(AnomalyAlertConfiguration configuration);
        List<String> getDimensionsToSplitAlertRaw(AnomalyAlertConfiguration configuration);
    }

    /**
     * The method called from {@link AnomalyAlertConfiguration} to set it's accessor.
     *
     * @param configurationAccessor The accessor.
     */
    public static void setAccessor(final AnomalyAlertConfigurationAccessor configurationAccessor) {
        accessor = configurationAccessor;
    }

    static void setId(AnomalyAlertConfiguration configuration, String id) {
        accessor.setId(configuration, id);
    }

    static List<String> getHookIdsToAlertRaw(AnomalyAlertConfiguration configuration) {
        return accessor.getHookIdsToAlertRaw(configuration);
    }

    static List<String> getDimensionsToSplitAlertRaw(AnomalyAlertConfiguration configuration) {
        return accessor.getDimensionsToSplitAlertRaw(configuration);
    }
}
