// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.implementation.util;

import com.azure.ai.metricsadvisor.administration.models.BoundaryDirection;
import com.azure.ai.metricsadvisor.administration.models.MetricBoundaryCondition;

/**
 * The helper class to set the non-public properties of an {@link MetricBoundaryCondition} instance.
 */
public final class MetricBoundaryConditionHelper {
    private static MetricBoundaryConditionAccessor accessor;

    private MetricBoundaryConditionHelper() { }

    /**
     * Type defining the methods to set the non-public properties of an {@link MetricBoundaryCondition} instance.
     */
    public interface MetricBoundaryConditionAccessor {
        void setLowerBoundary(MetricBoundaryCondition condition, Double lowerBoundary);
        void setUpperBoundary(MetricBoundaryCondition condition, Double upperBoundary);
        void setBoundaryDirection(MetricBoundaryCondition condition, BoundaryDirection boundaryDirection);
    }

    /**
     * The method called from {@link MetricBoundaryCondition} to set it's accessor.
     *
     * @param boundaryConditionAccessor The accessor.
     */
    public static void setAccessor(final MetricBoundaryConditionAccessor boundaryConditionAccessor) {
        accessor = boundaryConditionAccessor;
    }

    static void setLowerBoundary(MetricBoundaryCondition condition, Double lowerBoundary) {
        accessor.setLowerBoundary(condition, lowerBoundary);
    }

    static void setUpperBoundary(MetricBoundaryCondition condition, Double upperBoundary) {
        accessor.setUpperBoundary(condition, upperBoundary);
    }

    static void setBoundaryDirection(MetricBoundaryCondition condition, BoundaryDirection boundaryDirection) {
        accessor.setBoundaryDirection(condition, boundaryDirection);
    }
}
