// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** The EnrichmentStatus model. */
@Immutable
public final class EnrichmentStatus {
    /*
     * data slice timestamp.
     */
    @JsonProperty(value = "timestamp", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime timestamp;

    /*
     * latest enrichment status for this data slice.
     */
    @JsonProperty(value = "status", access = JsonProperty.Access.WRITE_ONLY)
    private String status;

    /*
     * the trimmed message describes details of the enrichment status.
     */
    @JsonProperty(value = "message", access = JsonProperty.Access.WRITE_ONLY)
    private String message;

    /**
     * Get the timestamp property: data slice timestamp.
     *
     * @return the timestamp value.
     */
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    /**
     * Get the status property: latest enrichment status for this data slice.
     *
     * @return the status value.
     */
    public String getStatus() {
        return this.status;
    }

    /**
     * Get the message property: the trimmed message describes details of the enrichment status.
     *
     * @return the message value.
     */
    public String getMessage() {
        return this.message;
    }
}
