// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for FeedbackType. */
public final class FeedbackType extends ExpandableStringEnum<FeedbackType> {
    /** Static value Anomaly for FeedbackType. */
    public static final FeedbackType ANOMALY = fromString("Anomaly");

    /** Static value ChangePoint for FeedbackType. */
    public static final FeedbackType CHANGE_POINT = fromString("ChangePoint");

    /** Static value Period for FeedbackType. */
    public static final FeedbackType PERIOD = fromString("Period");

    /** Static value Comment for FeedbackType. */
    public static final FeedbackType COMMENT = fromString("Comment");

    /**
     * Creates or finds a FeedbackType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding FeedbackType.
     */
    @JsonCreator
    public static FeedbackType fromString(String name) {
        return fromString(name, FeedbackType.class);
    }

    /** @return known FeedbackType values. */
    public static Collection<FeedbackType> values() {
        return values(FeedbackType.class);
    }
}
