// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.metricsadvisor.models;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpResponse;

/** Exception thrown for an invalid response with ErrorCode information. */
public final class MetricsAdvisorResponseException extends HttpResponseException {
    /**
     * Initializes a new instance of the MetricsAdvisorResponseException class.
     *
     * @param message the exception message or the response content if a message is not available.
     * @param response the HTTP response.
     */
    public MetricsAdvisorResponseException(String message, HttpResponse response) {
        super(message, response);
    }

    /**
     * Initializes a new instance of the MetricsAdvisorResponseException class.
     *
     * @param message the exception message or the response content if a message is not available.
     * @param response the HTTP response.
     * @param value the deserialized response value.
     */
    public MetricsAdvisorResponseException(String message, HttpResponse response, MetricsAdvisorError value) {
        super(message, response, value);
    }

    @Override
    public MetricsAdvisorError getValue() {
        return (MetricsAdvisorError) super.getValue();
    }
}
